/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet;

import com.tridium.bacnet.datatypes.BChangeDeviceIdConfig;
import com.tridium.bacnet.datatypes.BDeviceDiscoveryConfig;
import com.tridium.bacnet.datatypes.BTimeSynchConfig;
import com.tridium.bacnet.datatypes.BWhoHasConfig;
import com.tridium.bacnet.job.BBacnetDiscoverDevicesJob;
import com.tridium.bacnet.job.BChangeDeviceIdJob;
import com.tridium.bacnet.job.BTimeSynchJob;
import com.tridium.bacnet.job.BWhoHasJob;
import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.server.cov.BBacnetCovWorker;
import com.tridium.util.ComponentTreeCursor;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.agent.AgentList;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetDeviceFolder;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.BBacnetComm;
import javax.baja.bacnet.point.BBacnetTuningPolicy;
import javax.baja.bacnet.point.BBacnetTuningPolicyMap;
import javax.baja.bacnet.util.BBacnetWorker;
import javax.baja.bacnet.util.BIBacnetPollable;
import javax.baja.driver.loadable.BLoadableNetwork;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.driver.util.BAbstractPollService;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Array;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetNetwork
extends BLoadableNetwork
implements BacnetConst,
BIService {
    public static final Property worker = BBacnetNetwork.newProperty((int)4, (BValue)new BBacnetWorker(), null);
    public static final Property writeWorker = BBacnetNetwork.newProperty((int)4, (BValue)new BBacnetWorker(), null);
    public static final Property bacnetComm = BBacnetNetwork.newProperty((int)0, (BValue)new BBacnetStack(), null);
    public static final Property localDevice = BBacnetNetwork.newProperty((int)0, (BValue)new BLocalBacnetDevice(), null);
    public static final Property tuningPolicies = BBacnetNetwork.newProperty((int)0, (BValue)new BBacnetTuningPolicyMap(), null);
    public static final Property covWorker = BBacnetNetwork.newProperty((int)4, (BValue)new BBacnetCovWorker(), null);
    public static final Action submitDeviceManagerJob = BBacnetNetwork.newAction((int)4, (BValue)new BDeviceDiscoveryConfig(), null);
    public static final Action lookupDeviceById = BBacnetNetwork.newAction((int)4, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Action lookupDeviceByAddress = BBacnetNetwork.newAction((int)4, (BValue)BBacnetAddress.DEFAULT, null);
    public static final Action lookupDeviceOrdById = BBacnetNetwork.newAction((int)4, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Action lookupDeviceOrdByAddress = BBacnetNetwork.newAction((int)4, (BValue)BBacnetAddress.DEFAULT, null);
    public static final Type TYPE;
    private static Type[] serviceTypes;
    public static final String UPLOAD_ON_START = "uploadOnStart";
    private static BBacnetNetwork bacnetService;
    protected static final Log log;
    private boolean networkReady;
    private BBoolean uploadOnStart;
    private Hashtable ordByObjectId;
    private Hashtable ordByAddress;
    static /* synthetic */ Class class$javax$baja$bacnet$BBacnetNetwork;
    static /* synthetic */ Class class$javax$baja$bacnet$BBacnetDevice;
    static /* synthetic */ Class class$javax$baja$nav$BINavNode;

    public BBacnetWorker getWorker() {
        return (BBacnetWorker)this.get(worker);
    }

    public void setWorker(BBacnetWorker bBacnetWorker) {
        this.set(worker, (BValue)bBacnetWorker, null);
    }

    public BBacnetWorker getWriteWorker() {
        return (BBacnetWorker)this.get(writeWorker);
    }

    public void setWriteWorker(BBacnetWorker bBacnetWorker) {
        this.set(writeWorker, (BValue)bBacnetWorker, null);
    }

    public BBacnetComm getBacnetComm() {
        return (BBacnetComm)this.get(bacnetComm);
    }

    public void setBacnetComm(BBacnetComm bBacnetComm) {
        this.set(bacnetComm, (BValue)bBacnetComm, null);
    }

    public BLocalBacnetDevice getLocalDevice() {
        return (BLocalBacnetDevice)this.get(localDevice);
    }

    public void setLocalDevice(BLocalBacnetDevice bLocalBacnetDevice) {
        this.set(localDevice, (BValue)bLocalBacnetDevice, null);
    }

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap bTuningPolicyMap) {
        this.set(tuningPolicies, (BValue)bTuningPolicyMap, null);
    }

    public BBacnetCovWorker getCovWorker() {
        return (BBacnetCovWorker)this.get(covWorker);
    }

    public void setCovWorker(BBacnetCovWorker bBacnetCovWorker) {
        this.set(covWorker, (BValue)bBacnetCovWorker, null);
    }

    public BOrd submitDeviceManagerJob(BValue bValue) {
        return (BOrd)this.invoke(submitDeviceManagerJob, bValue, null);
    }

    public BBacnetDevice lookupDeviceById(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return (BBacnetDevice)this.invoke(lookupDeviceById, (BValue)bBacnetObjectIdentifier, null);
    }

    public BBacnetDevice lookupDeviceByAddress(BBacnetAddress bBacnetAddress) {
        return (BBacnetDevice)this.invoke(lookupDeviceByAddress, (BValue)bBacnetAddress, null);
    }

    public BOrd lookupDeviceOrdById(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return (BOrd)this.invoke(lookupDeviceOrdById, (BValue)bBacnetObjectIdentifier, null);
    }

    public BOrd lookupDeviceOrdByAddress(BBacnetAddress bBacnetAddress) {
        return (BOrd)this.invoke(lookupDeviceOrdByAddress, (BValue)bBacnetAddress, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final void serviceStarted() {
        bacnetService = this;
    }

    public final void serviceStopped() {
        bacnetService = null;
    }

    public boolean isChildLegal(BComponent bComponent) {
        return bComponent instanceof BLocalBacnetDevice ^ true;
    }

    public void started() throws Exception {
        try {
            super.started();
            if (Sys.getService((Type)TYPE) != this) {
                this.configFail("Duplicate BacnetNetwork");
                throw new IllegalStateException("Only one BacnetNetwork allowed per station!");
            }
            this.setUploadOnStart();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("BACnet Network not registered as a service!");
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.isDynamic() && property.getName().equalsIgnoreCase(UPLOAD_ON_START)) {
            this.uploadOnStart = this.setUploadOnStart();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        ((BBacnetStack)this.getBacnetComm()).getNetwork().networkReady();
        ((BBacnetStack)this.getBacnetComm()).getServer().iAm();
        this.networkReady = true;
        var1_1 = this.getProperties();
        if (true) ** GOTO lbl9
        do {
            ((BBacnetDevice)var1_1.get()).networkReady();
lbl9:
            // 2 sources

            if ((v0 = BBacnetNetwork.class$javax$baja$bacnet$BBacnetDevice) != null) continue;
            v0 = BBacnetNetwork.class("[Ljavax.baja.bacnet.BBacnetDevice;", false);
        } while (var1_1.next(v0));
    }

    public void descendantsStopped() throws Exception {
        super.descendantsStopped();
        ((BBacnetStack)this.getBacnetComm()).stopStack();
    }

    public Type getDeviceType() {
        return BBacnetDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BBacnetDeviceFolder.TYPE;
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] bINavNodeArray = super.getNavChildren();
        Class clazz = class$javax$baja$nav$BINavNode;
        if (clazz == null) {
            clazz = class$javax$baja$nav$BINavNode = BBacnetNetwork.class("[Ljavax.baja.nav.BINavNode;", false);
        }
        Array array = new Array(clazz);
        array.add((Object)this.getLocalDevice());
        array.add((Object)this.getBacnetComm());
        array.add((Object)this.getMonitor());
        array.add((Object)this.getTuningPolicies());
        int n = 0;
        while (n < bINavNodeArray.length) {
            array.add((Object)bINavNodeArray[n]);
            ++n;
        }
        return (BINavNode[])array.trim();
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "bacnet");
    }

    public boolean isAws() {
        return false;
    }

    public IFuture postAsync(Runnable runnable) {
        return this.getWorker().post(runnable);
    }

    public IFuture postWrite(Runnable runnable) {
        return this.getWriteWorker().post(runnable);
    }

    public BOrd doSubmitDeviceManagerJob(BValue bValue, Context context) {
        if (this.isFatalFault()) {
            return null;
        }
        Type type = bValue.getType();
        if (type.is(BWhoHasConfig.TYPE)) {
            return new BWhoHasJob(this, (BWhoHasConfig)bValue).submit(context);
        }
        if (type.is(BDeviceDiscoveryConfig.TYPE)) {
            return new BBacnetDiscoverDevicesJob(this, (BDeviceDiscoveryConfig)bValue).submit(context);
        }
        if (type.is(BTimeSynchConfig.TYPE)) {
            return new BTimeSynchJob(this, (BTimeSynchConfig)bValue).submit(context);
        }
        if (type.is(BChangeDeviceIdConfig.TYPE)) {
            return new BChangeDeviceIdJob(this, (BChangeDeviceIdConfig)bValue).submit(context);
        }
        return BOrd.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BBacnetDevice doLookupDeviceById(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        if (bBacnetObjectIdentifier == null) {
            return null;
        }
        if (bBacnetObjectIdentifier.getInstanceNumber() < 0) {
            return null;
        }
        BBacnetNetwork bBacnetNetwork = this;
        synchronized (bBacnetNetwork) {
            BOrd bOrd = (BOrd)this.ordByObjectId.get((Object)bBacnetObjectIdentifier);
            if (bOrd == null) {
                return null;
            }
            try {
                return (BBacnetDevice)bOrd.get((BObject)this);
            }
            catch (UnresolvedException unresolvedException) {
                this.ordByObjectId.remove(bOrd);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BBacnetDevice doLookupDeviceByAddress(BBacnetAddress bBacnetAddress) {
        if (bBacnetAddress == null) {
            return null;
        }
        if (bBacnetAddress.equals(BBacnetAddress.DEFAULT)) {
            return null;
        }
        BBacnetNetwork bBacnetNetwork = this;
        synchronized (bBacnetNetwork) {
            BOrd bOrd = (BOrd)this.ordByAddress.get(new Integer(bBacnetAddress.hash()));
            if (bOrd == null) {
                return null;
            }
            try {
                return (BBacnetDevice)bOrd.get((BObject)this);
            }
            catch (UnresolvedException unresolvedException) {
                this.ordByAddress.remove(bOrd);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BOrd doLookupDeviceOrdById(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        if (bBacnetObjectIdentifier == null) {
            return null;
        }
        if (bBacnetObjectIdentifier.getInstanceNumber() < 0) {
            return null;
        }
        BBacnetNetwork bBacnetNetwork = this;
        synchronized (bBacnetNetwork) {
            return (BOrd)this.ordByObjectId.get((Object)bBacnetObjectIdentifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BOrd doLookupDeviceOrdByAddress(BBacnetAddress bBacnetAddress) {
        if (bBacnetAddress == null) {
            return null;
        }
        if (bBacnetAddress.equals(BBacnetAddress.DEFAULT)) {
            return null;
        }
        BBacnetNetwork bBacnetNetwork = this;
        synchronized (bBacnetNetwork) {
            return (BOrd)this.ordByAddress.get(new Integer(bBacnetAddress.hash()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerDevice(BBacnetDevice bBacnetDevice) {
        BBacnetNetwork bBacnetNetwork = this;
        synchronized (bBacnetNetwork) {
            this.ordByObjectId.put(bBacnetDevice.getObjectId(), bBacnetDevice.getOrdInSession());
            this.ordByAddress.put(new Integer(bBacnetDevice.getAddress().hash()), bBacnetDevice.getOrdInSession());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterDevice(BBacnetDevice bBacnetDevice) {
        BBacnetNetwork bBacnetNetwork = this;
        synchronized (bBacnetNetwork) {
            this.ordByObjectId.values().remove(bBacnetDevice.getOrdInSession());
            this.ordByAddress.values().remove(bBacnetDevice.getOrdInSession());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateDevice(BBacnetDevice bBacnetDevice) {
        BBacnetNetwork bBacnetNetwork = this;
        synchronized (bBacnetNetwork) {
            this.ordByObjectId.values().remove(bBacnetDevice.getOrdInSession());
            this.ordByObjectId.put(bBacnetDevice.getObjectId(), bBacnetDevice.getOrdInSession());
            this.ordByAddress.values().remove(bBacnetDevice.getOrdInSession());
            this.ordByAddress.put(new Integer(bBacnetDevice.getAddress().hash()), bBacnetDevice.getOrdInSession());
            return;
        }
    }

    public BBacnetDevice lookupDevice(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return this.doLookupDeviceById(bBacnetObjectIdentifier);
    }

    public BBacnetDevice lookupDevice(BBacnetAddress bBacnetAddress) {
        return this.doLookupDeviceByAddress(bBacnetAddress);
    }

    public void updateDeviceInfo(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetAddress bBacnetAddress, int n, BBacnetSegmentation bBacnetSegmentation, int n2) {
        BBacnetDevice bBacnetDevice;
        if (log.isTraceOn()) {
            log.trace("Updating device data for {" + (Object)((Object)bBacnetObjectIdentifier) + '}');
        }
        if ((bBacnetDevice = this.doLookupDeviceById(bBacnetObjectIdentifier)) != null) {
            if (log.isTraceOn()) {
                log.trace("Updating device data for " + bBacnetDevice.getName() + " {" + (Object)((Object)bBacnetObjectIdentifier) + '}');
            }
            bBacnetDevice.updateDeviceInfo(bBacnetObjectIdentifier, bBacnetAddress, n, bBacnetSegmentation, n2, this.network().getPortByNetwork(bBacnetAddress.getNetworkNumber()));
        }
    }

    /*
     * Unable to fully structure code
     */
    public BBacnetDevice[] getDeviceList() {
        v0 = BBacnetNetwork.class$javax$baja$bacnet$BBacnetDevice;
        if (v0 == null) {
            v0 = BBacnetNetwork.class$javax$baja$bacnet$BBacnetDevice = BBacnetNetwork.class("[Ljavax.baja.bacnet.BBacnetDevice;", false);
        }
        var1_1 = new Array(v0);
        var2_2 = new ComponentTreeCursor((BComponent)this, null);
        if (true) ** GOTO lbl10
        do {
            var1_1.add((Object)((BBacnetDevice)var2_2.get()));
lbl10:
            // 2 sources

            if ((v1 = BBacnetNetwork.class$javax$baja$bacnet$BBacnetDevice) != null) continue;
            v1 = BBacnetNetwork.class("[Ljavax.baja.bacnet.BBacnetDevice;", false);
        } while (var2_2.next(v1));
        return (BBacnetDevice[])var1_1.trim();
    }

    public BBacnetObjectIdentifier getObjectId() {
        return this.getLocalDevice().getObjectId();
    }

    public static final BBacnetNetwork bacnet() {
        try {
            if (Sys.getStation() == null) {
                return bacnetService;
            }
            return (BBacnetNetwork)Sys.getService((Type)TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("Unable to locate Bacnet Service!", (Throwable)serviceNotFoundException);
            return null;
        }
    }

    public static final BLocalBacnetDevice localDevice() {
        try {
            if (Sys.getStation() == null) {
                if (bacnetService != null) {
                    return bacnetService.getLocalDevice();
                }
                throw new ServiceNotFoundException("BacnetNetwork service not initialized!");
            }
            return ((BBacnetNetwork)Sys.getService((Type)TYPE)).getLocalDevice();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("Unable to locate Bacnet Service!", (Throwable)serviceNotFoundException);
            return null;
        }
    }

    public boolean isNetworkReady() {
        return this.networkReady;
    }

    public BAbstractPollService getPollService(BIBacnetPollable bIBacnetPollable) {
        return this.poll(bIBacnetPollable.device().getAddress().getNetworkNumber());
    }

    public void tuningChanged(BBacnetTuningPolicy bBacnetTuningPolicy, Context context) {
        BBacnetDevice[] bBacnetDeviceArray = this.getDeviceList();
        int n = 0;
        while (n < bBacnetDeviceArray.length) {
            bBacnetDeviceArray[n].tuningChanged(bBacnetTuningPolicy, context);
            ++n;
        }
    }

    public BBoolean uploadOnStart() {
        if (this.uploadOnStart == null) {
            this.uploadOnStart = this.setUploadOnStart();
        }
        return this.uploadOnStart;
    }

    private final BBoolean setUploadOnStart() {
        BValue bValue = this.get(UPLOAD_ON_START);
        BBoolean bBoolean = BBoolean.TRUE;
        if (bValue == null) {
            this.add(UPLOAD_ON_START, (BValue)bBoolean);
        } else if (bValue instanceof BBoolean) {
            bBoolean = (BBoolean)bValue;
        }
        return bBoolean;
    }

    BBacnetClientLayer client() {
        return ((BBacnetStack)this.getBacnetComm()).getClient();
    }

    BBacnetServerLayer server() {
        return ((BBacnetStack)this.getBacnetComm()).getServer();
    }

    BBacnetNetworkLayer network() {
        return ((BBacnetStack)this.getBacnetComm()).getNetwork();
    }

    final BBacnetPoll poll(int n) {
        BNetworkPort bNetworkPort = this.network().getPortByDNET(n);
        if (bNetworkPort == null) {
            bNetworkPort = this.network().getIpPort();
        }
        return bNetworkPort.getPollService();
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.remove("driver:DeviceManager");
        return agentList;
    }

    private final int hashtableSize(Hashtable hashtable) {
        int n = 0;
        int n2 = 0;
        Enumeration<Object> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ++n;
            enumeration.nextElement();
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ++n2;
            enumeration.nextElement();
        }
        if (n2 != n) {
            System.out.println("HASHTABLE SIZE MISMATCH: ksize=" + n2 + "; vsize=" + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spy(SpyWriter spyWriter) throws Exception {
        Object object;
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetNetwork", 2);
        spyWriter.prop((Object)"networkReady", this.networkReady);
        spyWriter.prop((Object)"bacnetService", (Object)bacnetService);
        spyWriter.prop((Object)"bacnet()", (Object)BBacnetNetwork.bacnet());
        if (this.isRunning()) {
            object = Sys.getService((Type)TYPE);
            spyWriter.prop((Object)"service", object);
        }
        spyWriter.prop((Object)"this", (Object)this);
        object = this;
        synchronized (object) {
            Object object2;
            Enumeration enumeration;
            block7: {
                spyWriter.trTitle((Object)("ordByObjectId reported size:" + this.ordByObjectId.size() + "; actual size:" + this.hashtableSize(this.ordByObjectId)), 2);
                enumeration = this.ordByObjectId.keys();
                if (this.ordByObjectId.size() >= 1000) break block7;
                while (enumeration.hasMoreElements()) {
                    object2 = enumeration.nextElement();
                    spyWriter.prop((Object)("  " + object2), this.ordByObjectId.get(object2));
                }
            }
            spyWriter.trTitle((Object)("ordByAddress reported size:" + this.ordByAddress.size() + "; actual size:" + this.hashtableSize(this.ordByAddress)), 2);
            enumeration = this.ordByAddress.keys();
            if (this.ordByAddress.size() < 1000) {
                while (enumeration.hasMoreElements()) {
                    object2 = (Integer)enumeration.nextElement();
                    int n = (Integer)object2;
                    int n2 = n >> 16 & (char)-1;
                    int n3 = n & (char)-1;
                    String string = "" + n2 + ':' + (Object)((Object)BBacnetOctetString.lookup(n3));
                    spyWriter.prop((Object)string, this.ordByAddress.get(object2));
                }
            }
        }
        BBacnetOctetString.spyImpl(spyWriter);
        spyWriter.endProps();
    }

    public String toString(Context context) {
        return super.toString(context) + this.getHandleOrd();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.networkReady = false;
        this.uploadOnStart = null;
        this.ordByObjectId = new Hashtable();
        this.ordByAddress = new Hashtable();
    }

    public BBacnetNetwork() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$BBacnetNetwork;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$BBacnetNetwork = BBacnetNetwork.class("[Ljavax.baja.bacnet.BBacnetNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        serviceTypes = new Type[]{TYPE};
        bacnetService = null;
        log = Log.getLog((String)"bacnet");
        UnitDatabase.getDefault();
    }
}

