/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.ObjectTypeList;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadAccessSpec;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.history.BBacnetHistoryDeviceExt;
import com.tridium.bacnet.schedule.BBacnetScheduleDeviceExt;
import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import com.tridium.bacnet.stack.link.ethernet.BBacnetEthernetLinkLayer;
import com.tridium.bacnet.stack.link.ip.BBacnetIpLinkLayer;
import com.tridium.bacnet.stack.link.mstp.BBacnetMstpLinkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.stack.transport.TransactionException;
import javax.baja.bacnet.BBacnetDeviceFolder;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BIBacnetObjectContainer;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.alarm.BBacnetAlarmDeviceExt;
import javax.baja.bacnet.config.BBacnetConfigDeviceExt;
import javax.baja.bacnet.config.BBacnetDeviceObject;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.enums.BExtensibleEnumList;
import javax.baja.bacnet.io.AbortException;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.point.BBacnetPointDeviceExt;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.point.BBacnetTuningPolicy;
import javax.baja.bacnet.util.BIBacnetPollable;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.util.PollList;
import javax.baja.bacnet.util.PollListEntry;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.bacnet.virtual.BBacnetVirtualGateway;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BLoadableDevice;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.schedule.driver.BScheduleDeviceExt;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetDevice
extends BLoadableDevice
implements BacnetConst,
BIBacnetPollable,
BIBacnetObjectContainer {
    public static final Property address = BBacnetDevice.newProperty((int)0, (BValue)BBacnetAddress.LOCAL_BROADCAST_ADDRESS, null);
    public static final Property points = BBacnetDevice.newProperty((int)0, (BValue)new BBacnetPointDeviceExt(), null);
    public static final Property virtual = BBacnetDevice.newProperty((int)0, (BValue)new BBacnetVirtualGateway(), null);
    public static final Property alarms = BBacnetDevice.newProperty((int)0, (BValue)new BBacnetAlarmDeviceExt(), null);
    public static final Property schedules = BBacnetDevice.newProperty((int)0, (BValue)new BBacnetScheduleDeviceExt(), null);
    public static final Property trendLogs = BBacnetDevice.newProperty((int)0, (BValue)new BBacnetHistoryDeviceExt(), null);
    public static final Property config = BBacnetDevice.newProperty((int)0, (BValue)new BBacnetConfigDeviceExt(), null);
    public static final Property enumerationList = BBacnetDevice.newProperty((int)0, (BValue)new BExtensibleEnumList(), null);
    public static final Property useCov = BBacnetDevice.newProperty((int)0, (boolean)false, null);
    public static final Property maxCovSubscriptions = BBacnetDevice.newProperty((int)0, (int)Integer.MAX_VALUE, null);
    public static final Property covSubscriptions = BBacnetDevice.newProperty((int)3, (int)0, null);
    public static final Property pollFrequency = BBacnetDevice.newProperty((int)5, (BValue)BPollFrequency.normal, null);
    public static final Property characterSet = BBacnetDevice.newProperty((int)1, (BValue)BCharacterSetEncoding.ansiX3_4, null);
    public static final Property maxPollTimeouts = BBacnetDevice.newProperty((int)4, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Action macAddressFailed = BBacnetDevice.newAction((int)4, null);
    public static final Type TYPE;
    protected static final int MINIMUM_COV_SUBSCRIPTION_LIFETIME = 300;
    private static final Lexicon lex;
    public static final Log log;
    public static final Log plog;
    private static final int MIN_APDU = 50;
    private static final String SKIP_UPLOAD = "skipUpload";
    private boolean rpmOk;
    private int maxAPDU;
    private BBacnetAddress oldAddress;
    private boolean isPolling;
    private int pollTimeouts;
    private ObjectTypeList vendorObjectTypesList;
    private BBoolean isAws;
    private Object TICKET_LOCK;
    private Clock.Ticket staleTicket;
    private long lastPingTime;
    static /* synthetic */ Class class$javax$baja$bacnet$BBacnetDevice;

    public BBacnetAddress getAddress() {
        return (BBacnetAddress)this.get(address);
    }

    public void setAddress(BBacnetAddress bBacnetAddress) {
        this.set(address, (BValue)bBacnetAddress, null);
    }

    public BBacnetPointDeviceExt getPoints() {
        return (BBacnetPointDeviceExt)this.get(points);
    }

    public void setPoints(BBacnetPointDeviceExt bBacnetPointDeviceExt) {
        this.set(points, (BValue)bBacnetPointDeviceExt, null);
    }

    public BBacnetVirtualGateway getVirtual() {
        return (BBacnetVirtualGateway)this.get(virtual);
    }

    public void setVirtual(BBacnetVirtualGateway bBacnetVirtualGateway) {
        this.set(virtual, (BValue)bBacnetVirtualGateway, null);
    }

    public BBacnetAlarmDeviceExt getAlarms() {
        return (BBacnetAlarmDeviceExt)this.get(alarms);
    }

    public void setAlarms(BBacnetAlarmDeviceExt bBacnetAlarmDeviceExt) {
        this.set(alarms, (BValue)bBacnetAlarmDeviceExt, null);
    }

    public BScheduleDeviceExt getSchedules() {
        return (BScheduleDeviceExt)this.get(schedules);
    }

    public void setSchedules(BScheduleDeviceExt bScheduleDeviceExt) {
        this.set(schedules, (BValue)bScheduleDeviceExt, null);
    }

    public BHistoryDeviceExt getTrendLogs() {
        return (BHistoryDeviceExt)this.get(trendLogs);
    }

    public void setTrendLogs(BHistoryDeviceExt bHistoryDeviceExt) {
        this.set(trendLogs, (BValue)bHistoryDeviceExt, null);
    }

    public BBacnetConfigDeviceExt getConfig() {
        return (BBacnetConfigDeviceExt)this.get(config);
    }

    public void setConfig(BBacnetConfigDeviceExt bBacnetConfigDeviceExt) {
        this.set(config, (BValue)bBacnetConfigDeviceExt, null);
    }

    public BExtensibleEnumList getEnumerationList() {
        return (BExtensibleEnumList)this.get(enumerationList);
    }

    public void setEnumerationList(BExtensibleEnumList bExtensibleEnumList) {
        this.set(enumerationList, (BValue)bExtensibleEnumList, null);
    }

    public boolean getUseCov() {
        return this.getBoolean(useCov);
    }

    public void setUseCov(boolean bl) {
        this.setBoolean(useCov, bl, null);
    }

    public int getMaxCovSubscriptions() {
        return this.getInt(maxCovSubscriptions);
    }

    public void setMaxCovSubscriptions(int n) {
        this.setInt(maxCovSubscriptions, n, null);
    }

    public int getCovSubscriptions() {
        return this.getInt(covSubscriptions);
    }

    public void setCovSubscriptions(int n) {
        this.setInt(covSubscriptions, n, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public BCharacterSetEncoding getCharacterSet() {
        return (BCharacterSetEncoding)this.get(characterSet);
    }

    public void setCharacterSet(BCharacterSetEncoding bCharacterSetEncoding) {
        this.set(characterSet, (BValue)bCharacterSetEncoding, null);
    }

    public int getMaxPollTimeouts() {
        return this.getInt(maxPollTimeouts);
    }

    public void setMaxPollTimeouts(int n) {
        this.setInt(maxPollTimeouts, n, null);
    }

    public void macAddressFailed() {
        this.invoke(macAddressFailed, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BBacnetDevice device() {
        return this;
    }

    public final int getPollableType() {
        return 0;
    }

    public boolean poll() {
        System.out.println("BBacnetDevice.poll() is no longer used.");
        return true;
    }

    public final void readFail(String string) {
    }

    public final void fromEncodedValue(byte[] byArray, BStatus bStatus, Context context) {
    }

    public final PollListEntry[] getPollListEntries() {
        return new PollListEntry[0];
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BacnetDevice {").append(this.getName()).append("}");
        return stringBuffer.toString();
    }

    public final BBacnetObjectIdentifier getObjectId() {
        return this.getDeviceObject().getObjectId();
    }

    public final void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier, Context context) {
        this.getDeviceObject().set(BBacnetObject.objectId, (BValue)bBacnetObjectIdentifier, context);
    }

    public final void objectIdChanged() {
        if (this.getObjectId().isValid()) {
            this.configOk();
            this.network().postAsync(new Runnable(){

                public final void run() {
                    BBacnetDevice.this.checkAddress();
                    BBacnetDevice.this.upload(new BUploadParameters(false));
                }
            });
        } else {
            this.configFail("Invalid Device Object ID");
        }
    }

    public final int getMaxAPDULengthAccepted() {
        return Math.max(this.maxAPDU, 50);
    }

    public final void setMaxAPDULengthAccepted(int n, Context context) {
        this.maxAPDU = n;
    }

    public final BBacnetSegmentation getSegmentationSupported() {
        return this.getDeviceObject().getSegmentationSupported();
    }

    public final void setSegmentationSupported(BBacnetSegmentation bBacnetSegmentation, Context context) {
        this.getDeviceObject().set(BBacnetDeviceObject.segmentationSupported, (BValue)bBacnetSegmentation, context);
    }

    public final int getMaxSegmentsAccepted() {
        return this.getDeviceObject().getMaxSegmentsAccepted();
    }

    public final int getVendorId() {
        return this.getDeviceObject().getVendorIdentifier().getInt();
    }

    public final void setVendorId(int n, Context context) {
        this.getDeviceObject().set(BBacnetDeviceObject.vendorIdentifier, (BValue)BBacnetUnsigned.make(n), context);
    }

    public boolean isServiceSupported(int n) {
        return this.getDeviceObject().getProtocolServicesSupported().getBit(n);
    }

    public boolean isServiceSupported(String string) {
        return this.getDeviceObject().getProtocolServicesSupported().getBit(BacnetBitStringUtil.getBitIndex("BacnetServicesSupported", string));
    }

    public boolean isObjectTypeSupported(int n) {
        return this.getDeviceObject().getProtocolObjectTypesSupported().getBit(n);
    }

    public final int getProtocolRevision() {
        return this.getDeviceObject().getProtocolRevision().getInt();
    }

    public BValue getObjectListStaleTime() {
        return this.get("objectListStaleTime");
    }

    protected BBacnetNetwork network() {
        return (BBacnetNetwork)this.getNetwork();
    }

    private final BBacnetClientLayer client() {
        return ((BBacnetStack)this.network().getBacnetComm()).getClient();
    }

    private final BBacnetDeviceObject getDeviceObject() {
        return this.getConfig().getDeviceObject();
    }

    public boolean isAddressValid() {
        BBacnetAddress bBacnetAddress = this.getAddress();
        boolean bl = false;
        if (bBacnetAddress != null && !bBacnetAddress.getMacAddress().isNull()) {
            bl = true;
        }
        return bl;
    }

    public void checkAddress() {
        try {
            this.client().whoIs(BBacnetAddress.GLOBAL_BROADCAST_ADDRESS, this.getObjectId().getInstanceNumber(), this.getObjectId().getInstanceNumber());
        }
        catch (BacnetException bacnetException) {
            log.error("BacnetException checking address for " + this + ": " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
        }
    }

    private final boolean isAws() {
        if (this.isAws == null) {
            this.isAws = BBoolean.FALSE;
            try {
                BOrd bOrd = BOrd.make((String)"service:bacnet:BacnetNetwork");
                BBacnetNetwork bBacnetNetwork = (BBacnetNetwork)bOrd.get((BObject)this);
                if (bBacnetNetwork != null && bBacnetNetwork.getType().getTypeName().indexOf("Aws") >= 0) {
                    this.isAws = BBoolean.TRUE;
                }
            }
            catch (Exception exception) {
                log.message("Could not determine AWS status for " + this + ':' + exception);
            }
        }
        return this.isAws.getBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void started() throws Exception {
        super.started();
        if (!this.getObjectId().isValid()) {
            this.configFail("Invalid Device Object ID");
            return;
        }
        this.checkForDuplicateDeviceId();
        if (!this.isAddressValid()) {
            this.setStatus(BStatus.stale);
            this.checkAddress();
            Object object = this.TICKET_LOCK;
            synchronized (object) {
                if (this.staleTicket == null) {
                    this.staleTicket = Clock.schedule((BComponent)this, (BRelTime)this.network().getMonitor().getStartupAlarmDelay(), (Action)macAddressFailed, null);
                }
            }
        }
        this.initializeDevice();
    }

    public void updateServicesSupported() {
        this.rpmOk = this.isServiceSupported("readPropertyMultiple");
    }

    private final int getMaxAPDU() {
        int n = this.getDeviceObject().getMaxAPDULengthAccepted().getInt();
        if (n <= 50 && this.isAddressValid()) {
            int n2 = DeviceRegistry.getMaxApduLengthSupported(this.getAddress());
            n = Math.max(n, n2);
        }
        return n;
    }

    private final BBacnetSegmentation checkSegmentationSupported() {
        BBacnetSegmentation bBacnetSegmentation;
        BBacnetSegmentation bBacnetSegmentation2 = this.getDeviceObject().getSegmentationSupported();
        if (bBacnetSegmentation2 == BBacnetSegmentation.noSegmentation && this.isAddressValid() && (bBacnetSegmentation = DeviceRegistry.getSegmentationSupported(this.getAddress())) != BBacnetSegmentation.noSegmentation) {
            bBacnetSegmentation2 = bBacnetSegmentation;
        }
        return bBacnetSegmentation2;
    }

    protected void initializeDevice() {
        this.oldAddress = this.getAddress();
        this.updateServicesSupported();
        this.checkSegmentationSupported();
        this.maxAPDU = this.getMaxAPDU();
        if (this.maxAPDU > 50) {
            this.getConfig().getDeviceObject().set(BBacnetDeviceObject.maxAPDULengthAccepted, (BValue)BBacnetUnsigned.make(this.maxAPDU), BacnetConst.noWrite);
        }
        this.isAws = null;
        BBacnetNetwork.localDevice().addAddressBinding(this);
        DeviceRegistry.update(this);
        BBacnetNetwork.bacnet().registerDevice(this);
        ((BBacnetScheduleDeviceExt)this.getSchedules()).setSupport(this.getProtocolRevision());
        this.network().postAsync(new Runnable(){

            public final void run() {
                BBacnetDevice.this.getVendorObjectTypesList();
            }
        });
    }

    private final void checkForDuplicateDeviceId() {
        BBacnetDevice bBacnetDevice = this.network().doLookupDeviceById(this.getObjectId());
        if (bBacnetDevice != null && bBacnetDevice != this) {
            this.configFail("Duplicate Device Object ID");
            this.setObjectId(BBacnetObjectIdentifier.make(8), null);
            return;
        }
    }

    public void descendantsStarted() {
        if (this.network().isNetworkReady()) {
            this.networkReady();
        }
    }

    protected boolean uploadOnStart() {
        BValue bValue = this.get(SKIP_UPLOAD);
        boolean bl = false;
        if (bValue == null || bValue.equals((Object)BBoolean.FALSE)) {
            bl = true;
        }
        return bl;
    }

    void networkReady() {
        if (this.getObjectId().isValid() && this.getStatus().isValid() && this.uploadOnStart()) {
            this.postUpload();
        }
    }

    private final void postUpload() {
        this.network().postAsync(new Runnable(){

            public final void run() {
                try {
                    if (!BBacnetDevice.this.isAddressValid()) {
                        BBacnetDevice.this.checkAddress();
                    } else {
                        BBacnetDevice.this.doUpload(new BUploadParameters(), null);
                        if (!BBacnetDevice.this.network().uploadOnStart().getBoolean()) {
                            BacUtil.setOrAdd((BComponent)BBacnetDevice.this, BBacnetDevice.SKIP_UPLOAD, (BValue)BBoolean.make((boolean)true), 4, null, null);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public void stopped() throws Exception {
        super.stopped();
        BBacnetNetwork.bacnet().unregisterDevice(this);
        try {
            BBacnetNetwork.localDevice().removeAddressBinding(this);
        }
        catch (NotRunningException notRunningException) {}
        DeviceRegistry.remove(this.getObjectId());
    }

    public void added(Property property, Context context) {
        super.added(property, context);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning() || context == BacnetConst.fallback) {
            return;
        }
        if (property.equals((Object)status)) {
            this.getVirtual().updateStatus();
        } else if (property.equals((Object)useCov)) {
            this.tuningChanged(null, context);
        } else if (property.equals((Object)address)) {
            BBacnetAddress bBacnetAddress = this.getAddress();
            BBacnetNetwork bBacnetNetwork = BBacnetNetwork.bacnet();
            if (context != BacnetConst.noWrite) {
                if (bBacnetAddress.equals(this.oldAddress.getNetworkNumber(), this.oldAddress.getMacAddress().getBytes())) {
                    return;
                }
                BBacnetDevice bBacnetDevice = bBacnetNetwork.doLookupDeviceByAddress(bBacnetAddress);
                if (bBacnetDevice != null && bBacnetDevice != this) {
                    log.error("Duplicate Address:" + bBacnetAddress + ", used by " + bBacnetDevice.getName() + "!\n  Resetting to old address:" + this.oldAddress);
                    this.set(address, (BValue)this.oldAddress, BacnetConst.fallback);
                    return;
                }
                if (log.isTraceOn()) {
                    log.trace("BacnetDevice " + this.getName() + " Address changed from " + this.oldAddress + " to " + bBacnetAddress);
                }
                this.upload(new BUploadParameters(false));
            }
            if (this.oldAddress == null) {
                this.oldAddress = BBacnetAddress.DEFAULT;
            }
            bBacnetNetwork.getLocalDevice().updateAddressBinding(this.oldAddress, bBacnetAddress);
            bBacnetNetwork.updateDevice(this);
            DeviceRegistry.update(this);
            this.oldAddress = (BBacnetAddress)bBacnetAddress.newCopy(true);
        } else if (property.getName().equals("vendorObjectTypesFile")) {
            this.network().postAsync(new Runnable(){

                public final void run() {
                    BBacnetDevice.this.getVendorObjectTypesList();
                }
            });
        }
    }

    public void subscribed() {
        this.getConfig().getDeviceObject().loadSlots();
        if (!this.isRunning()) {
            return;
        }
    }

    public boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof BBacnetNetwork || bComponent instanceof BBacnetDeviceFolder) {
            bl = true;
        }
        return bl;
    }

    public Type getNetworkType() {
        return BBacnetNetwork.TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateDeviceInfo(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetAddress bBacnetAddress, int n, BBacnetSegmentation bBacnetSegmentation, int n2, BNetworkPort bNetworkPort) {
        Object object;
        log.trace("Update Device info: " + this);
        this.maxAPDU = Math.max(50, n);
        this.getConfig().getDeviceObject().set(BBacnetDeviceObject.maxAPDULengthAccepted, (BValue)BBacnetUnsigned.make(this.maxAPDU), BacnetConst.noWrite);
        this.setSegmentationSupported(bBacnetSegmentation, BacnetConst.noWrite);
        this.setVendorId(n2, BacnetConst.noWrite);
        BBacnetAddress bBacnetAddress2 = (BBacnetAddress)bBacnetAddress.newCopy();
        bBacnetAddress2.setAddressType(this.getAddress().getAddressType());
        if (bNetworkPort != null && bNetworkPort.getNetworkNumber() == bBacnetAddress.getNetworkNumber() && this.getAddress().getAddressType() == 0) {
            object = bNetworkPort.getLink();
            if (object instanceof BBacnetIpLinkLayer) {
                bBacnetAddress2.setAddressType(2);
            } else if (object instanceof BBacnetEthernetLinkLayer) {
                bBacnetAddress2.setAddressType(1);
            } else if (object instanceof BBacnetMstpLinkLayer) {
                bBacnetAddress2.setAddressType(3);
            }
        }
        this.set(address, (BValue)bBacnetAddress2, BacnetConst.noWrite);
        object = this.getStatus();
        if (object.isDown()) {
            if (!object.isDisabled()) {
                this.readSystemStatus();
            }
        } else if (!object.isDisabled()) {
            this.pingOk();
        }
        if (object.isStale()) {
            Object object2 = this.TICKET_LOCK;
            synchronized (object2) {
                if (this.staleTicket != null) {
                    this.staleTicket.cancel();
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 12] lbl33 : MonitorExitStatement: MONITOREXIT : var9_9
                this.clearStaleFlag();
            }
            this.updateStatus();
            this.postUpload();
        }
        DeviceRegistry.update(this);
    }

    public void doPing() {
        log.trace("doPing on " + this);
        BStatus bStatus = this.getStatus();
        if ((bStatus.getBits() & 3) != 0) {
            return;
        }
        if (this.isAddressValid()) {
            long l = 0L;
            if (!this.isDown() || (l = Clock.ticks()) - this.lastPingTime > (long)this.network().getLocalDevice().getDeviceTimeout()) {
                Runnable runnable = new Runnable(){

                    public final void run() {
                        BBacnetDevice.this.readSystemStatus();
                        BBacnetDevice.this.updateStatus();
                        if (BBacnetDevice.this.isDown()) {
                            BBacnetDevice.this.checkAddress();
                        }
                    }
                };
                if (this.network().getWorker().hasWorkerPool()) {
                    this.network().postAsync(runnable);
                } else {
                    runnable.run();
                }
                this.lastPingTime = l;
            }
        } else {
            this.checkAddress();
        }
    }

    void readSystemStatus() {
        try {
            byte[] byArray = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().readProperty(this.getAddress(), this.getObjectId(), 112);
            if (byArray == null) {
                this.pingFail(lex.getText("BacnetDevice.ping.null"));
                return;
            }
            int n = AsnUtil.fromAsnEnumerated(byArray);
            if (n == 4) {
                this.pingFail(lex.getText("BacnetDevice.ping.nonOperational"));
            } else {
                this.pingOk();
            }
            if (!this.getEnumerationList().getDeviceStatusRange().isOrdinal(n)) {
                this.getEnumerationList().addNewDeviceStatus(n);
            }
            this.getConfig().getDeviceObject().set(BBacnetDeviceObject.systemStatus, (BValue)BDynamicEnum.make((int)n, (BEnumRange)this.getEnumerationList().getDeviceStatusRange()), BacnetConst.noWrite);
        }
        catch (TransactionException transactionException) {
            log.message("TransactionException pinging " + this + ": " + transactionException);
            this.pingFail(transactionException.toString());
        }
        catch (AsnException asnException) {
            log.warning("Unable to convert encoded System_Status!", (Throwable)((Object)asnException));
            this.pingFail(asnException.toString());
        }
        catch (BacnetException bacnetException) {
            log.warning("BacnetException pinging " + this + ": " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
            this.pingFail(bacnetException.toString());
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetDevice", 2);
        spyWriter.prop((Object)"rpmOk", this.rpmOk);
        spyWriter.prop((Object)"oldAddress", (Object)this.oldAddress);
        spyWriter.prop((Object)"isPolling", this.isPolling);
        spyWriter.prop((Object)"pollTimeouts", this.pollTimeouts);
        spyWriter.prop((Object)"maxAPDU", this.maxAPDU);
        spyWriter.prop((Object)"isAws", (Object)this.isAws);
        spyWriter.endProps();
    }

    public void doUpload(BUploadParameters bUploadParameters, Context context) throws Exception {
        BStatus bStatus = this.getStatus();
        if ((bStatus.getBits() & 3) != 0) {
            return;
        }
        this.doPing();
        if (!this.getStatus().isValid()) {
            return;
        }
        this.getDeviceObject().readProperty(BBacnetDeviceObject.protocolServicesSupported);
        this.getConfig().doUpload(bUploadParameters, context);
        this.rpmOk = this.isServiceSupported("readPropertyMultiple");
        this.maxAPDU = this.getDeviceObject().getMaxAPDULengthAccepted().getInt();
        boolean bl = this.isServiceSupported("subscribeCov");
        int n = this.getFlags((Slot)useCov);
        if (!bl) {
            this.setUseCov(false);
        }
        n = bl ? n & 0xFFFFFFFE : n | 1;
        this.setFlags((Slot)useCov, n);
        ((BBacnetScheduleDeviceExt)this.getSchedules()).setSupport(this.getProtocolRevision());
    }

    public void doDownload(BDownloadParameters bDownloadParameters, Context context) throws Exception {
        this.getConfig().doDownload(bDownloadParameters, context);
    }

    public boolean isPolling() {
        return this.isPolling;
    }

    public void setIsPolling(boolean bl) {
        this.isPolling = bl;
    }

    public void addPolledPoint(BBacnetProxyExt bBacnetProxyExt) {
        System.out.println("BBacnetDevice.addPolledPoint(Ljavax/baja/bacnet/point/BBacnetProxyExt;) is DEPRECATED!");
    }

    public void removePolledPoint(BBacnetProxyExt bBacnetProxyExt) {
        System.out.println("BBacnetDevice.removePolledPoint(Ljavax/baja/bacnet/point/BBacnetProxyExt;) is DEPRECATED!");
    }

    public void tuningChanged(BBacnetTuningPolicy bBacnetTuningPolicy, Context context) {
        BControlPoint[] bControlPointArray = this.getPoints().getPoints();
        int n = 0;
        while (n < bControlPointArray.length) {
            ((BBacnetProxyExt)bControlPointArray[n].getProxyExt()).tuningChanged(bBacnetTuningPolicy, context);
            ++n;
        }
    }

    public boolean poll(BBacnetProxyExt bBacnetProxyExt) {
        System.out.println("BBacnetDevice.poll(Ljavax/baja/bacnet/point/BBacnetProxyExt;) is DEPRECATED!");
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean poll(PollList var1_1) {
        block27: {
            if (!this.getEnabled() || this.getStatus().isDown()) {
                return true;
            }
            if (!this.rpmOk) {
                this.pollRP(var1_1);
                return true;
            }
            var2_2 = var1_1.getPollEntries();
            var3_3 = var2_2.length;
            if (var3_3 == 0) {
                return false;
            }
            var4_4 = new Array();
            var5_5 = 0;
            var6_6 = var2_2[var5_5++];
            var7_7 = new NReadAccessSpec(var6_6.getObjectId(), var6_6.getPropertyId(), var6_6.getPropertyArrayIndex());
            var8_8 = var6_6.getObjectId().hashCode();
            while (var5_5 < var3_3) {
                if ((var6_6 = var2_2[var5_5++]) == null) {
                    BBacnetDevice.log.trace("Building ReadAccessSpec: PLE is null in  slot " + (var5_5 - 1));
                    continue;
                }
                if (var8_8 == var6_6.getObjectId().hashCode()) {
                    var7_7.addPropertyReference(var6_6.getPropertyId(), var6_6.getPropertyArrayIndex());
                    continue;
                }
                var4_4.add((Object)var7_7);
                var7_7 = new NReadAccessSpec(var6_6.getObjectId(), var6_6.getPropertyId(), var6_6.getPropertyArrayIndex());
                var8_8 = var6_6.getObjectId().hashCode();
            }
            var4_4.add((Object)var7_7);
            var9_9 = null;
            try {
                var9_9 = this.client().readPropertyMultiple(this.getAddress(), var4_4);
            }
            catch (TransactionException var10_10) {
                this.ping();
                BBacnetDevice.log.message("TransactionException in poll() for " + this + ":pl=" + var1_1);
                if (++this.pollTimeouts <= this.getMaxPollTimeouts()) break block27;
                var11_16 = 0;
                ** while (var11_16 < var3_3)
            }
lbl-1000:
            // 1 sources

            {
                var6_6 = var2_2[var11_16];
                if (var6_6 != null) {
                    var6_6.getPollable().readFail(var10_10.toString());
                }
                ++var11_16;
                continue;
            }
        }
        return true;
        catch (ErrorException var10_11) {
            this.pollTimeouts = 0;
            var11_17 = 0;
            ** while (var11_17 < var3_3)
        }
lbl-1000:
        // 1 sources

        {
            var6_6 = var2_2[var11_17];
            if (var6_6 != null) {
                var12_19 = var6_6.getPollable();
                if (var12_19 instanceof BBacnetProxyExt) {
                    ((BBacnetProxyExt)var12_19).setLastReadError(var10_11.getErrorType());
                }
                BBacnetDevice.plog.error("Bacnet Error polling " + var1_1 + "; entry " + var6_6 + " in " + this.getName() + " {" + (Object)this.getObjectId() + "}: " + (Object)var10_11, (Throwable)var10_11);
                var6_6.getPollable().readFail(var10_11.toString());
            }
            ++var11_17;
            continue;
        }
lbl59:
        // 1 sources

        return true;
        catch (AbortException var10_12) {
            this.pollTimeouts = 0;
            if (var10_12.getAbortReason() == 4 || var10_12.getAbortReason() == 0) {
                return false;
            }
        }
        catch (RejectException var10_13) {
            this.pollTimeouts = 0;
            if (var10_13.getRejectReason() == 9) {
                this.rpmOk = false;
                BBacnetDevice.plog.message("REJECT:Unrecognized service - switch polling to ReadProperty");
                this.pollRP(var1_1);
                return true;
            }
            if (var10_13.getRejectReason() == 1) {
                this.maxAPDU -= 5;
                if (this.maxAPDU <= 50) {
                    this.rpmOk = false;
                }
                BBacnetDevice.plog.message("REJECT:Buffer overflow - decreasing max APDU size to " + this.maxAPDU);
                return false;
            }
        }
        catch (BacnetException var10_14) {
            this.pollTimeouts = 0;
            BBacnetDevice.plog.error("BacnetException polling " + var1_1 + " in " + this.getName() + " {" + (Object)this.getObjectId() + "}: " + (Object)var10_14, (Throwable)var10_14);
            return false;
        }
        if (var9_9 == null) {
            BBacnetDevice.plog.message("Poll resultList is empty!");
            return false;
        }
        this.pingOk();
        this.pollTimeouts = 0;
        var5_5 = 0;
        while (var9_9.hasNext() && var5_5 < var2_2.length) {
            var10_15 = (NReadPropertyResult)var9_9.next();
            if ((var6_6 = var2_2[var5_5++]) == null) {
                BBacnetDevice.log.trace("Iterating ReadAccessResults: PLE is null in  slot " + (var5_5 - 1));
                continue;
            }
            if (var6_6.getObjectId().hashCode() != var10_15.getObjectId().hashCode() || var6_6.getPropertyId() != var10_15.getPropertyId() || var6_6.getPropertyArrayIndex() != var10_15.getPropertyArrayIndex()) {
                BBacnetDevice.plog.message("Mismatch between PollListEntry and ReadPropertyResult:\n  ple=" + var6_6.debugString() + "\n  rpr=" + var10_15.debug());
                return false;
            }
            if (var10_15.isError()) {
                var11_18 = var6_6.getPollable();
                if (var11_18 instanceof BBacnetProxyExt) {
                    ((BBacnetProxyExt)var11_18).setLastReadError(var10_15.getPropertyAccessError());
                }
                var6_6.getPollable().readFail(NErrorType.toString(var10_15.getErrorClass(), var10_15.getErrorCode()));
                continue;
            }
            var6_6.getPollable().fromEncodedValue(var10_15.getPropertyValue(), null, var6_6);
        }
        return true;
    }

    private final void pollRP(PollList pollList) {
        PollListEntry[] pollListEntryArray = pollList.getPollEntries();
        int n = pollListEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            PollListEntry pollListEntry = pollListEntryArray[n2];
            if (pollListEntry == null) {
                log.trace("pollRP: PLE is null in  slot " + n2);
            } else {
                byte[] byArray = null;
                try {
                    byArray = this.client().readProperty(this.getAddress(), pollListEntry.getObjectId(), pollListEntry.getPropertyId(), pollListEntry.getPropertyArrayIndex());
                    this.pingOk();
                    pollListEntry.getPollable().fromEncodedValue(byArray, null, pollListEntry);
                }
                catch (TransactionException transactionException) {
                    pollListEntry.getPollable().readFail(transactionException.toString());
                    this.ping();
                    if (this.getStatus().isDown()) {
                        break;
                    }
                }
                catch (ErrorException errorException) {
                    BIBacnetPollable bIBacnetPollable = pollListEntry.getPollable();
                    if (bIBacnetPollable instanceof BBacnetProxyExt) {
                        ((BBacnetProxyExt)bIBacnetPollable).setLastReadError(errorException.getErrorType());
                    }
                    plog.error("Bacnet Error polling PollList " + pollList + " entry " + pollListEntry + " in " + this.getName() + " {" + (Object)((Object)this.getObjectId()) + "}: " + (Object)((Object)errorException), (Throwable)((Object)errorException));
                    pollListEntry.getPollable().readFail(errorException.toString());
                }
                catch (BacnetException bacnetException) {
                    plog.error("BacnetException polling PollList " + pollList + " entry " + pollListEntry + " in " + this.getName() + " {" + (Object)((Object)this.getObjectId()) + "}: " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
                    pollListEntry.getPollable().readFail(bacnetException.toString());
                }
            }
            ++n2;
        }
    }

    public int countPolledPoints() {
        System.out.println("BBacnetDevice.countPolledPoints()I is DEPRECATED!");
        return 0;
    }

    public boolean canAddCov() {
        boolean bl = false;
        if (this.getUseCov() && this.getCovSubscriptions() < this.getMaxCovSubscriptions()) {
            bl = true;
        }
        return bl;
    }

    public boolean subscribeCov(BBacnetProxyExt bBacnetProxyExt) {
        boolean bl = true;
        if (!this.canAddCov()) {
            bl = false;
        } else {
            int n = bBacnetProxyExt.getCovSubscriptionLifetime() * 60;
            if (n < 0 || n > 0 && n < 300) {
                n = 300;
            }
            try {
                this.client().subscribeCov(this.getAddress(), 1L, bBacnetProxyExt.getObjectId(), bBacnetProxyExt.useConfirmedCov(), n);
                this.pingOk();
            }
            catch (BacnetException bacnetException) {
                plog.error("BacnetException sending SubscribeCov for " + (Object)((Object)bBacnetProxyExt.getObjectId()) + " in " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
                bl = false;
            }
        }
        BBacnetPoll bBacnetPoll = (BBacnetPoll)this.network().getPollService(bBacnetProxyExt);
        if (bl) {
            bBacnetPoll.unsubscribe(bBacnetProxyExt);
            if (!bBacnetProxyExt.isCOV()) {
                this.setCovSubscriptions(this.getCovSubscriptions() + 1);
            }
        } else {
            if (!bBacnetProxyExt.isPolled()) {
                bBacnetPoll.subscribe(bBacnetProxyExt);
            }
            if (bBacnetProxyExt.isCOV()) {
                this.setCovSubscriptions(this.getCovSubscriptions() - 1);
            }
        }
        bBacnetProxyExt.setSubState(bl ? 2 : 4);
        return bl;
    }

    public void unsubscribeCov(BBacnetProxyExt bBacnetProxyExt) {
        BBacnetObjectIdentifier bBacnetObjectIdentifier = bBacnetProxyExt.getObjectId();
        try {
            this.client().unsubscribeCov(this.getAddress(), 1L, bBacnetObjectIdentifier);
            this.setCovSubscriptions(this.getCovSubscriptions() - 1);
        }
        catch (BacnetException bacnetException) {
            plog.error("BacnetException cancelling Cov subscription for " + (Object)((Object)bBacnetObjectIdentifier) + " in " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
        }
    }

    public final PropertyInfo getPropertyInfo(int n, int n2) {
        PropertyInfo propertyInfo = null;
        try {
            propertyInfo = this.getVendorPropertyInfo(n, n2);
        }
        catch (Exception exception) {}
        try {
            if (propertyInfo == null) {
                propertyInfo = ObjectTypeList.getInstance().getPropertyInfo(n, n2);
            }
        }
        catch (Exception exception) {}
        if (propertyInfo != null && propertyInfo.isAws() && !this.isAws()) {
            propertyInfo = null;
        }
        if (propertyInfo == null) {
            propertyInfo = new PropertyInfo(BBacnetPropertyIdentifier.tag(n2), n2, -6);
        }
        return propertyInfo;
    }

    public int[] getPossibleProperties(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return ObjectTypeList.getInstance().getPossibleProperties(bBacnetObjectIdentifier);
    }

    public int[] getRequiredProperties(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return ObjectTypeList.getInstance().getRequiredProperties(bBacnetObjectIdentifier);
    }

    protected PropertyInfo getVendorPropertyInfo(int n, int n2) {
        if (this.vendorObjectTypesList != null) {
            return this.vendorObjectTypesList.getPropertyInfo(n, n2);
        }
        return null;
    }

    private final ObjectTypeList getVendorObjectTypesList() {
        BOrd bOrd = BOrd.NULL;
        if (this.vendorObjectTypesList == null) {
            try {
                bOrd = (BOrd)this.get("vendorObjectTypesFile");
                if (bOrd != null && !bOrd.equals((Object)BOrd.NULL)) {
                    this.vendorObjectTypesList = ObjectTypeList.make(bOrd);
                }
            }
            catch (ClassCastException classCastException) {
                log.message("vendorObjectTypesFile must be a BOrd." + classCastException);
            }
            catch (Exception exception) {
                log.message("Unable to build vendor object types list from file:" + bOrd, (Throwable)exception);
            }
        }
        return this.vendorObjectTypesList;
    }

    public BEnumRange getEnumRange(int n, int n2) {
        PropertyInfo propertyInfo = this.getPropertyInfo(n, n2);
        if (propertyInfo.isEnum()) {
            if (propertyInfo.isExtensible()) {
                return this.getEnumerationList().getEnumRange(propertyInfo.getType());
            }
            BTypeSpec bTypeSpec = BTypeSpec.make((String)propertyInfo.getType());
            return ((BEnum)bTypeSpec.getInstance()).getRange();
        }
        return null;
    }

    public BObject lookupBacnetObject(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, String string) {
        if (!this.isRunning()) {
            this.loadSlots();
        }
        if (string == null || string.equals("point")) {
            return this.getPoints().lookupBacnetObject(bBacnetObjectIdentifier, n, n2, string);
        }
        if (string.equals("schedule")) {
            return ((BBacnetScheduleDeviceExt)this.getSchedules()).lookupBacnetObject(bBacnetObjectIdentifier, n, n2, string);
        }
        if (string.equals("history")) {
            return null;
        }
        if (string.equals("config")) {
            return this.getConfig().lookupBacnetObject(bBacnetObjectIdentifier, n, n2, string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doMacAddressFailed() {
        log.trace("Cannot resolve mac address for: " + this);
        Object object = this.TICKET_LOCK;
        synchronized (object) {
            this.staleTicket = null;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
            this.clearStaleFlag();
        }
        this.pingFail("Cannot resolve MAC address");
        this.updateStatus();
    }

    private final void clearStaleFlag() {
        BStatus bStatus = this.getStatus();
        this.setStatus(BStatus.make((int)(bStatus.getBits() & 0xFFFFFFEF), (BFacets)bStatus.getFacets()));
    }

    static /* synthetic */ String access$1() {
        return SKIP_UPLOAD;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.rpmOk = false;
        this.maxAPDU = 50;
        this.pollTimeouts = 0;
        this.vendorObjectTypesList = null;
        this.isAws = null;
        this.TICKET_LOCK = new Object();
        this.staleTicket = null;
        this.lastPingTime = 0L;
    }

    public BBacnetDevice() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$BBacnetDevice;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$BBacnetDevice = BBacnetDevice.class("[Ljavax.baja.bacnet.BBacnetDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"bacnet");
        log = Log.getLog((String)"bacnet.client");
        plog = Log.getLog((String)"bacnet.point");
    }
}

