/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.schedule;

import com.tridium.bacnet.ObjectTypeList;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.schedule.BBacnetChangeTypeParm;
import com.tridium.bacnet.schedule.BBacnetScheduleExport;
import com.tridium.ui.theme.Theme;
import javax.baja.bacnet.datatypes.BBacnetAny;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetTimeValue;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BChangeTypeDialog
extends BDialog {
    public static final Action typeChanged = BChangeTypeDialog.newAction((int)0, null);
    public static final Action oprChanged = BChangeTypeDialog.newAction((int)0, null);
    public static final Action superChanged = BChangeTypeDialog.newAction((int)0, null);
    public static final Action defaultChanged = BChangeTypeDialog.newAction((int)0, null);
    public static final Action weeklyChanged = BChangeTypeDialog.newAction((int)0, null);
    public static final Action exceptionChanged = BChangeTypeDialog.newAction((int)0, null);
    public static final Action buttonPressed = BChangeTypeDialog.newAction((int)4, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE;
    BBacnetChangeTypeParm wrkParam;
    BBacnetChangeTypeParm origParam;
    BAbstractSchedule sch;
    int asnType;
    BBacnetScheduleExport base;
    BButton applyButton;
    BButton cancelButton;
    BButton saveButton;
    int result;
    boolean hasWeekly;
    boolean hasException;
    private BListDropDown typeDrpDwn;
    private BWbFieldEditor oprEditor;
    private BWbFieldEditor defaultEditor;
    private BWbFieldEditor superEditor;
    private BWbFieldEditor weeklyEditor;
    private BWbFieldEditor exceptionEditor;
    private BLabel oprErr;
    private BLabel defErr;
    private BLabel ordErr;
    private BLabel wkSchErr;
    private BLabel exSchErr;
    static /* synthetic */ Class class$com$tridium$bacnet$ui$schedule$BChangeTypeDialog;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BIBacnetDataType;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetObjectPropertyReference;

    public void typeChanged() {
        this.invoke(typeChanged, null, null);
    }

    public void oprChanged() {
        this.invoke(oprChanged, null, null);
    }

    public void superChanged() {
        this.invoke(superChanged, null, null);
    }

    public void defaultChanged() {
        this.invoke(defaultChanged, null, null);
    }

    public void weeklyChanged() {
        this.invoke(weeklyChanged, null, null);
    }

    public void exceptionChanged() {
        this.invoke(exceptionChanged, null, null);
    }

    public void buttonPressed(BWidgetEvent bWidgetEvent) {
        this.invoke(buttonPressed, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetChangeTypeParm getScheduleExport() {
        this.wrkParam.setTypeChanged(this.wrkParam.getDataType().equals(this.origParam.getDataType()) ^ true);
        this.wrkParam.setSuperChanged(this.wrkParam.getSupervisorOrd().equals((Object)this.origParam.getSupervisorOrd()) ^ true);
        this.wrkParam.setOprChanged(this.wrkParam.getListOfObjectPropertyRefs().equivalent(this.origParam.getListOfObjectPropertyRefs()) ^ true);
        this.wrkParam.setSchedDefChanged(this.wrkParam.getScheduleDefault().equivalent(this.origParam.getScheduleDefault()) ^ true);
        if (this.wrkParam.getHasWeeklySchedule()) {
            this.wrkParam.setWeeklyChanged(this.equivalentSchedules(this.wrkParam.getWeeklySchedule(), this.origParam.getWeeklySchedule()) ^ true);
        }
        if (this.wrkParam.getHasExceptionSchedule()) {
            this.wrkParam.setExceptionChanged(this.equivalentSchedules(this.wrkParam.getExceptionSchedule(), this.origParam.getExceptionSchedule()) ^ true);
        }
        return this.wrkParam;
    }

    boolean equivalentSchedules(BComponent bComponent, BComponent bComponent2) {
        BIBacnetDataType[] bIBacnetDataTypeArray;
        Class clazz = class$javax$baja$bacnet$datatypes$BIBacnetDataType;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BIBacnetDataType = BChangeTypeDialog.class("[Ljavax.baja.bacnet.datatypes.BIBacnetDataType;", false);
        }
        BIBacnetDataType[] bIBacnetDataTypeArray2 = (BIBacnetDataType[])bComponent.getChildren(clazz);
        Class clazz2 = class$javax$baja$bacnet$datatypes$BIBacnetDataType;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$bacnet$datatypes$BIBacnetDataType = BChangeTypeDialog.class("[Ljavax.baja.bacnet.datatypes.BIBacnetDataType;", false);
        }
        if (bIBacnetDataTypeArray2.length != (bIBacnetDataTypeArray = (BIBacnetDataType[])bComponent2.getChildren(clazz2)).length) {
            return false;
        }
        int n = 0;
        while (n < bIBacnetDataTypeArray2.length) {
            if (!((BComplex)bIBacnetDataTypeArray2[n]).equivalent((Object)bIBacnetDataTypeArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void doButtonPressed(BWidgetEvent bWidgetEvent) {
        if (bWidgetEvent.getWidget().equals((Object)this.saveButton)) {
            this.saveSchedules();
            this.saveButton.setEnabled(false);
            return;
        }
        if (bWidgetEvent.getWidget().equals((Object)this.applyButton)) {
            this.result = 1;
        } else if (bWidgetEvent.getWidget().equals((Object)this.cancelButton)) {
            this.result = 2;
        }
        this.close();
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.result = 2;
        this.close();
    }

    public int getResult() {
        return this.result;
    }

    public void doTypeChanged() throws Exception {
        String string = (String)this.typeDrpDwn.getSelectedItem();
        this.wrkParam.setDataType(string);
        this.asnType = AsnUtil.getAsnType(string);
        this.verifyAll();
    }

    public void doOprChanged() throws Exception {
        this.oprEditor.saveValue();
        this.verifyOprCorrectType();
    }

    public void doSuperChanged() throws Exception {
        BOrd bOrd = (BOrd)this.superEditor.saveValue();
        this.wrkParam.setSupervisorOrd(bOrd);
        this.sch = (BAbstractSchedule)bOrd.resolve((BObject)this.base).get();
        this.verifySuperCorrectType();
    }

    public void doDefaultChanged() throws Exception {
        this.defaultEditor.saveValue();
        this.verifyDefaultCorrectType();
    }

    public void doWeeklyChanged() throws Exception {
        if (!this.hasWeekly) {
            return;
        }
        this.saveButton.setEnabled(true);
    }

    public void doExceptionChanged() throws Exception {
        if (!this.hasException) {
            return;
        }
        this.saveButton.setEnabled(true);
    }

    void saveSchedules() {
        if (this.hasWeekly) {
            try {
                this.weeklyEditor.saveValue();
            }
            catch (Exception exception) {}
            this.verifyWeeklyCorrectType();
        }
        if (this.hasException) {
            try {
                this.exceptionEditor.saveValue();
            }
            catch (Exception exception) {}
            this.verifyExceptionCorrectType();
        }
    }

    private final void verifyAll() {
        this.verifySuperCorrectType();
        this.verifyOprCorrectType();
        this.verifyDefaultCorrectType();
        this.verifyWeeklyCorrectType();
        this.verifyExceptionCorrectType();
    }

    private final void verifySuperCorrectType() {
        Type type = this.sch.getType();
        boolean bl = false;
        switch (this.asnType) {
            case 1: {
                if (!type.is(BBooleanSchedule.TYPE)) break;
                bl = true;
                break;
            }
            case 4: {
                if (!type.is(BNumericSchedule.TYPE)) break;
                bl = true;
                break;
            }
            case 2: 
            case 9: {
                if (!type.is(BEnumSchedule.TYPE)) break;
                bl = true;
                break;
            }
            case 7: {
                bl = true;
                break;
            }
        }
        this.ordErr.setVisible(bl ^ true);
    }

    private final void verifyOprCorrectType() {
        BBacnetListOf bBacnetListOf = (BBacnetListOf)this.oprEditor.getCurrentValue();
        boolean bl = true;
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetObjectPropertyReference;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetObjectPropertyReference = BChangeTypeDialog.class("[Ljavax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;", false);
        }
        BBacnetObjectPropertyReference[] bBacnetObjectPropertyReferenceArray = (BBacnetObjectPropertyReference[])bBacnetListOf.getChildren(clazz);
        int n = 0;
        while (n < bBacnetObjectPropertyReferenceArray.length) {
            PropertyInfo propertyInfo = ObjectTypeList.getInstance().getPropertyInfo(bBacnetObjectPropertyReferenceArray[n].getObjectId().getObjectType(), bBacnetObjectPropertyReferenceArray[n].getPropertyId());
            if (propertyInfo == null || !this.isValidType(propertyInfo.getAsnType())) {
                bl = false;
                break;
            }
            ++n;
        }
        this.oprErr.setVisible(bl ^ true);
    }

    private final void verifyDefaultCorrectType() {
        this.defErr.setVisible(this.isValidType(((BBacnetAny)this.defaultEditor.getCurrentValue()).getChoice()) ^ true);
    }

    private final boolean isValidType(int n) {
        boolean bl = false;
        if (n == this.asnType) {
            bl = true;
        }
        return bl;
    }

    private final void verifyWeeklyCorrectType() {
        if (!this.hasWeekly) {
            return;
        }
        this.wkSchErr.setVisible(this.isAllValid((BComponent)this.weeklyEditor.getCurrentValue()) ^ true);
    }

    private final void verifyExceptionCorrectType() {
        if (!this.hasException) {
            return;
        }
        this.exSchErr.setVisible(this.isAllValid((BComponent)this.exceptionEditor.getCurrentValue()) ^ true);
    }

    private final boolean isAllValid(BComponent bComponent) {
        if (bComponent instanceof BBacnetTimeValue) {
            return this.isValidType(((BBacnetTimeValue)bComponent).getValue().getChoice());
        }
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent2 = (BComponent)slotCursor.get();
            if (this.isAllValid(bComponent2)) continue;
            return false;
        }
        return true;
    }

    private final void loadTypesDD() {
        this.typeDrpDwn.getList().addItem((Object)AsnUtil.getAsnTypeName(4));
        this.typeDrpDwn.getList().addItem((Object)AsnUtil.getAsnTypeName(9));
        this.typeDrpDwn.getList().addItem((Object)AsnUtil.getAsnTypeName(1));
        this.typeDrpDwn.getList().addItem((Object)AsnUtil.getAsnTypeName(2));
        this.typeDrpDwn.getList().addItem((Object)AsnUtil.getAsnTypeName(7));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.result = 0;
    }

    public BChangeTypeDialog() {
        this.this();
    }

    public BChangeTypeDialog(BWidget bWidget, UiLexicon uiLexicon, BBacnetScheduleExport bBacnetScheduleExport, BBacnetChangeTypeParm bBacnetChangeTypeParm) {
        super(bWidget, uiLexicon.getText("changeType.title"), true);
        this.this();
        this.origParam = bBacnetChangeTypeParm;
        this.wrkParam = (BBacnetChangeTypeParm)bBacnetChangeTypeParm.newCopy(true);
        this.base = bBacnetScheduleExport;
        this.sch = bBacnetScheduleExport.getSupervisor();
        this.asnType = AsnUtil.getAsnType(bBacnetScheduleExport.getDataType());
        this.hasWeekly = bBacnetChangeTypeParm.getHasWeeklySchedule();
        this.hasException = bBacnetChangeTypeParm.getHasExceptionSchedule();
        this.typeDrpDwn = new BListDropDown();
        this.loadTypesDD();
        this.typeDrpDwn.setSelectedItem((Object)this.wrkParam.getDataType());
        this.linkTo((BComponent)this.typeDrpDwn, (Slot)BListDropDown.listActionPerformed, (Slot)typeChanged);
        this.defaultEditor = BWbFieldEditor.makeFor((BObject)this.wrkParam.getScheduleDefault());
        this.defaultEditor.loadValue((BObject)this.wrkParam.getScheduleDefault());
        this.linkTo((BComponent)this.defaultEditor, (Slot)BWbFieldEditor.setModified, (Slot)defaultChanged);
        this.superEditor = BWbFieldEditor.makeFor((BObject)BOrd.NULL);
        this.superEditor.loadValue((BObject)this.wrkParam.getSupervisorOrd());
        this.linkTo((BComponent)this.superEditor, (Slot)BWbFieldEditor.setModified, (Slot)superChanged);
        this.oprEditor = BWbFieldEditor.makeFor((BObject)this.wrkParam.getListOfObjectPropertyRefs());
        this.oprEditor.loadValue((BObject)this.wrkParam.getListOfObjectPropertyRefs());
        this.linkTo((BComponent)this.oprEditor, (Slot)BWbFieldEditor.setModified, (Slot)oprChanged);
        if (this.hasWeekly) {
            this.weeklyEditor = BWbFieldEditor.makeFor((BObject)this.wrkParam.getWeeklySchedule());
            this.weeklyEditor.loadValue((BObject)this.wrkParam.getWeeklySchedule());
            this.linkTo((BComponent)this.weeklyEditor, (Slot)BWbFieldEditor.setModified, (Slot)weeklyChanged);
        }
        if (this.hasException) {
            this.exceptionEditor = BWbFieldEditor.makeFor((BObject)this.wrkParam.getExceptionSchedule());
            this.exceptionEditor.loadValue((BObject)this.wrkParam.getExceptionSchedule());
            this.linkTo((BComponent)this.exceptionEditor, (Slot)BWbFieldEditor.setModified, (Slot)exceptionChanged);
        }
        BBrush bBrush = BBrush.makeSolid((BColor)BColor.red);
        this.oprErr = new BLabel(uiLexicon.getText("changeType.objectPropertReferenceErr"));
        this.oprErr.setForeground(bBrush);
        this.defErr = new BLabel(uiLexicon.getText("changeType.scheduleDefaultErr"));
        this.defErr.setForeground(bBrush);
        this.ordErr = new BLabel(uiLexicon.getText("changeType.supervisorOrdErr"));
        this.ordErr.setForeground(bBrush);
        if (this.hasWeekly) {
            this.wkSchErr = new BLabel(uiLexicon.getText("changeType.scheduleErr"));
            this.wkSchErr.setForeground(bBrush);
        }
        if (this.hasException) {
            this.exSchErr = new BLabel(uiLexicon.getText("changeType.scheduleErr"));
            this.exSchErr.setForeground(bBrush);
        }
        this.applyButton = new BButton(uiLexicon.getText("changeType.button.apply"));
        this.linkTo((BComponent)this.applyButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.cancelButton = new BButton(uiLexicon.getText("changeType.button.cancel"));
        this.linkTo((BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.saveButton = new BButton(uiLexicon.getText("changeType.button.save"));
        this.linkTo((BComponent)this.saveButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.saveButton.setEnabled(false);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add(null, (BValue)new BLabel(uiLexicon.getText("changeType.type")));
        bGridPane.add(null, (BValue)this.typeDrpDwn);
        bGridPane.add(null, (BValue)new BLabel(uiLexicon.getText("changeType.scheduleDefault")));
        bGridPane.add(null, (BValue)this.defaultEditor);
        bGridPane.add(null, (BValue)new BLabel());
        bGridPane.add(null, (BValue)this.defErr);
        bGridPane.add(null, (BValue)new BLabel(uiLexicon.getText("changeType.supervisorOrd")));
        bGridPane.add(null, (BValue)this.superEditor);
        bGridPane.add(null, (BValue)new BLabel());
        bGridPane.add(null, (BValue)this.ordErr);
        bGridPane.add(null, (BValue)new BLabel(uiLexicon.getText("changeType.objPropRef")));
        bGridPane.add(null, (BValue)this.oprEditor);
        bGridPane.add(null, (BValue)new BLabel());
        bGridPane.add(null, (BValue)this.oprErr);
        if (this.hasWeekly) {
            bGridPane.add(null, (BValue)new BLabel(uiLexicon.getText("changeType.weeklySchedule")));
            bGridPane.add(null, (BValue)this.weeklyEditor);
            bGridPane.add(null, (BValue)new BLabel());
            bGridPane.add(null, (BValue)this.wkSchErr);
        }
        if (this.hasException) {
            bGridPane.add(null, (BValue)new BLabel(uiLexicon.getText("changeType.exceptionSchedule")));
            bGridPane.add(null, (BValue)this.exceptionEditor);
            bGridPane.add(null, (BValue)new BLabel());
            bGridPane.add(null, (BValue)this.exSchErr);
        }
        BFlowPane bFlowPane = new BFlowPane();
        bFlowPane.setAlign(BHalign.center);
        bFlowPane.add("applyButton", (BValue)this.applyButton);
        bFlowPane.add("cancelButton", (BValue)this.cancelButton);
        bFlowPane.add("saveButton", (BValue)this.saveButton);
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bGridPane, 10.0, 10.0, 10.0, 10.0));
        bScrollPane.setViewportBackground(Theme.widget().getControlBackground());
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)bScrollPane));
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bFlowPane));
        this.setContent((BWidget)bEdgePane);
        this.setBoundsCenteredOnOwner();
        this.verifyAll();
    }

    static {
        Class clazz = class$com$tridium$bacnet$ui$schedule$BChangeTypeDialog;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$ui$schedule$BChangeTypeDialog = BChangeTypeDialog.class("[Lcom.tridium.bacnet.ui.schedule.BChangeTypeDialog;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

