/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.point;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BBacnetDiscoverPointsJob;
import com.tridium.bacnet.job.BDiscoveryPoint;
import com.tridium.bacnet.ui.point.BacnetPointController;
import com.tridium.bacnet.ui.point.PointLearn;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.point.BBacnetBooleanProxyExt;
import javax.baja.bacnet.point.BBacnetEnumProxyExt;
import javax.baja.bacnet.point.BBacnetNumericProxyExt;
import javax.baja.bacnet.point.BBacnetPointDeviceExt;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.point.BBacnetStringProxyExt;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.util.UiLexicon;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.FolderState;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetPointManager
extends BPointManager
implements BacnetConst {
    public static final Type TYPE;
    static final UiLexicon lexicon;
    static BImage bacnetObjectIcon;
    static BImage numericIcon;
    static BImage booleanIcon;
    static BImage enumIcon;
    static BImage stringIcon;
    static BImage logIcon;
    static BImage scheduleIcon;
    static BImage calendarIcon;
    static Lexicon driverLex;
    static String lexOut;
    MgrColumn colPath;
    MgrColumn colName;
    MgrColumn colType;
    MgrColumn colValue;
    MgrColumn colOid;
    MgrColumn colProperty;
    MgrColumn colIndex;
    MgrColumn colTuning;
    MgrColumn colAsnType;
    MgrColumn colReadStatus;
    MgrColumn colWriteStatus;
    MgrColumn colDeviceFacets;
    MgrColumn colFacets;
    MgrColumn colConversion;
    MgrColumn colEnabled;
    MgrColumn colReadValue;
    MgrColumn colWriteValue;
    MgrColumn colFaultCause;
    MgrColumn[] cols;
    private BBacnetPointDeviceExt deviceExt;
    static /* synthetic */ Class class$com$tridium$bacnet$ui$point$BBacnetPointManager;
    static /* synthetic */ Class class$com$tridium$bacnet$job$BDiscoveryPoint;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrController makeController() {
        return new BacnetPointController(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    public void doLoadValue(BObject bObject, Context context) {
        try {
            this.deviceExt = (BBacnetPointDeviceExt)((BIPointFolder)bObject).getDeviceExt();
            super.doLoadValue(bObject, context);
        }
        catch (Exception exception) {
            ((BacnetPointController)this.getController()).disableAll();
        }
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        super.handleComponentEvent(bComponentEvent);
        BJob bJob = this.getLearn().getJob();
        if (bComponentEvent.getId() == 1 && bJob != null && bJob instanceof BBacnetDiscoverPointsJob && bComponentEvent.getSourceComponent() == bJob) {
            try {
                MgrLearn mgrLearn = this.getLearn();
                Class clazz = class$com$tridium$bacnet$job$BDiscoveryPoint;
                if (clazz == null) {
                    clazz = class$com$tridium$bacnet$job$BDiscoveryPoint = BBacnetPointManager.class("[Lcom.tridium.bacnet.job.BDiscoveryPoint;", false);
                }
                mgrLearn.updateRoots(bJob.getChildren(clazz));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public BBacnetPointDeviceExt getDeviceExt() {
        if (this.deviceExt == null) {
            this.deviceExt = (BBacnetPointDeviceExt)((BIPointFolder)this.getCurrentValue()).getDeviceExt();
        }
        return this.deviceExt;
    }

    public BBacnetDevice getDevice() {
        return (BBacnetDevice)this.getDeviceExt().getDevice();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.colPath = new MgrColumn.Path(2);
        this.colName = new MgrColumn.Name();
        this.colType = new MgrColumn.Type(3);
        this.colValue = new MgrColumn.ToString(lexOut, 0);
        this.colOid = new MgrColumn.PropPath(lexicon.getText("learn.objectId"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.objectId}, 1);
        this.colProperty = new MgrColumn.PropPath(lexicon.getText("pointManager.property"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.propertyId}, 1);
        this.colIndex = new MgrColumn.PropPath(lexicon.getText("pointManager.index"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.propertyArrayIndex}, 1);
        this.colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 3);
        this.colAsnType = new MgrColumn.PropPath(lexicon.getText("pointManager.dataType"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.dataType}, 7);
        this.colReadStatus = new MgrColumn.PropPath(lexicon.getText("pointManager.read"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.readStatus}, 5);
        this.colWriteStatus = new MgrColumn.PropPath(lexicon.getText("pointManager.write"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.writeStatus}, 5);
        this.colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.deviceFacets}, 7);
        this.colFacets = new MgrColumn.Prop(BControlPoint.facets, 3);
        this.colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.conversion}, 3);
        this.colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, 3);
        this.colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
        this.colWriteValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
        this.colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
        this.cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colValue, this.colEnabled, this.colOid, this.colProperty, this.colIndex, this.colTuning, this.colAsnType, this.colReadStatus, this.colWriteStatus, this.colDeviceFacets, this.colFacets, this.colConversion, this.colReadValue, this.colWriteValue, this.colFaultCause};
    }

    public BBacnetPointManager() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$ui$point$BBacnetPointManager;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$ui$point$BBacnetPointManager = BBacnetPointManager.class("[Lcom.tridium.bacnet.ui.point.BBacnetPointManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$bacnet$ui$point$BBacnetPointManager;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$bacnet$ui$point$BBacnetPointManager = BBacnetPointManager.class("[Lcom.tridium.bacnet.ui.point.BBacnetPointManager;", false);
        }
        lexicon = new UiLexicon(clazz2);
        bacnetObjectIcon = BImage.make((String)"module://bacnet/com/tridium/bacnet/ui/icons/bacObject.png");
        numericIcon = BImage.make((String)"module://icons/x16/control/numericPoint.png");
        booleanIcon = BImage.make((String)"module://icons/x16/control/booleanPoint.png");
        enumIcon = BImage.make((String)"module://icons/x16/control/enumPoint.png");
        stringIcon = BImage.make((String)"module://icons/x16/control/stringPoint.png");
        logIcon = BImage.make((String)"module://icons/x16/history.png");
        scheduleIcon = BImage.make((String)"module://icons/x16/schedule.png");
        calendarIcon = BImage.make((String)"module://icons/x16/calendar.png");
        driverLex = Lexicon.make((String)"driver");
        lexOut = driverLex.getText("out");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends PointModel {
        protected MgrColumn[] makeColumns() {
            return BBacnetPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo mgrTypeInfo) throws Exception {
            BControlPoint bControlPoint = (BControlPoint)mgrTypeInfo.newInstance();
            Object object = new BNullProxyExt();
            if (bControlPoint instanceof BBooleanPoint) {
                object = new BBacnetBooleanProxyExt();
            } else if (bControlPoint instanceof BNumericPoint) {
                object = new BBacnetNumericProxyExt();
            } else if (bControlPoint instanceof BEnumPoint) {
                object = new BBacnetEnumProxyExt();
            } else if (bControlPoint instanceof BStringPoint) {
                object = new BBacnetStringProxyExt();
            }
            if (object instanceof BProxyExt) {
                BFacets bFacets = (BFacets)bControlPoint.getFacets().newCopy();
                ((BProxyExt)object).setDeviceFacets(bFacets);
            }
            bControlPoint.setProxyExt((BAbstractProxyExt)object);
            return bControlPoint;
        }

        Model(BBacnetPointManager bBacnetPointManager2) {
            super((BPointManager)bBacnetPointManager2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Learn
    extends PointLearn {
        public BImage getIcon(Object object) {
            BDiscoveryPoint bDiscoveryPoint = this.lr(object);
            try {
                int n = bDiscoveryPoint.getPropertyId();
                int n2 = -1;
                PropertyInfo propertyInfo = BBacnetPointManager.this.getDevice().getPropertyInfo(bDiscoveryPoint.getObjectId().getObjectType(), n);
                n2 = propertyInfo != null ? propertyInfo.getAsnType() : AsnUtil.getAsnType(bDiscoveryPoint.getValue().getType());
                switch (n2) {
                    case 0: {
                        return stringIcon;
                    }
                    case 1: {
                        return booleanIcon;
                    }
                    case 2: 
                    case 3: {
                        return enumIcon;
                    }
                    case 4: 
                    case 5: {
                        return numericIcon;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return stringIcon;
                    }
                    case 9: {
                        if (propertyInfo != null && propertyInfo.getType().equals("bacnet:BacnetBinaryPv")) {
                            return booleanIcon;
                        }
                        return enumIcon;
                    }
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 10: 
                    case 11: 
                    case 12: {
                        return stringIcon;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Error getting icon for discovery point:" + (Object)((Object)bDiscoveryPoint));
            }
            return bacnetObjectIcon;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
            BWbShell bWbShell = this.getManager().getWbShell();
            bWbShell.enterBusy();
            try {
                BDiscoveryPoint bDiscoveryPoint = this.lr(object);
                BControlPoint bControlPoint = (BControlPoint)mgrEditRow.getTarget();
                int n = bDiscoveryPoint.getPropertyId();
                PropertyInfo propertyInfo = BBacnetPointManager.this.getDevice().getPropertyInfo(bDiscoveryPoint.getObjectId().getObjectType(), n);
                String string = bDiscoveryPoint.getObjectName();
                if (string == null || string.length() == 0) {
                    string = bDiscoveryPoint.getObjectId().toString();
                }
                if (bDiscoveryPoint.getPropertyId() != 85) {
                    string = string + '-' + bDiscoveryPoint.getPropertyIdentifier();
                }
                if (bDiscoveryPoint.getIndex().length() > 0) {
                    string = string + '_' + bDiscoveryPoint.getIndex();
                }
                string = SlotPath.escape((String)TextUtil.replace((String)string, (String)"/", (String)"."));
                mgrEditRow.setDefaultName(string);
                mgrEditRow.setCell(BBacnetPointManager.this.colOid, (BValue)bDiscoveryPoint.getObjectId());
                mgrEditRow.setCell(BBacnetPointManager.this.colProperty, (BValue)BDynamicEnum.make((int)n, (BEnumRange)BEnumRange.make((Type)BBacnetPropertyIdentifier.TYPE)));
                if (bDiscoveryPoint.getIndex().length() > 0) {
                    mgrEditRow.setCell(BBacnetPointManager.this.colIndex, (BValue)BInteger.make((String)bDiscoveryPoint.getIndex()));
                }
                if (propertyInfo != null) {
                    mgrEditRow.setCell(BBacnetPointManager.this.colAsnType, (BValue)BString.make((String)propertyInfo.getDataType()));
                }
                String string2 = "readonly";
                if (bControlPoint.isWritablePoint()) {
                    string2 = "writable";
                }
                mgrEditRow.setCell(BBacnetPointManager.this.colWriteStatus, (BValue)BString.make((String)string2));
                mgrEditRow.setCell(BBacnetPointManager.this.colReadStatus, (BValue)BString.make((String)"unsubscribed"));
                boolean bl = false;
                if (bControlPoint.isWritablePoint()) {
                    int n2 = bDiscoveryPoint.getObjectId().getObjectType();
                    if (n2 == 1 || n2 == 4 || n2 == 14) {
                        bl = true;
                    }
                    if (n2 == 2 || n2 == 5 || n2 == 19) {
                        bl = this.getDiscoveryJob().checkForPriorityArray(bDiscoveryPoint.getObjectId()).getBoolean();
                    }
                    if (bl) {
                        mgrEditRow.setCell(BBacnetPointManager.this.colEnabled, (BValue)BBoolean.make((boolean)false));
                    }
                }
                BFacets bFacets = bControlPoint.getFacets();
                BFacets bFacets2 = bDiscoveryPoint.getFacets();
                if (bFacets2 == null || bFacets2.isNull()) {
                    bFacets2 = this.getDiscoveryJob().discoverFacets(bDiscoveryPoint.getObjectId());
                }
                if (propertyInfo != null) {
                    if (propertyInfo.isEnum()) {
                        BEnum bEnum = (BEnum)BTypeSpec.make((String)propertyInfo.getType()).getInstance();
                        BEnumRange bEnumRange = bEnum.getRange();
                        if (propertyInfo.isExtensible()) {
                            bEnumRange = BBacnetPointManager.this.getDevice().getEnumerationList().getEnumRange(propertyInfo.getType());
                        }
                        bFacets2 = BFacets.make((BFacets)bFacets2, (String)"range", (BIDataValue)bEnumRange);
                    }
                    if (propertyInfo.getFacetControl().equals("all")) {
                        bFacets = bFacets2;
                    } else if (propertyInfo.getFacetControl().equals("units")) {
                        bFacets = BFacets.make((String)"units", (BIDataValue)((BUnit)bFacets2.getFacet("units")));
                    } else if (!propertyInfo.getFacetControl().equals("no") && bFacets2 != null && !bFacets2.isNull()) {
                        bFacets = bFacets2;
                    }
                }
                mgrEditRow.setCell(BBacnetPointManager.this.colDeviceFacets, (BValue)bFacets);
                bFacets = BFacets.makeRemove((BFacets)bFacets, (String)"priPV");
                mgrEditRow.setCell(BBacnetPointManager.this.colFacets, (BValue)bFacets);
            }
            catch (Throwable throwable) {
                Object var5_17 = null;
                bWbShell.exitBusy();
                throw throwable;
            }
            {
                Object var5_18 = null;
            }
            bWbShell.exitBusy();
        }

        Learn(BBacnetPointManager bBacnetPointManager2) {
            super(bBacnetPointManager2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class State
    extends FolderState {
        Object[] lastLearn;
        BJob lrnJob;
        BOrd myLastSaveOrd;

        public void restore(BAbstractManager bAbstractManager) {
            try {
                this.restoreForType(bAbstractManager);
                BOrd bOrd = bAbstractManager.getWbShell().getActiveOrd();
                if (this.myLastSaveOrd == null) {
                    return;
                }
                BIPointFolder bIPointFolder = (BIPointFolder)this.myLastSaveOrd.get((BObject)BBacnetNetwork.bacnet());
                BIPointFolder bIPointFolder2 = (BIPointFolder)bOrd.get((BObject)BBacnetNetwork.bacnet());
                if (bIPointFolder.getDeviceExt().equals((Object)bIPointFolder2.getDeviceExt())) {
                    this.restoreForOrd(bAbstractManager);
                }
            }
            catch (UnresolvedException unresolvedException) {}
        }

        public void save(BAbstractManager bAbstractManager) {
            this.myLastSaveOrd = bAbstractManager.getWbShell().getActiveOrd();
            this.saveForType(bAbstractManager);
            this.saveForOrd(bAbstractManager);
        }

        protected void saveForOrd(BAbstractManager bAbstractManager) {
            super.saveForOrd(bAbstractManager);
            BBacnetPointManager bBacnetPointManager = (BBacnetPointManager)bAbstractManager;
            Learn learn = (Learn)bBacnetPointManager.getLearn();
            this.lastLearn = learn.lastLearn;
            this.lrnJob = learn.getJob();
        }

        protected void restoreForOrd(BAbstractManager bAbstractManager) {
            super.restoreForOrd(bAbstractManager);
            BBacnetPointManager bBacnetPointManager = (BBacnetPointManager)bAbstractManager;
            Learn learn = (Learn)bBacnetPointManager.getLearn();
            if (this.lastLearn != null) {
                learn.updateRoots(this.lastLearn);
            }
            if (this.lrnJob != null) {
                learn.setJob(this.lrnJob);
            }
        }

        State() {
        }
    }
}

