/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.device;

import com.tridium.bacnet.ui.device.BBacnetDeviceManager;
import com.tridium.bacnet.ui.fe.BBacnetObjectIdentifierFE;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.config.BBacnetConfigDeviceExt;
import javax.baja.bacnet.config.BBacnetDeviceObject;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BacnetDeviceModel
extends DeviceModel {
    static Lexicon lexicon;
    protected MgrColumn colName;
    protected MgrColumn colChgIdName;
    protected MgrColumn colType;
    protected MgrColumn colDeviceExts;
    public MgrColumn colOid;
    protected MgrColumn colStatus;
    public MgrColumn colNetNum;
    public MgrColumn colMacAddr;
    protected MgrColumn colMaxApdu;
    protected MgrColumn colSegment;
    protected MgrColumn colVName;
    protected MgrColumn colMName;
    protected MgrColumn colFwRev;
    protected MgrColumn colAppSwVer;
    protected MgrColumn colCharSet;
    protected MgrColumn colEnabled;
    protected MgrColumn colHealth;
    public MgrColumn colUseCov;
    protected MgrColumn colMaxCovSub;
    protected MgrColumn colCovSub;
    protected MgrColumn colPollFreq;
    protected MgrColumn[] cols;
    protected MgrColumn[] changeIdCols;
    static /* synthetic */ Class class$com$tridium$bacnet$ui$device$BacnetDeviceModel;

    public BBacnetDeviceManager getBacnetDeviceManager() {
        return (BBacnetDeviceManager)this.getManager();
    }

    public MgrTypeInfo[] getNewTypes() {
        return this.getBacnetDeviceManager().toTypes();
    }

    protected MgrColumn[] makeColumns() {
        return this.cols;
    }

    public MgrColumn[] getChangeIdColumns() {
        return this.changeIdCols;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.colName = new MgrColumn.Name();
        this.colChgIdName = new MgrColumn.Name(5);
        this.colType = new MgrColumn.Type(3);
        this.colDeviceExts = new DeviceExtsColumn((BDevice)new BBacnetDevice());
        this.colOid = new DevId(lexicon.getText("deviceManager.deviceId"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.objectId}, 1);
        this.colStatus = new MgrColumn.Prop(BDevice.status);
        this.colNetNum = new MgrColumn.PropPath(lexicon.getText("deviceManager.network"), new Property[]{BBacnetDevice.address, BBacnetAddress.networkNumber}, 1);
        this.colMacAddr = new MacAddr();
        this.colMaxApdu = new MgrColumn.PropPath(lexicon.getText("deviceManager.maxApdu"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.maxAPDULengthAccepted}, 2);
        this.colSegment = new MgrColumn.PropPath(lexicon.getText("deviceManager.segmentation"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.segmentationSupported}, 2);
        this.colVName = new MgrColumn.PropPath(lexicon.getText("deviceManager.vendorName"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.vendorName}, 4);
        this.colMName = new MgrColumn.PropPath(lexicon.getText("deviceManager.modelName"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.modelName}, 4);
        this.colFwRev = new MgrColumn.PropPath(lexicon.getText("deviceManager.fwRev"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.firmwareRevision}, 4);
        this.colAppSwVer = new MgrColumn.PropPath(lexicon.getText("deviceManager.appSwVer"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.applicationSoftwareVersion}, 4);
        this.colCharSet = new MgrColumn.Prop(lexicon.getText("deviceManager.charSet"), BBacnetDevice.characterSet, 2);
        this.colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
        this.colHealth = new MgrColumn.Prop(BDevice.health, 2);
        this.colUseCov = new MgrColumn.Prop(BBacnetDevice.useCov, 3);
        this.colMaxCovSub = new MgrColumn.Prop(BBacnetDevice.maxCovSubscriptions, 3);
        this.colCovSub = new MgrColumn.Prop(BBacnetDevice.covSubscriptions, 2);
        this.colPollFreq = new MgrColumn.Prop(BBacnetDevice.pollFrequency, 3);
        this.cols = new MgrColumn[]{this.colName, this.colType, this.colDeviceExts, this.colOid, this.colStatus, this.colNetNum, this.colMacAddr, this.colMaxApdu, this.colSegment, this.colVName, this.colMName, this.colFwRev, this.colAppSwVer, this.colCharSet, this.colHealth, this.colEnabled, this.colUseCov, this.colMaxCovSub, this.colCovSub};
        this.changeIdCols = new MgrColumn[]{this.colChgIdName, this.colType, this.colOid};
    }

    public BacnetDeviceModel(BBacnetDeviceManager bBacnetDeviceManager) {
        super((BDeviceManager)bBacnetDeviceManager);
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$ui$device$BacnetDeviceModel;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$ui$device$BacnetDeviceModel = BacnetDeviceModel.class("[Lcom.tridium.bacnet.ui.device.BacnetDeviceModel;", false);
        }
        lexicon = new UiLexicon(clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class DevId
    extends MgrColumn.PropPath {
        Property[] props;
        BEnumRange DEV_RANGE;

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            BValue bValue = mgrEditRowArray[0].getCell(n);
            int n2 = 1;
            while (n2 < mgrEditRowArray.length) {
                if (mgrEditRowArray[n2].getCell(n).getClass() != bValue.getClass()) {
                    return null;
                }
                ++n2;
            }
            BFacets bFacets = mgrEditRowArray.length == 1 && this.props.length == 1 ? mgrEditRowArray[0].getTarget().getSlotFacets((Slot)this.props[0]) : this.props[this.props.length - 1].getFacets();
            bFacets = BFacets.make((BFacets)bFacets, (String)"range", (BIDataValue)this.DEV_RANGE);
            Context context = mgrEditRowArray[0].getManager().getCurrentContext();
            if (!bFacets.isNull()) {
                context = new BasicContext(context, bFacets);
            }
            BBacnetObjectIdentifierFE bBacnetObjectIdentifierFE = new BBacnetObjectIdentifierFE();
            if (bWbEditor != null && bWbEditor.getClass() == ((Object)((Object)bBacnetObjectIdentifierFE)).getClass()) {
                bBacnetObjectIdentifierFE = (BWbFieldEditor)bWbEditor;
            }
            bBacnetObjectIdentifierFE.loadValue((BObject)bValue, context);
            return bBacnetObjectIdentifierFE;
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            BBacnetObjectIdentifier bBacnetObjectIdentifier = (BBacnetObjectIdentifier)bWbFieldEditor.saveValue();
            int n2 = bBacnetObjectIdentifier.getInstanceNumber();
            int n3 = 0;
            while (n3 < mgrEditRowArray.length) {
                mgrEditRowArray[n3].setCell(n, (BValue)BBacnetObjectIdentifier.make(bBacnetObjectIdentifier.getObjectType(), n2 + n3));
                ++n3;
            }
        }

        private final /* synthetic */ void this() {
            this.DEV_RANGE = BEnumRange.make((int[])new int[]{8}, (String[])new String[]{BBacnetObjectType.device.getTag()});
        }

        public DevId(String string, Property[] propertyArray, int n) {
            super(string, propertyArray, n);
            this.this();
            this.props = propertyArray;
        }
    }

    static class MacAddr
    extends MgrColumn {
        public Object get(Object object) {
            BBacnetDevice bBacnetDevice = (BBacnetDevice)object;
            return BBacnetAddress.bytesToString(bBacnetDevice.getAddress().getAddressType(), bBacnetDevice.getAddress().getMacAddress().getBytes());
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BBacnetDevice bBacnetDevice = (BBacnetDevice)mgrEditRow.getTarget();
            BBacnetAddress bBacnetAddress = bBacnetDevice.getAddress();
            return BString.make((String)BBacnetAddress.bytesToString(bBacnetAddress.getAddressType(), bBacnetAddress.getMacAddress().getBytes()));
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            int n = ((BInteger)mgrEditRow.getCell(((BBacnetDeviceManager)mgrEditRow.getManager()).bacModel().colNetNum)).getInt();
            BBacnetDevice bBacnetDevice = (BBacnetDevice)mgrEditRow.getTarget();
            BBacnetAddress bBacnetAddress = (BBacnetAddress)bBacnetDevice.getAddress().newCopy();
            bBacnetAddress.setNetworkNumber(n);
            String string = ((BString)bValue).getString();
            int n2 = string.indexOf(".");
            if (n2 > 0) {
                bBacnetAddress.setAddressType(2);
            } else {
                n2 = string.indexOf(":");
                if (n2 > 0) {
                    bBacnetAddress.setAddressType(1);
                } else if (!string.equals("null") && string.length() <= 4) {
                    bBacnetAddress.setAddressType(3);
                }
            }
            bBacnetAddress.setMac(BBacnetAddress.stringToBytes(bBacnetAddress.getAddressType(), 5, string), null);
            bBacnetDevice.set(BBacnetDevice.address, (BValue)bBacnetAddress, context);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            BString bString = (BString)mgrEditRowArray[0].getCell(n);
            BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bString, null);
            if (bWbEditor != null && bWbEditor.getClass() == bWbFieldEditor.getClass()) {
                bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            }
            bWbFieldEditor.loadValue((BObject)bString, null);
            return bWbFieldEditor;
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            BString bString = (BString)bWbEditor.saveValue();
            int n2 = 0;
            while (n2 < mgrEditRowArray.length) {
                mgrEditRowArray[n2].setCell(n, (BValue)bString);
                ++n2;
            }
        }

        public MacAddr() {
            super(lexicon.getText("deviceManager.mac"), 1);
        }
    }
}

