/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.device;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.job.BBacnetDiscoverDevicesJob;
import com.tridium.bacnet.job.BChangeDeviceIdJob;
import com.tridium.bacnet.job.BDiscoveryDevice;
import com.tridium.bacnet.job.BTimeSynchJob;
import com.tridium.bacnet.job.BWhoHasJob;
import com.tridium.bacnet.services.unconfirmed.IHaveRequest;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.link.ethernet.BBacnetEthernetLinkLayer;
import com.tridium.bacnet.stack.link.ip.BBacnetIpLinkLayer;
import com.tridium.bacnet.stack.link.mstp.BBacnetMstpLinkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.ui.device.BBacnetDeviceManager;
import com.tridium.bacnet.ui.device.BBacnetLearnTable;
import java.text.MessageFormat;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BacnetDeviceLearn
extends MgrLearn
implements AsnConst {
    static BImage bacnetDeviceIcon = BImage.make((String)"module://icons/x16/device.png");
    static Lexicon lex;
    static String lexName;
    static String lexDeviceId;
    static String lexNet;
    static String lexAddr;
    static String lexVendorName;
    static String lexModelName;
    static String lexMaxApdu;
    static String lexSeg;
    static String lexVendorId;
    static String lexSize;
    static String lexCset;
    static String lexUnknown;
    static String lexFwRev;
    static String lexAppSwVer;
    static String lexDup;
    BDiscoveryDevice[] lastLearn;
    BBacnetDeviceManager mgr;
    protected boolean jobComplete;
    MgrColumn dcolName;
    MgrColumn dcolObjectId;
    MgrColumn dcolNetwork;
    MgrColumn dcolAddr;
    MgrColumn dcolVendorName;
    MgrColumn dcolModelName;
    MgrColumn dcolMaxApdu;
    MgrColumn dcolSeg;
    MgrColumn dcolVendorId;
    MgrColumn dcolSize;
    MgrColumn dcolCharset;
    MgrColumn dcolFwRev;
    MgrColumn dcolAppSwVer;
    MgrColumn dcolDup;
    MgrColumn[] dcols;
    static /* synthetic */ Class class$com$tridium$bacnet$ui$device$BacnetDeviceLearn;
    static /* synthetic */ Class class$com$tridium$bacnet$job$BDiscoveryDevice;
    static /* synthetic */ Class class$javax$baja$sys$BString;

    protected final BWidget makeJobBar() {
        return null;
    }

    protected BDiscoveryDevice disc(Object object) {
        return (BDiscoveryDevice)((Object)object);
    }

    protected MgrColumn[] makeColumns() {
        return this.dcols;
    }

    public boolean isMatchable(Object object, BComponent bComponent) {
        return true;
    }

    public boolean isExisting(Object object, BComponent bComponent) {
        if (!bComponent.getType().is(BBacnetDevice.TYPE)) {
            return false;
        }
        return ((BBacnetDevice)bComponent).getObjectId().equals((Object)this.disc(object).getObjectId());
    }

    public BImage getIcon(Object object) {
        return bacnetDeviceIcon;
    }

    public MgrTypeInfo[] toTypes(Object object) {
        return this.mgr.toTypes();
    }

    public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
        BDiscoveryDevice bDiscoveryDevice = this.disc(object);
        BBacnetAddress bBacnetAddress = bDiscoveryDevice.getAddress();
        mgrEditRow.setDefaultName(SlotPath.escape((String)bDiscoveryDevice.getDeviceName()));
        mgrEditRow.setCell(this.mgr.bacModel().colOid, (BValue)bDiscoveryDevice.getObjectId());
        mgrEditRow.setCell(this.mgr.bacModel().colNetNum, (BValue)BInteger.make((int)bBacnetAddress.getNetworkNumber()));
        mgrEditRow.setCell(this.mgr.bacModel().colMacAddr, (BValue)BString.make((String)BBacnetAddress.bytesToString(bBacnetAddress.getAddressType(), bBacnetAddress.getMacAddress().getBytes())));
        boolean bl = bDiscoveryDevice.getServicesSupported().getBit(BacnetBitStringUtil.getBitIndex("BacnetServicesSupported", "subscribeCov"));
        mgrEditRow.setCell(this.mgr.bacModel().colUseCov, (BValue)BBoolean.make((boolean)bl));
    }

    public void jobComplete(BJob bJob) {
        Type type = bJob.getType();
        if (type == BBacnetDiscoverDevicesJob.TYPE) {
            bJob.lease(1);
            Class clazz = class$com$tridium$bacnet$job$BDiscoveryDevice;
            if (clazz == null) {
                clazz = class$com$tridium$bacnet$job$BDiscoveryDevice = BacnetDeviceLearn.class("[Lcom.tridium.bacnet.job.BDiscoveryDevice;", false);
            }
            this.lastLearn = (BDiscoveryDevice[])bJob.getChildren(clazz);
            this.updateRoots((Object[])this.lastLearn);
        } else if (type == BTimeSynchJob.TYPE) {
            String string = null;
            if (bJob.getJobState() == BJobState.success) {
                string = lex.getText("timeSynch.success");
            } else {
                BString bString = (BString)bJob.get("failureCause");
                String string2 = bString != null ? bString.getString() : "";
                string = MessageFormat.format(lex.getText("timeSynch.fail"), string2);
            }
            BDialog.message((BWidget)this.getManager(), (String)lex.getText("timeSynch.title"), (Object)string);
        } else if (type == BWhoHasJob.TYPE) {
            bJob.lease(1);
            BTextEditorPane bTextEditorPane = new BTextEditorPane("", 20, 80, false);
            Class clazz = class$javax$baja$sys$BString;
            if (clazz == null) {
                clazz = class$javax$baja$sys$BString = BacnetDeviceLearn.class("[Ljavax.baja.sys.BString;", false);
            }
            BString[] bStringArray = (BString[])bJob.getChildren(clazz);
            StringBuffer stringBuffer = new StringBuffer("I-Have Responses for\n");
            stringBuffer.append(bStringArray[0].getString());
            stringBuffer.append("\n\n");
            int n = 1;
            while (n < bStringArray.length) {
                stringBuffer.append(IHaveRequest.fromJob(bStringArray[n].getString()));
                ++n;
            }
            bTextEditorPane.setText(stringBuffer.toString());
            BDialog.message((BWidget)this.getManager(), (String)lex.getText("whoHas.label"), (Object)bTextEditorPane);
        } else if (type == BChangeDeviceIdJob.TYPE) {
            String string = null;
            if (bJob.getJobState() == BJobState.success) {
                string = lex.getText("changeId.success");
            } else {
                BString bString = (BString)bJob.get("failureCause");
                String string3 = bString != null ? bString.getString() : "";
                string = MessageFormat.format(lex.getText("changeId.fail"), string3);
            }
            BDialog.message((BWidget)this.getManager(), (String)lex.getText("changeId.title"), (Object)string);
        }
    }

    public BDiscoveryDevice[] getLastLearn() {
        return this.lastLearn;
    }

    protected BLearnTable makeTable() {
        return new BBacnetLearnTable(this);
    }

    public final int getColumnIndex(MgrColumn mgrColumn) {
        MgrColumn[] mgrColumnArray = this.getColumns();
        int n = 0;
        while (n < mgrColumnArray.length) {
            if (mgrColumn == mgrColumnArray[n]) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException("MgrColumn not found in getColumns()");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.dcolName = new MgrColumn.Prop(lexName, BDiscoveryDevice.deviceName, 0);
        this.dcolObjectId = new MgrColumn.Prop(lexDeviceId, BDiscoveryDevice.objectId, 0);
        this.dcolNetwork = new NetworkCol(lexNet);
        this.dcolAddr = new AddrCol(lexAddr);
        this.dcolVendorName = new MgrColumn.Prop(lexVendorName, BDiscoveryDevice.vendorName, 0);
        this.dcolModelName = new MgrColumn.Prop(lexModelName, BDiscoveryDevice.modelName, 0);
        this.dcolMaxApdu = new MgrColumn.Prop(lexMaxApdu, BDiscoveryDevice.maxApduLengthAccepted, 2);
        this.dcolSeg = new MgrColumn.Prop(lexSeg, BDiscoveryDevice.segmentationSupported, 2);
        this.dcolVendorId = new MgrColumn.Prop(lexVendorId, BDiscoveryDevice.vendorId, 2);
        this.dcolSize = new SizeCol(lexSize);
        this.dcolCharset = new MgrColumn.Prop(lexCset, BDiscoveryDevice.encoding, 2);
        this.dcolFwRev = new MgrColumn.Prop(lexFwRev, BDiscoveryDevice.firmwareRevision, 2);
        this.dcolAppSwVer = new MgrColumn.Prop(lexAppSwVer, BDiscoveryDevice.applicationSoftwareVersion, 2);
        this.dcolDup = new MgrColumn.Prop(lexDup, BDiscoveryDevice.duplicate, 2);
        this.dcols = new MgrColumn[]{this.dcolName, this.dcolObjectId, this.dcolNetwork, this.dcolAddr, this.dcolDup, this.dcolVendorName, this.dcolModelName, this.dcolMaxApdu, this.dcolSeg, this.dcolVendorId, this.dcolSize, this.dcolCharset, this.dcolFwRev, this.dcolAppSwVer};
    }

    public BacnetDeviceLearn(BBacnetDeviceManager bBacnetDeviceManager) {
        super((BAbstractManager)bBacnetDeviceManager);
        this.this();
        this.mgr = bBacnetDeviceManager;
    }

    static {
        Class clazz = class$com$tridium$bacnet$ui$device$BacnetDeviceLearn;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$ui$device$BacnetDeviceLearn = BacnetDeviceLearn.class("[Lcom.tridium.bacnet.ui.device.BacnetDeviceLearn;", false);
        }
        lex = new UiLexicon(clazz);
        lexName = lex.getText("deviceManager.name");
        lexDeviceId = lex.getText("deviceManager.deviceId");
        lexNet = lex.getText("deviceManager.network");
        lexAddr = lex.getText("deviceManager.mac");
        lexVendorName = lex.getText("deviceManager.vendorName");
        lexModelName = lex.getText("deviceManager.modelName");
        lexMaxApdu = lex.getText("deviceManager.maxApdu");
        lexSeg = lex.getText("deviceManager.segmentation");
        lexVendorId = lex.getText("deviceManager.vId");
        lexSize = lex.getText("deviceManager.size");
        lexCset = lex.getText("deviceManager.charSet");
        lexUnknown = lex.getText("deviceManager.unknown");
        lexFwRev = lex.getText("deviceManager.fwRev");
        lexAppSwVer = lex.getText("deviceManager.appSwVer");
        lexDup = lex.getText("deviceManager.dup");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class NetworkCol
    extends MgrColumn {
        public Object get(Object object) {
            return String.valueOf(BacnetDeviceLearn.this.disc(object).getAddress().getNetworkNumber());
        }

        public NetworkCol(String string) {
            super(string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class AddrCol
    extends MgrColumn {
        public Object get(Object object) {
            BBacnetStack bBacnetStack = (BBacnetStack)((BBacnetDeviceManager)this.getManager()).getNetwork().getBacnetComm();
            BDiscoveryDevice bDiscoveryDevice = BacnetDeviceLearn.this.disc(object);
            BNetworkPort bNetworkPort = bBacnetStack.getNetwork().getPortByNetwork(bDiscoveryDevice.getAddress().getNetworkNumber());
            byte[] byArray = bDiscoveryDevice.getAddress().getMacAddress().getBytes();
            int n = 0;
            if (bNetworkPort != null) {
                BBacnetLinkLayer bBacnetLinkLayer = bNetworkPort.getLink();
                if (bBacnetLinkLayer instanceof BBacnetIpLinkLayer) {
                    n = 2;
                } else if (bBacnetLinkLayer instanceof BBacnetEthernetLinkLayer) {
                    n = 1;
                } else if (bBacnetLinkLayer instanceof BBacnetMstpLinkLayer) {
                    n = 3;
                }
            }
            return BBacnetAddress.bytesToString(n, byArray);
        }

        public AddrCol(String string) {
            super(string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SizeCol
    extends MgrColumn {
        public Object get(Object object) {
            return BacnetDeviceLearn.this.disc(object).getListSize() > 0 ? String.valueOf(BacnetDeviceLearn.this.disc(object).getListSize()) : lexUnknown;
        }

        public SizeCol(String string) {
            super(string);
        }
    }
}

