/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.device;

import com.tridium.bacnet.datatypes.BChangeDeviceIdConfig;
import com.tridium.bacnet.datatypes.BDeviceDiscoveryConfig;
import com.tridium.bacnet.datatypes.BDiscoveryNetworks;
import com.tridium.bacnet.datatypes.BTimeSynchConfig;
import com.tridium.bacnet.datatypes.BWhoHasConfig;
import com.tridium.bacnet.job.BDiscoveryDevice;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.ui.device.BBacnetDeviceManager;
import java.text.MessageFormat;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrEditDialog;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BacnetDeviceController
extends DeviceController {
    private static UiLexicon lex = BBacnetDeviceManager.lexicon;
    private static Lexicon wblex;
    private static String addLabel;
    private static String newLabel;
    private static String changeIdLabel;
    private BBacnetDeviceManager deviceManager;
    BChangeDeviceIdConfig cfg;
    public final MgrController.MgrCommand whoHas;
    public final MgrController.MgrCommand timeSynch;
    public final MgrController.MgrCommand changeId;
    BJob job;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$MgrController;

    public BWidget makeActionBar() {
        MgrController.IMgrCommand[] iMgrCommandArray = super.makeCommands();
        MgrController.IMgrCommand[] iMgrCommandArray2 = this.makeBacnetCommands();
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop(this.makeActionPane(iMgrCommandArray));
        bEdgePane.setBottom((BWidget)new BBorderPane(this.makeActionPane(iMgrCommandArray2)));
        return bEdgePane;
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return BacnetDeviceController.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])this.makeBacnetCommands());
    }

    protected MgrController.IMgrCommand[] makeBacnetCommands() {
        return new MgrController.IMgrCommand[]{this.whoHas, this.timeSynch, this.changeId};
    }

    public void updateCommands() {
        super.updateCommands();
        BBacnetNetwork bBacnetNetwork = ((BBacnetDeviceManager)this.getManager()).getNetwork();
        BBacnetStack bBacnetStack = (BBacnetStack)bBacnetNetwork.getBacnetComm();
        BBacnetNetworkLayer bBacnetNetworkLayer = bBacnetStack.getNetwork();
        boolean bl = bBacnetStack.isCommInitiationEnabled();
        boolean bl2 = bBacnetNetworkLayer.isEnabled();
        if (bl && bl2) {
            this.setBacnetCommandsEnable(true);
            boolean bl3 = false;
            if (this.job != null && this.job.getJobState().isRunning()) {
                bl3 = true;
            }
            this.cancel.setEnabled(bl3);
            boolean bl4 = false;
            if (this.job == null || !this.job.getJobState().isRunning()) {
                bl4 = true;
            }
            this.discover.setEnabled(bl4);
        } else {
            this.discover.setEnabled(false);
            this.setBacnetCommandsEnable(false);
        }
    }

    protected void setBacnetCommandsEnable(boolean bl) {
        this.whoHas.setEnabled(bl);
        this.timeSynch.setEnabled(bl);
        this.changeId.setEnabled(bl);
        if (bl) {
            BComponent[] bComponentArray = this.getSelectedComponentsWithoutFolders();
            boolean bl2 = false;
            if (bComponentArray.length > 0) {
                bl2 = true;
            }
            this.changeId.setEnabled(bl2);
        } else {
            this.changeId.setEnabled(false);
        }
    }

    public void doAllDescendants(boolean bl) {
        super.doAllDescendants(bl);
        this.deviceManager.subscribeDevices(this.getManager().getCurrentValue().asComponent());
    }

    public MgrEdit makeEdit(String string) {
        if (string == null) {
            return super.makeEdit(string);
        }
        if (string.equals(addLabel) || string.equals(newLabel)) {
            return new MgrEdit(this.getManager(), string){

                public final CommandArtifact commit() throws Exception {
                    CommandArtifact commandArtifact = super.commit();
                    MgrEditRow[] mgrEditRowArray = this.getRows();
                    int n = 0;
                    while (n < mgrEditRowArray.length) {
                        BDiscoveryDevice bDiscoveryDevice = (BDiscoveryDevice)((Object)mgrEditRowArray[n].getDiscovery());
                        BBacnetObjectIdentifier bBacnetObjectIdentifier = (BBacnetObjectIdentifier)mgrEditRowArray[n].getCell(((BacnetDeviceController)BacnetDeviceController.this).deviceManager.bacModel().colOid);
                        BBacnetDevice bBacnetDevice = ((BBacnetDeviceManager)this.getManager()).getNetwork().lookupDeviceById(bBacnetObjectIdentifier);
                        if (bBacnetDevice != null) {
                            if (bDiscoveryDevice != null) {
                                bBacnetDevice.getConfig().getDeviceObject().setProtocolServicesSupported(bDiscoveryDevice.getServicesSupported());
                            }
                            bBacnetDevice.getConfig().getDeviceObject().lease();
                        }
                        ++n;
                    }
                    return commandArtifact;
                }
            };
        }
        if (string.equals(changeIdLabel)) {
            return new ChangeIdEdit(this.getManager(), string);
        }
        return super.makeEdit(string);
    }

    public BJob setJob(BOrd bOrd) throws Exception {
        try {
            ((BBacnetDeviceManager)this.getManager()).bacLearn().jobComplete = false;
            BComponent bComponent = (BComponent)this.getManager().getCurrentValue();
            bComponent.getComponentSpace().sync();
            this.job = (BJob)bOrd.get((BObject)bComponent);
            this.getManager().registerForComponentEvents((BComponent)this.job);
            ((BBacnetDeviceManager)this.getManager()).getJobBar().load(this.job);
            return this.job;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public CommandArtifact doCancel(Context context) throws Exception {
        if (this.job != null) {
            this.job.cancel();
        }
        return null;
    }

    public CommandArtifact doDiscover(Context context) throws Exception {
        super.doDiscover(context);
        BBacnetNetwork bBacnetNetwork = ((BBacnetDeviceManager)this.getManager()).getNetwork();
        BBacnetStack bBacnetStack = (BBacnetStack)bBacnetNetwork.getBacnetComm();
        int[] nArray = bBacnetStack.getNetwork().getRouterTable().getDnets(-1);
        BDeviceDiscoveryConfig bDeviceDiscoveryConfig = new BDeviceDiscoveryConfig();
        bDeviceDiscoveryConfig.setNetworks(BDiscoveryNetworks.make(false, nArray));
        BDeviceDiscoveryConfig bDeviceDiscoveryConfig2 = (BDeviceDiscoveryConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)lex.get("deviceManager.discover.description"), (BObject)bDeviceDiscoveryConfig);
        if (bDeviceDiscoveryConfig2 != null) {
            this.discover.setEnabled(false);
            BBacnetNetwork bBacnetNetwork2 = ((BBacnetDeviceManager)this.getManager()).getNetwork();
            this.setJob(bBacnetNetwork2.submitDeviceManagerJob((BValue)bDeviceDiscoveryConfig2));
        }
        return null;
    }

    public CommandArtifact doWhoHas() throws Exception {
        BBacnetNetwork bBacnetNetwork = ((BBacnetDeviceManager)this.getManager()).getNetwork();
        BBacnetStack bBacnetStack = (BBacnetStack)bBacnetNetwork.getBacnetComm();
        int[] nArray = bBacnetStack.getNetwork().getRouterTable().getDnets(-1);
        BWhoHasConfig bWhoHasConfig = new BWhoHasConfig();
        bWhoHasConfig.setNetworks(BDiscoveryNetworks.make(false, nArray));
        BWhoHasConfig bWhoHasConfig2 = (BWhoHasConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)lex.get("whoHas.description"), (BObject)bWhoHasConfig);
        if (bWhoHasConfig2 != null) {
            BBacnetNetwork bBacnetNetwork2 = ((BBacnetDeviceManager)this.getManager()).getNetwork();
            this.setJob(bBacnetNetwork2.submitDeviceManagerJob((BValue)bWhoHasConfig2));
        }
        return null;
    }

    public CommandArtifact doTimeSynch() throws Exception {
        try {
            int n = BDialog.confirm((BWidget)this.getManager(), (String)lex.get("timeSynch.title"), (Object)lex.get("timeSynch.confirm"));
            if (n == 8) {
                return null;
            }
            BTimeSynchConfig bTimeSynchConfig = (BTimeSynchConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)lex.get("timeSynch.title"), (BObject)new BTimeSynchConfig());
            if (bTimeSynchConfig == null) {
                return null;
            }
            BBacnetNetwork bBacnetNetwork = ((BBacnetDeviceManager)this.getManager()).getNetwork();
            this.setJob(bBacnetNetwork.submitDeviceManagerJob((BValue)bTimeSynchConfig));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = MessageFormat.format(lex.get("timeSynch.fail"), exception);
            BDialog.message((BWidget)this.getManager(), (String)lex.get("timeSynch.title"), (Object)string);
        }
        return null;
    }

    public CommandArtifact doChangeId() throws Exception {
        try {
            int n = BDialog.confirm((BWidget)this.getManager(), (String)lex.get("changeId.title"), (Object)lex.getText("changeId.confirm"));
            if (n == 8) {
                return null;
            }
            BComponent[] bComponentArray = this.getSelectedComponents();
            if (bComponentArray.length == 0) {
                return null;
            }
            MgrEdit mgrEdit = this.makeEdit(this.changeId.getLabel());
            int n2 = 0;
            while (n2 < bComponentArray.length) {
                mgrEdit.addRow(bComponentArray[n2]);
                ++n2;
            }
            mgrEdit.setSelectAll(true);
            if (!mgrEdit.prompt()) {
                return null;
            }
            mgrEdit.commit();
            this.cfg = (BChangeDeviceIdConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)lex.get("changeId.title"), (BObject)this.cfg);
            if (this.cfg == null) {
                return null;
            }
            BBacnetNetwork bBacnetNetwork = ((BBacnetDeviceManager)this.getManager()).getNetwork();
            this.setJob(bBacnetNetwork.submitDeviceManagerJob((BValue)this.cfg));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = MessageFormat.format(lex.get("changeId.fail"), exception);
            BDialog.message((BWidget)this.getManager(), (String)lex.get("changeId.title"), (Object)string);
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BacnetDeviceController(BBacnetDeviceManager bBacnetDeviceManager) {
        super((BDeviceManager)bBacnetDeviceManager);
        this.deviceManager = bBacnetDeviceManager;
        this.whoHas = new WhoHas((BWidget)bBacnetDeviceManager);
        this.timeSynch = new TimeSynch((BWidget)bBacnetDeviceManager);
        this.changeId = new ChangeId((BWidget)bBacnetDeviceManager);
        this.whoHas.setFlags(3);
        this.timeSynch.setFlags(7);
        this.changeId.setFlags(7);
    }

    static {
        Class clazz = class$javax$baja$workbench$mgr$MgrController;
        if (clazz == null) {
            clazz = class$javax$baja$workbench$mgr$MgrController = BacnetDeviceController.class("[Ljavax.baja.workbench.mgr.MgrController;", false);
        }
        wblex = Lexicon.make((Class)clazz);
        addLabel = wblex.getText("add.label");
        newLabel = wblex.getText("new.label");
        changeIdLabel = lex.getText("changeId.label");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ChangeIdEdit
    extends MgrEdit {
        protected MgrColumn[] makeColumns() {
            return ((BBacnetDeviceManager)this.getManager()).bacModel().getChangeIdColumns();
        }

        public boolean prompt() throws Exception {
            if (this.getRows().length == 0) {
                return false;
            }
            BMgrEditDialog bMgrEditDialog = new BMgrEditDialog((MgrEdit)this, this.getSelectAll());
            bMgrEditDialog.setScreenSizeToPreferredSize();
            bMgrEditDialog.setBoundsCenteredOnOwner();
            bMgrEditDialog.open();
            boolean bl = false;
            if (bMgrEditDialog.getResult() == 1) {
                bl = true;
            }
            return bl;
        }

        public CommandArtifact commit() throws Exception {
            BacnetDeviceController.this.cfg = new BChangeDeviceIdConfig();
            MgrEditRow[] mgrEditRowArray = this.getRows();
            int n = 0;
            while (n < mgrEditRowArray.length) {
                BBacnetObjectIdentifier bBacnetObjectIdentifier = (BBacnetObjectIdentifier)mgrEditRowArray[n].getCell(((BacnetDeviceController)BacnetDeviceController.this).deviceManager.bacModel().colOid);
                BBacnetDevice bBacnetDevice = (BBacnetDevice)mgrEditRowArray[n].getTarget();
                BacnetDeviceController.this.cfg.addChange(bBacnetDevice.getObjectId(), bBacnetObjectIdentifier);
                ++n;
            }
            return null;
        }

        public ChangeIdEdit(BAbstractManager bAbstractManager, String string) {
            super(bAbstractManager, string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WhoHas
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return BacnetDeviceController.this.doWhoHas();
        }

        WhoHas(BWidget bWidget) {
            super(bWidget, (Lexicon)lex, "whoHas");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TimeSynch
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return BacnetDeviceController.this.doTimeSynch();
        }

        TimeSynch(BWidget bWidget) {
            super(bWidget, (Lexicon)lex, "timeSynch");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ChangeId
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return BacnetDeviceController.this.doChangeId();
        }

        ChangeId(BWidget bWidget) {
            super(bWidget, (Lexicon)lex, "changeId");
        }
    }
}

