/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.transport.ApplicationPdu;

public abstract class TransportStateMachine {
    protected static BBacnetStack stack = null;
    public static final String CLIENT_TSM_NAME = "BacnetClientTSM";
    public static final String SERVER_TSM_NAME = "BacnetServerTSM";

    public static void startStack(BBacnetStack bBacnetStack) {
        if (stack != null) {
            throw new IllegalStateException("Attempt to re-initialize BACnet Transport Layer State Machine! Check for duplicate BacnetNetwork.");
        }
        stack = bBacnetStack;
    }

    public static void stopStack() {
        stack = null;
    }

    static final int modulo(int n, int n2) {
        while (n < 0) {
            n += n2;
        }
        return n % n2;
    }

    static final boolean inWindow(int n, int n2, int n3) {
        boolean bl = false;
        if (TransportStateMachine.modulo(n - n2, 256) < n3) {
            bl = true;
        }
        return bl;
    }

    static boolean duplicateInWindow(int n, int n2, int n3, int n4) {
        int n5 = TransportStateMachine.modulo(n3 - n2, 256);
        if (n5 > n4) {
            return false;
        }
        return TransportStateMachine.modulo(n - n2, 256) <= n5;
    }

    public abstract void route(ApplicationPdu var1);

    public abstract String getName();
}

