/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.InvalidApduTypeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;

public class SimpleAckPdu
extends ApplicationPdu {
    private int originalInvokeId;
    private int serviceAckChoice;

    public int getInvokeId() {
        return this.originalInvokeId;
    }

    public int getServiceAckChoice() {
        return this.serviceAckChoice;
    }

    public boolean isServerPDU() {
        return true;
    }

    public boolean isClientPDU() {
        return false;
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(32);
        byteArrayOutputStream.write(this.originalInvokeId);
        byteArrayOutputStream.write(this.serviceAckChoice);
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        int n = byteArrayInputStream.read() >> 4;
        if (n != 2) {
            throw new InvalidApduTypeException(2, n);
        }
        this.originalInvokeId = byteArrayInputStream.read();
        this.serviceAckChoice = byteArrayInputStream.read();
    }

    public String toString() {
        return this.msg();
    }

    public String trace() {
        StringBuffer stringBuffer = new StringBuffer("SimpleAckPdu:");
        stringBuffer.append("\n\toriginalInvokeId = " + this.originalInvokeId);
        stringBuffer.append("\n\tserviceAckChoice = " + BacnetConfirmedServiceChoice.TAGS[this.serviceAckChoice]);
        this.addAPDUData(stringBuffer);
        return stringBuffer.toString();
    }

    public String msg() {
        StringBuffer stringBuffer = new StringBuffer("SAckPDU:");
        stringBuffer.append(' ').append(this.originalInvokeId);
        stringBuffer.append(' ').append(BacnetConfirmedServiceChoice.TAGS[this.serviceAckChoice]);
        this.addAPDUMsg(stringBuffer);
        return stringBuffer.toString();
    }

    public SimpleAckPdu() {
        super(2);
    }

    public SimpleAckPdu(BBacnetAddress bBacnetAddress, BNetworkPriority bNetworkPriority, int n, int n2) {
        super(bBacnetAddress, null, bNetworkPriority, 2);
        this.originalInvokeId = n;
        this.serviceAckChoice = n2;
    }

    public SimpleAckPdu(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        super(2);
        this.readNetworkBytes(byteArrayInputStream);
    }
}

