/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.ComplexAckPdu;
import com.tridium.bacnet.stack.transport.ConfirmedRequestPdu;
import com.tridium.bacnet.stack.transport.Transaction;
import com.tridium.bacnet.stack.transport.TransactionList;
import javax.baja.bacnet.datatypes.BBacnetAddress;

public class ServerTransaction
extends Transaction {
    static TransactionList activeTransactions = new TransactionList();
    private ConfirmedRequestPdu apdu;
    private ComplexAckPdu complexAck;
    private boolean abortedByClient;

    public boolean isServerTransaction() {
        return true;
    }

    protected ApplicationPdu getApdu() {
        return this.apdu;
    }

    protected TransactionList activeTransactions() {
        return activeTransactions;
    }

    public long getHashCode() {
        return ServerTransaction.hash(this.getClientAddress(), this.getInvokeId());
    }

    public static ServerTransaction find(ApplicationPdu applicationPdu) {
        return (ServerTransaction)activeTransactions.get(applicationPdu.getClientAddress(), applicationPdu.getInvokeId());
    }

    public BBacnetAddress getClientAddress() {
        return this.apdu.getClientAddress();
    }

    public BBacnetAddress getServerAddress() {
        return this.apdu.getServerAddress();
    }

    public int getInvokeId() {
        return this.apdu.getInvokeId();
    }

    public void setComplexAck(ComplexAckPdu complexAckPdu) {
        this.complexAck = complexAckPdu;
    }

    public ComplexAckPdu getResponse() {
        return this.complexAck;
    }

    public ConfirmedRequestPdu getRequest() {
        return this.apdu;
    }

    public void clientAbort() {
        this.abortedByClient = true;
    }

    public boolean isClientAbort() {
        return this.abortedByClient;
    }

    protected String getTag(int n) {
        switch (n) {
            case 0: {
                return "IDLE";
            }
            case 1: {
                return "SEGMENTED_REQUEST";
            }
            case 2: {
                return "AWAIT_RESPONSE";
            }
            case 3: {
                return "SEGMENTED_RESP";
            }
        }
        throw new IllegalStateException();
    }

    public ServerTransaction(ConfirmedRequestPdu confirmedRequestPdu) {
        this.apdu = confirmedRequestPdu;
    }
}

