/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.transport.ApplicationPdu;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class SegmentAckPdu
extends ApplicationPdu {
    public static final int SERVER_BIT = 1;
    public static final int NEGATIVE_ACK_BIT = 2;
    private boolean negativeAck;
    private boolean server;
    private int originalInvokeId;
    private int sequenceNumber;
    private int actualWindowSize;

    public boolean getNegativeAck() {
        return this.negativeAck;
    }

    public boolean getServer() {
        return this.server;
    }

    public int getOriginalInvokeId() {
        return this.originalInvokeId;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getActualWindowSize() {
        return this.actualWindowSize;
    }

    public boolean isServerPDU() {
        return this.server;
    }

    public boolean isClientPDU() {
        return this.server ^ true;
    }

    public int getInvokeId() {
        return this.originalInvokeId;
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        int n = 64;
        if (this.server) {
            n |= 1;
        }
        if (this.negativeAck) {
            n |= 2;
        }
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(this.originalInvokeId);
        byteArrayOutputStream.write(this.sequenceNumber);
        byteArrayOutputStream.write(this.actualWindowSize);
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) {
        int n = byteArrayInputStream.read();
        if ((n & 1) != 0) {
            this.server = true;
        }
        if ((n & 2) != 0) {
            this.negativeAck = true;
        }
        this.originalInvokeId = byteArrayInputStream.read();
        this.sequenceNumber = byteArrayInputStream.read();
        this.actualWindowSize = byteArrayInputStream.read();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SegmentAckPdu:");
        stringBuffer.append("\n\tNAK = " + this.negativeAck);
        stringBuffer.append("\n\tSRV = " + this.server);
        stringBuffer.append("\n\tOriginalInvoke ID = " + this.originalInvokeId);
        stringBuffer.append("\n\tSequence # = " + this.sequenceNumber);
        stringBuffer.append("\n\tActual Window Size = " + this.actualWindowSize);
        return stringBuffer.toString();
    }

    public SegmentAckPdu() {
        super(4);
    }

    public SegmentAckPdu(boolean bl, boolean bl2, int n, int n2, int n3) {
        super(4);
        this.negativeAck = bl;
        this.server = bl2;
        this.originalInvokeId = n;
        this.sequenceNumber = n2;
        this.actualWindowSize = n3;
    }

    public SegmentAckPdu(ByteArrayInputStream byteArrayInputStream) {
        super(4);
        this.readNetworkBytes(byteArrayInputStream);
    }
}

