/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.InvalidApduTypeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.enums.BBacnetRejectReason;

public class RejectPdu
extends ApplicationPdu {
    private int originalInvokeId;
    private int rejectReason;

    public int originalInvokeId() {
        return this.originalInvokeId;
    }

    public int getRejectReason() {
        return this.rejectReason;
    }

    public boolean isServerPDU() {
        return true;
    }

    public boolean isClientPDU() {
        return false;
    }

    public int getInvokeId() {
        return this.originalInvokeId;
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(96);
        byteArrayOutputStream.write(this.originalInvokeId);
        byteArrayOutputStream.write(this.rejectReason);
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        int n = (byteArrayInputStream.read() & 0xF0) >> 4;
        if (n != 6) {
            throw new InvalidApduTypeException(6, n);
        }
        this.originalInvokeId = byteArrayInputStream.read();
        this.rejectReason = byteArrayInputStream.read();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("RejectPdu:");
        stringBuffer.append("\n\toriginalInvokeId = " + this.originalInvokeId);
        stringBuffer.append("\n\treject reason = " + BBacnetRejectReason.tag(this.rejectReason));
        return stringBuffer.toString();
    }

    public RejectPdu(BBacnetAddress bBacnetAddress, BNetworkPriority bNetworkPriority, int n, int n2) {
        super(bBacnetAddress, null, bNetworkPriority, 6);
        this.originalInvokeId = n;
        this.rejectReason = n2;
    }

    public RejectPdu(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        super(6);
        this.readNetworkBytes(byteArrayInputStream);
    }
}

