/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.BacnetStackErrorCodes;
import com.tridium.bacnet.stack.BacnetStackException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;

public class IdManager
implements BacnetStackErrorCodes {
    public static final int MAX_INVOKE_ID = 255;
    public static final int INVALID_INVOKE_ID = -1;
    private static IntHashMap table = new IntHashMap();
    private int lastIndex = 0;
    private BBacnetAddress serverAddress;
    private InvokeIdEntry[] ids = new InvokeIdEntry[256];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getInvokeId(BBacnetAddress bBacnetAddress) throws BacnetStackException {
        IntHashMap intHashMap = table;
        synchronized (intHashMap) {
            IdManager idManager = (IdManager)table.get(bBacnetAddress.hash());
            if (idManager == null) {
                idManager = new IdManager(bBacnetAddress);
                table.put(bBacnetAddress.hash(), (Object)idManager);
            }
            return idManager.nextId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void releaseId(BBacnetAddress bBacnetAddress, int n) {
        IntHashMap intHashMap = table;
        synchronized (intHashMap) {
            IdManager idManager = (IdManager)table.get(bBacnetAddress.hash());
            if (idManager != null) {
                idManager.release(n);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dump(BBacnetAddress bBacnetAddress) {
        IntHashMap intHashMap = table;
        synchronized (intHashMap) {
            IdManager idManager = (IdManager)table.get(bBacnetAddress.hash());
            if (idManager != null) {
                idManager.dump();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dumpTable() {
        IntHashMap intHashMap = table;
        synchronized (intHashMap) {
            IntHashMap.Iterator iterator = table.iterator();
            while (iterator.hasNext()) {
                IdManager idManager = (IdManager)iterator.next();
                if (idManager == null) continue;
                idManager.dump();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps();
        spyWriter.trTitle((Object)"IdManager", 2);
        IntHashMap intHashMap = table;
        synchronized (intHashMap) {
            spyWriter.prop((Object)"table size", table.size());
            IntHashMap.Iterator iterator = table.iterator();
            while (iterator.hasNext()) {
                IdManager idManager = (IdManager)iterator.next();
                if (idManager == null) continue;
                idManager.spyMgr(spyWriter);
            }
        }
        spyWriter.endProps();
    }

    public void spyMgr(SpyWriter spyWriter) throws Exception {
        spyWriter.prop((Object)"server", (Object)this.serverAddress);
        spyWriter.prop((Object)"server.hash", (Object)Integer.toHexString(this.serverAddress.hash()));
        spyWriter.prop((Object)"server.hashCode", (Object)Integer.toHexString(this.serverAddress.hashCode()));
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n <= 255) {
            stringBuffer.append(this.ids[n].available ? (char)'-' : 'X');
            if (n % 64 == 63) {
                stringBuffer.append(' ');
            }
            ++n;
        }
        spyWriter.prop((Object)"avail", (Object)stringBuffer.toString());
    }

    private final synchronized int nextId() throws BacnetStackException {
        int n;
        int n2 = n = this.lastIndex++;
        try {
            do {
                if (++n > 255) {
                    n = 0;
                }
                if (!this.ids[n].isAvailable()) continue;
                this.ids[n].setAvailable(false);
                this.lastIndex = n;
                return this.ids[n].id;
            } while (n != n2);
            throw new BacnetStackException("No Invoke IDs available");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception in IdManager!");
            System.out.println("index=" + n + ", lastIndex=" + this.lastIndex + ", startIndex=" + n2 + ", ids[" + n + "]=" + this.ids[n]);
            throw new BacnetStackException("No Invoke IDs available");
        }
    }

    private final synchronized void release(int n) {
        if (n > 255 || n < 0) {
            throw new IllegalArgumentException();
        }
        if (this.ids[n].isAvailable()) {
            throw new IllegalStateException();
        }
        this.ids[n].setAvailable(true);
    }

    public String toString() {
        return this.serverAddress.toString(null) + " lst=" + this.lastIndex;
    }

    public void dump() {
        System.out.println("Dump for " + this + " (hc:" + this.serverAddress.hash() + ')');
        int n = 0;
        while (n < 255) {
            System.out.print(this.ids[n].isAvailable() ? (char)'-' : 'X');
            if (n % 64 == 63) {
                System.out.println();
            }
            ++n;
        }
        System.out.println();
    }

    private IdManager(BBacnetAddress bBacnetAddress) {
        int n = 0;
        while (n <= 255) {
            this.ids[n] = new InvokeIdEntry(n);
            ++n;
        }
        this.serverAddress = bBacnetAddress;
    }

    public static class InvokeIdEntry {
        int id;
        boolean available;

        boolean isAvailable() {
            return this.available;
        }

        void setAvailable(boolean bl) {
            this.available = bl;
        }

        InvokeIdEntry(int n) {
            this.id = n;
            this.available = true;
        }
    }
}

