/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.InvalidApduTypeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.util.ByteArrayUtil;

public class ErrorPdu
extends ApplicationPdu {
    private int originalInvokeId;
    private int errorChoice;
    private byte[] error;

    public int getOriginalInvokeId() {
        return this.originalInvokeId;
    }

    public int getErrorChoice() {
        return this.errorChoice;
    }

    public byte[] getError() {
        return this.error;
    }

    public boolean isServerPDU() {
        return true;
    }

    public boolean isClientPDU() {
        return false;
    }

    public int getInvokeId() {
        return this.originalInvokeId;
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(80);
        byteArrayOutputStream.write(this.originalInvokeId);
        byteArrayOutputStream.write(this.errorChoice);
        byteArrayOutputStream.write(this.error, 0, this.error.length);
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        int n = byteArrayInputStream.read();
        int n2 = (n & 0xF0) >> 4;
        if (n2 != 5) {
            throw new InvalidApduTypeException(5, n2);
        }
        this.originalInvokeId = byteArrayInputStream.read();
        this.errorChoice = byteArrayInputStream.read();
        this.error = new byte[byteArrayInputStream.available()];
        byteArrayInputStream.read(this.error, 0, this.error.length);
    }

    public String toString() {
        return this.msg();
    }

    public String trace() {
        StringBuffer stringBuffer = new StringBuffer("ErrorPdu:");
        stringBuffer.append("\n\tOriginalInvoke ID = " + this.originalInvokeId);
        stringBuffer.append("\n\tErrorChoice = " + BacnetConfirmedServiceChoice.TAGS[this.errorChoice]);
        if (this.error != null) {
            stringBuffer.append("\n\terror (length) = " + this.error.length);
        }
        this.addAPDUData(stringBuffer);
        return stringBuffer.toString();
    }

    public String msg() {
        StringBuffer stringBuffer = new StringBuffer("ErrPDU:");
        stringBuffer.append(' ').append(this.originalInvokeId);
        stringBuffer.append(' ').append(BacnetConfirmedServiceChoice.TAGS[this.errorChoice]);
        stringBuffer.append(' ').append(ByteArrayUtil.toHexString((byte[])this.error));
        return stringBuffer.toString();
    }

    public ErrorPdu() {
        super(5);
    }

    public ErrorPdu(BBacnetAddress bBacnetAddress, BNetworkPriority bNetworkPriority, int n, int n2, byte[] byArray) {
        super(bBacnetAddress, null, bNetworkPriority, 5);
        this.originalInvokeId = n2;
        this.errorChoice = n;
        this.error = byArray;
    }

    public ErrorPdu(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        super(5);
        this.readNetworkBytes(byteArrayInputStream);
    }
}

