/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.transport.AbortPdu;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.ClientTransaction;
import com.tridium.bacnet.stack.transport.ComplexAckPdu;
import com.tridium.bacnet.stack.transport.ConfirmedRequestPdu;
import com.tridium.bacnet.stack.transport.SegmentAckPdu;
import com.tridium.bacnet.stack.transport.TransportStateMachine;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.log.Log;

public class ClientStateMachine
extends TransportStateMachine {
    public String getName() {
        return "BacnetClientTSM";
    }

    public void route(ApplicationPdu applicationPdu) {
        ClientStateMachine.process(applicationPdu);
    }

    public static final void process(ApplicationPdu applicationPdu) {
        block13: {
            ClientTransaction clientTransaction = null;
            try {
                clientTransaction = ClientTransaction.find(applicationPdu);
                if (clientTransaction == null) {
                    Idle.process(applicationPdu);
                    return;
                }
                switch (clientTransaction.getState()) {
                    case 1: {
                        SegmentedRequest.process(applicationPdu, clientTransaction);
                        break;
                    }
                    case 2: {
                        AwaitConfirmation.process(applicationPdu, clientTransaction);
                        break;
                    }
                    case 3: {
                        SegmentedConf.process(applicationPdu, clientTransaction);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("CSM.process():" + applicationPdu.trace());
                    }
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (clientTransaction != null) {
                    clientTransaction.stopRequestTimer();
                }
                if (applicationPdu != null && applicationPdu instanceof ConfirmedRequestPdu) {
                    ((ConfirmedRequestPdu)applicationPdu).cannotSend(unsupportedOperationException);
                }
            }
            catch (Exception exception) {
                Log log = Log.getLog((String)"bacnet.transport");
                if (log.isLoggable(1)) {
                    Log.getLog((String)"bacnet.transport").message("Exception in CSM.process:transaction=" + clientTransaction + " apdu=" + applicationPdu.trace() + "\n exception:");
                    exception.printStackTrace(System.out);
                }
                if (clientTransaction != null) {
                    Log.getLog((String)"bacnet.transport").message("transaction pdu:" + clientTransaction.getRequestPdu().trace());
                    clientTransaction.stopRequestTimer();
                }
                if (applicationPdu == null || !(applicationPdu instanceof ConfirmedRequestPdu)) break block13;
                ((ConfirmedRequestPdu)applicationPdu).abandon(exception);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void sendConfirmedRequest(ClientTransaction clientTransaction, ConfirmedRequestPdu confirmedRequestPdu) {
        int n = DeviceRegistry.getMaxApduLengthSupported(confirmedRequestPdu.getServerAddress());
        int n2 = confirmedRequestPdu.getMaxAPDULengthAccepted();
        int n3 = Math.min(n, n2);
        if (confirmedRequestPdu.getLength() + 4 > n3) {
            BBacnetSegmentation bBacnetSegmentation = DeviceRegistry.getSegmentationSupported(confirmedRequestPdu.getServerAddress());
            if (!BBacnetNetwork.localDevice().getSegmentationSupported().isSegmentedTransmit()) {
                throw new UnsupportedOperationException("Cannot send segmented packet: Niagara not configured for segmentation");
            }
            if (!bBacnetSegmentation.isSegmentedReceive()) throw new UnsupportedOperationException("Cannot send segmented packet: device does not support segmentation");
            ClientStateMachine.sendConfirmedRequestSegmented(clientTransaction, confirmedRequestPdu, n3);
            return;
        } else {
            ClientStateMachine.sendConfirmedRequestUnsegmented(clientTransaction, confirmedRequestPdu);
        }
    }

    private static final void sendConfirmedRequestUnsegmented(ClientTransaction clientTransaction, ConfirmedRequestPdu confirmedRequestPdu) {
        clientTransaction.setSentAllSegments(true);
        confirmedRequestPdu.setSegmentedMessage(false);
        ClientStateMachine.network().sendRequest(clientTransaction.getServerAddress(), confirmedRequestPdu);
        clientTransaction.setState(2);
        clientTransaction.startRequestTimer(BBacnetNetwork.localDevice().getApduTimeout());
    }

    private static final void sendConfirmedRequestSegmented(ClientTransaction clientTransaction, ConfirmedRequestPdu confirmedRequestPdu, int n) {
        confirmedRequestPdu.setSegmentedMessage(true);
        ConfirmedRequestPdu confirmedRequestPdu2 = new ConfirmedRequestPdu(confirmedRequestPdu, 0, n, 0);
        clientTransaction.setSentAllSegments(false);
        clientTransaction.setSegmentRetryCount(0);
        clientTransaction.setInitialSequenceNumber(0);
        clientTransaction.setSegmentCounter(0);
        clientTransaction.setProposedWindowSize(10);
        clientTransaction.setActualWindowSize(1);
        clientTransaction.setSegmentSize(n);
        clientTransaction.setNumSegments(confirmedRequestPdu.getLength() / (n - 6) + 1);
        confirmedRequestPdu2.setMoreFollows(true);
        confirmedRequestPdu2.setProposedWindowSize(clientTransaction.getProposedWindowSize());
        ClientStateMachine.network().sendRequest(clientTransaction.getServerAddress(), confirmedRequestPdu2);
        clientTransaction.setState(1);
        clientTransaction.startSegmentTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
    }

    private static final void sendAbort(ApplicationPdu applicationPdu, int n) {
        AbortPdu abortPdu = new AbortPdu(applicationPdu.getServerAddress(), applicationPdu.getPriority(), applicationPdu.getInvokeId(), n, false);
        ClientStateMachine.network().sendRequest(applicationPdu.getServerAddress(), abortPdu);
    }

    private static final void fillWindow(ClientTransaction clientTransaction) {
        int n;
        int n2 = 0;
        int n3 = clientTransaction.getNumSegments() - 1;
        int n4 = clientTransaction.getInitialSequenceNumber();
        int n5 = clientTransaction.getSegmentSize();
        int n6 = n4;
        int n7 = n = clientTransaction.getSegmentCounter();
        ConfirmedRequestPdu confirmedRequestPdu = clientTransaction.getRequestPdu();
        do {
            ConfirmedRequestPdu confirmedRequestPdu2;
            n6 = n4 + n2;
            n7 = n + n2;
            if (n7 >= n3) {
                n6 = n3;
                confirmedRequestPdu2 = new ConfirmedRequestPdu(confirmedRequestPdu, ClientStateMachine.modulo(n6, 256), n5, n7);
                confirmedRequestPdu2.setSegmentedMessage(true);
                confirmedRequestPdu2.setMoreFollows(false);
                confirmedRequestPdu2.setProposedWindowSize(clientTransaction.getProposedWindowSize());
                ClientStateMachine.network().sendRequest(clientTransaction.getServerAddress(), confirmedRequestPdu2);
                clientTransaction.setSentAllSegments(true);
                return;
            }
            confirmedRequestPdu2 = new ConfirmedRequestPdu(confirmedRequestPdu, ClientStateMachine.modulo(n6, 256), n5, n7);
            confirmedRequestPdu2.setSegmentedMessage(true);
            confirmedRequestPdu2.setMoreFollows(true);
            confirmedRequestPdu2.setProposedWindowSize(clientTransaction.getProposedWindowSize());
            ClientStateMachine.network().sendRequest(clientTransaction.getServerAddress(), confirmedRequestPdu2);
        } while (++n2 < clientTransaction.getActualWindowSize());
    }

    private static final void sendSegmentAck(ClientTransaction clientTransaction, boolean bl, int n) {
        SegmentAckPdu segmentAckPdu = new SegmentAckPdu(bl, false, clientTransaction.getInvokeId(), n, clientTransaction.getActualWindowSize());
        ClientStateMachine.network().sendRequest(clientTransaction.getServerAddress(), segmentAckPdu);
    }

    private static final void receiveSegmentedComplexAck(ClientTransaction clientTransaction, ComplexAckPdu complexAckPdu) {
        clientTransaction.stopRequestTimer();
        clientTransaction.setComplexAck(complexAckPdu);
        clientTransaction.setActualWindowSize(complexAckPdu.getProposedWindowSize());
        clientTransaction.setLastSequenceNumber(0);
        clientTransaction.setInitialSequenceNumber(0);
        ClientStateMachine.sendSegmentAck(clientTransaction, false, 0);
        clientTransaction.startSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
        clientTransaction.setState(3);
    }

    private static final BBacnetNetworkLayer network() {
        return stack.getNetwork();
    }

    static class Idle {
        public static void process(ApplicationPdu applicationPdu) {
            switch (applicationPdu.getSource()) {
                case 0: {
                    Idle.processApplication(applicationPdu);
                    break;
                }
                case 1: {
                    Idle.processNetworkIndication(applicationPdu);
                    break;
                }
                default: {
                    System.out.println("invalid apdu source:" + applicationPdu.getSource());
                    throw new IllegalStateException("Idle.process():" + applicationPdu.trace());
                }
            }
        }

        private static final void processApplication(ApplicationPdu applicationPdu) {
            int n = applicationPdu.getType();
            switch (n) {
                case 1: {
                    ClientStateMachine.network().sendRequest(applicationPdu.getServerAddress(), applicationPdu);
                    break;
                }
                case 0: {
                    ClientTransaction clientTransaction = new ClientTransaction((ConfirmedRequestPdu)applicationPdu);
                    clientTransaction.setRetryCount(0);
                    ClientStateMachine.sendConfirmedRequest(clientTransaction, (ConfirmedRequestPdu)applicationPdu);
                    break;
                }
                default: {
                    throw new IllegalStateException("Idle.processApplication():" + applicationPdu.trace());
                }
            }
        }

        private static final void processNetworkIndication(ApplicationPdu applicationPdu) {
            switch (applicationPdu.getType()) {
                case 3: {
                    ComplexAckPdu complexAckPdu = (ComplexAckPdu)applicationPdu;
                    if (!complexAckPdu.isSegmentedMessage()) break;
                    ClientStateMachine.sendAbort(applicationPdu, 2);
                    break;
                }
                case 4: {
                    if (!applicationPdu.isServerPDU()) break;
                    ClientStateMachine.sendAbort(applicationPdu, 2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Idle.processNetworkIndication():" + applicationPdu.trace());
                }
            }
        }

        Idle() {
        }
    }

    private static class SegmentedRequest {
        public static final void process(ApplicationPdu applicationPdu, ClientTransaction clientTransaction) {
            switch (applicationPdu.getSource()) {
                case 0: {
                    SegmentedRequest.processApplication(applicationPdu, clientTransaction);
                    break;
                }
                case 1: {
                    SegmentedRequest.processNetworkIndication(applicationPdu, clientTransaction);
                    break;
                }
                case 3: {
                    SegmentedRequest.processSegmentTimeout(applicationPdu, clientTransaction);
                    break;
                }
                default: {
                    throw new IllegalStateException("SegmentedRequest.process():" + applicationPdu.trace());
                }
            }
        }

        private static final void processApplication(ApplicationPdu applicationPdu, ClientTransaction clientTransaction) {
            switch (applicationPdu.getType()) {
                case 7: {
                    clientTransaction.stopSegmentTimer();
                    ClientStateMachine.network().sendRequest(clientTransaction.getServerAddress(), applicationPdu);
                    clientTransaction.setState(0);
                    break;
                }
                default: {
                    throw new IllegalStateException("SegmentedRequest.processApplication():" + applicationPdu.trace());
                }
            }
        }

        private static final void processNetworkIndication(ApplicationPdu applicationPdu, ClientTransaction clientTransaction) {
            switch (applicationPdu.getType()) {
                case 4: {
                    SegmentAckPdu segmentAckPdu = (SegmentAckPdu)applicationPdu;
                    if (!ClientStateMachine.inWindow(segmentAckPdu.getSequenceNumber(), clientTransaction.getInitialSequenceNumber(), segmentAckPdu.getActualWindowSize())) {
                        clientTransaction.restartSegmentTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                        return;
                    }
                    if (!clientTransaction.getSentAllSegments()) {
                        int n = clientTransaction.getSegmentCounter();
                        clientTransaction.setSegmentCounter(n + clientTransaction.getActualWindowSize());
                        clientTransaction.setInitialSequenceNumber(ClientStateMachine.modulo(segmentAckPdu.getSequenceNumber() + 1, 256));
                        clientTransaction.setActualWindowSize(segmentAckPdu.getActualWindowSize());
                        clientTransaction.setSegmentRetryCount(0);
                        ClientStateMachine.fillWindow(clientTransaction);
                        clientTransaction.restartSegmentTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                        return;
                    }
                    clientTransaction.stopSegmentTimer();
                    clientTransaction.startRequestTimer(BBacnetNetwork.localDevice().getApduTimeout());
                    clientTransaction.setState(2);
                    break;
                }
                case 7: {
                    clientTransaction.stopSegmentTimer();
                    clientTransaction.postConfirmation(applicationPdu);
                    clientTransaction.setState(0);
                    break;
                }
                case 2: {
                    if (clientTransaction.getSentAllSegments()) {
                        clientTransaction.stopRequestTimer();
                        clientTransaction.stopSegmentTimer();
                        clientTransaction.postConfirmation(applicationPdu);
                        clientTransaction.setState(0);
                        break;
                    }
                    clientTransaction.stopSegmentTimer();
                    clientTransaction.timeout();
                    ClientStateMachine.sendAbort(applicationPdu, 2);
                    clientTransaction.setState(0);
                    break;
                }
                case 3: {
                    ComplexAckPdu complexAckPdu = (ComplexAckPdu)applicationPdu;
                    if (!clientTransaction.getSentAllSegments()) {
                        clientTransaction.stopSegmentTimer();
                        clientTransaction.timeout();
                        ClientStateMachine.sendAbort(applicationPdu, 2);
                        clientTransaction.setState(0);
                        return;
                    }
                    if (!complexAckPdu.isSegmentedMessage()) {
                        clientTransaction.stopRequestTimer();
                        clientTransaction.stopSegmentTimer();
                        clientTransaction.postConfirmation(applicationPdu);
                        clientTransaction.setState(0);
                        return;
                    }
                    if (complexAckPdu.getSequenceNumber() != 0) {
                        clientTransaction.stopSegmentTimer();
                        clientTransaction.timeout();
                        ClientStateMachine.sendAbort(applicationPdu, 2);
                        clientTransaction.setState(0);
                        return;
                    }
                    clientTransaction.stopSegmentTimer();
                    ClientStateMachine.receiveSegmentedComplexAck(clientTransaction, complexAckPdu);
                    break;
                }
                case 5: 
                case 6: {
                    if (clientTransaction.getSentAllSegments()) {
                        clientTransaction.stopRequestTimer();
                        clientTransaction.stopSegmentTimer();
                        clientTransaction.postConfirmation(applicationPdu);
                        clientTransaction.setState(0);
                        break;
                    }
                    clientTransaction.stopSegmentTimer();
                    clientTransaction.timeout();
                    ClientStateMachine.sendAbort(applicationPdu, 2);
                    clientTransaction.setState(0);
                    break;
                }
                default: {
                    throw new IllegalStateException("SegmentedRequest.processNetworkIndication():" + applicationPdu.trace());
                }
            }
        }

        private static final void processSegmentTimeout(ApplicationPdu applicationPdu, ClientTransaction clientTransaction) {
            int n = clientTransaction.getSegmentRetryCount();
            if (n < BBacnetNetwork.localDevice().getNumberOfApduRetries()) {
                clientTransaction.setSegmentRetryCount(++n);
                ClientStateMachine.fillWindow(clientTransaction);
                clientTransaction.restartSegmentTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
            } else {
                clientTransaction.stopSegmentTimer();
                clientTransaction.timeout();
                clientTransaction.setState(0);
            }
        }

        private SegmentedRequest() {
        }
    }

    private static class AwaitConfirmation {
        public static final void process(ApplicationPdu applicationPdu, ClientTransaction clientTransaction) {
            switch (applicationPdu.getSource()) {
                case 0: {
                    AwaitConfirmation.processApplication(applicationPdu, clientTransaction);
                    break;
                }
                case 1: {
                    AwaitConfirmation.processNetworkIndication(applicationPdu, clientTransaction);
                    break;
                }
                case 2: {
                    AwaitConfirmation.processRequestTimeout(applicationPdu, clientTransaction);
                    break;
                }
                default: {
                    throw new IllegalStateException("AwaitConfirmation.process():" + applicationPdu.trace());
                }
            }
        }

        private static final void processApplication(ApplicationPdu applicationPdu, ClientTransaction clientTransaction) {
            switch (applicationPdu.getType()) {
                case 7: {
                    clientTransaction.stopRequestTimer();
                    ClientStateMachine.network().sendRequest(clientTransaction.getServerAddress(), applicationPdu);
                    clientTransaction.setState(0);
                    break;
                }
                default: {
                    throw new IllegalStateException("AwaitConfirmation.processApplication():" + applicationPdu.trace());
                }
            }
        }

        private static final void processNetworkIndication(ApplicationPdu applicationPdu, ClientTransaction clientTransaction) {
            switch (applicationPdu.getType()) {
                case 2: {
                    clientTransaction.stopRequestTimer();
                    clientTransaction.postConfirmation(applicationPdu);
                    clientTransaction.setState(0);
                    break;
                }
                case 3: {
                    ComplexAckPdu complexAckPdu = (ComplexAckPdu)applicationPdu;
                    if (complexAckPdu.isSegmentedMessage()) {
                        if (!BBacnetNetwork.localDevice().getSegmentationSupported().isSegmentedReceive()) {
                            clientTransaction.stopRequestTimer();
                            clientTransaction.timeout();
                            ClientStateMachine.sendAbort(applicationPdu, 4);
                            clientTransaction.setState(0);
                            break;
                        }
                        if (complexAckPdu.getSequenceNumber() != 0) {
                            clientTransaction.stopRequestTimer();
                            clientTransaction.timeout();
                            ClientStateMachine.sendAbort(applicationPdu, 2);
                            clientTransaction.setState(0);
                            break;
                        }
                        ClientStateMachine.receiveSegmentedComplexAck(clientTransaction, complexAckPdu);
                        break;
                    }
                    clientTransaction.stopRequestTimer();
                    clientTransaction.postConfirmation(applicationPdu);
                    clientTransaction.setState(0);
                    break;
                }
                case 5: {
                    clientTransaction.stopRequestTimer();
                    clientTransaction.postConfirmation(applicationPdu);
                    clientTransaction.setState(0);
                    break;
                }
                case 6: {
                    clientTransaction.stopRequestTimer();
                    clientTransaction.postConfirmation(applicationPdu);
                    clientTransaction.setState(0);
                    break;
                }
                case 7: {
                    clientTransaction.stopRequestTimer();
                    clientTransaction.postConfirmation(applicationPdu);
                    clientTransaction.setState(0);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new IllegalStateException("AwaitConfirmation.processNetworkIndication():" + applicationPdu.trace());
                }
            }
        }

        private static final void processRequestTimeout(ApplicationPdu applicationPdu, ClientTransaction clientTransaction) {
            int n = clientTransaction.getRetryCount();
            if (n < BBacnetNetwork.localDevice().getNumberOfApduRetries()) {
                clientTransaction.setRetryCount(++n);
                ClientStateMachine.sendConfirmedRequest(clientTransaction, (ConfirmedRequestPdu)applicationPdu);
            } else {
                clientTransaction.stopRequestTimer();
                clientTransaction.timeout();
                clientTransaction.setState(0);
            }
        }

        private AwaitConfirmation() {
        }
    }

    private static class SegmentedConf {
        public static final void process(ApplicationPdu applicationPdu, ClientTransaction clientTransaction) {
            switch (applicationPdu.getSource()) {
                case 0: {
                    SegmentedConf.processApplication(applicationPdu, clientTransaction);
                    break;
                }
                case 1: {
                    SegmentedConf.processNetworkIndication(applicationPdu, clientTransaction);
                    break;
                }
                case 3: {
                    SegmentedConf.processSegmentTimeout(applicationPdu, clientTransaction);
                    break;
                }
                default: {
                    throw new IllegalStateException("SegmentedConf.process():" + applicationPdu.trace());
                }
            }
        }

        private static final void processApplication(ApplicationPdu applicationPdu, ClientTransaction clientTransaction) {
            switch (applicationPdu.getType()) {
                case 7: {
                    clientTransaction.stopSegmentTimer();
                    ClientStateMachine.network().sendRequest(clientTransaction.getServerAddress(), applicationPdu);
                    clientTransaction.setState(0);
                    break;
                }
                default: {
                    throw new IllegalStateException("SegmentedConf.processApplication():" + applicationPdu.trace());
                }
            }
        }

        private static final void processNetworkIndication(ApplicationPdu applicationPdu, ClientTransaction clientTransaction) {
            switch (applicationPdu.getType()) {
                case 3: {
                    ComplexAckPdu complexAckPdu = (ComplexAckPdu)applicationPdu;
                    if (!complexAckPdu.isSegmentedMessage()) {
                        clientTransaction.stopSegmentTimer();
                        clientTransaction.timeout();
                        ClientStateMachine.sendAbort(applicationPdu, 2);
                        clientTransaction.setState(0);
                        return;
                    }
                    int n = clientTransaction.getLastSequenceNumber();
                    int n2 = complexAckPdu.getSequenceNumber();
                    int n3 = clientTransaction.getInitialSequenceNumber();
                    int n4 = clientTransaction.getActualWindowSize();
                    if (n2 != ClientStateMachine.modulo(n + 1, 256) && !ClientStateMachine.duplicateInWindow(n2, ClientStateMachine.modulo(n3 + 1, 256), n, n4)) {
                        ClientStateMachine.sendSegmentAck(clientTransaction, true, n);
                        clientTransaction.restartSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                        return;
                    }
                    if (complexAckPdu.getMoreFollows()) {
                        if (n2 != ClientStateMachine.modulo(n3 + n4, 256)) {
                            clientTransaction.getResponse().appendSegment(complexAckPdu);
                            clientTransaction.setLastSequenceNumber(ClientStateMachine.modulo(n + 1, 256));
                            clientTransaction.restartSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                            return;
                        }
                        clientTransaction.getResponse().appendSegment(complexAckPdu);
                        n = ClientStateMachine.modulo(n + 1, 256);
                        clientTransaction.setLastSequenceNumber(n);
                        clientTransaction.setInitialSequenceNumber(n);
                        ClientStateMachine.sendSegmentAck(clientTransaction, false, n2);
                        clientTransaction.restartSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                        return;
                    }
                    clientTransaction.getResponse().appendSegment(complexAckPdu);
                    clientTransaction.stopSegmentTimer();
                    ClientStateMachine.sendSegmentAck(clientTransaction, false, n2);
                    clientTransaction.postConfirmation(clientTransaction.getResponse());
                    clientTransaction.setState(0);
                    break;
                }
                case 7: {
                    clientTransaction.stopSegmentTimer();
                    clientTransaction.postConfirmation(applicationPdu);
                    clientTransaction.setState(0);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    clientTransaction.stopSegmentTimer();
                    clientTransaction.timeout();
                    ClientStateMachine.sendAbort(applicationPdu, 2);
                    clientTransaction.setState(0);
                    break;
                }
                default: {
                    throw new IllegalStateException("SegmentedConf.processNetworkIndication():" + applicationPdu.trace());
                }
            }
        }

        private static final void processSegmentTimeout(ApplicationPdu applicationPdu, ClientTransaction clientTransaction) {
            clientTransaction.stopSegmentTimer();
            clientTransaction.timeout();
            clientTransaction.setState(0);
        }

        private SegmentedConf() {
        }
    }
}

