/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.InvalidApduLengthException;
import com.tridium.bacnet.stack.transport.InvalidApduTypeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.enums.BBacnetAbortReason;

public class AbortPdu
extends ApplicationPdu {
    public static final int SERVER_BIT = 1;
    public static final int ABORT_PDU_LENGTH = 3;
    private int originalInvokeId;
    private int abortReason;
    private boolean server;

    public int originalInvokeId() {
        return this.originalInvokeId;
    }

    public int getAbortReason() {
        return this.abortReason;
    }

    public boolean isServerPDU() {
        return this.server;
    }

    public boolean isClientPDU() {
        return this.server ^ true;
    }

    public int getInvokeId() {
        return this.originalInvokeId;
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        int n = 112;
        if (this.server) {
            n |= 1;
        }
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(this.originalInvokeId);
        byteArrayOutputStream.write(this.abortReason);
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        int n = byteArrayInputStream.read();
        int n2 = (n & 0xF0) >> 4;
        if (n2 != 7) {
            throw new InvalidApduTypeException(7, n2);
        }
        if (byteArrayInputStream.available() != 2) {
            throw new InvalidApduLengthException(byteArrayInputStream.available(), 2);
        }
        if ((n & 1) != 0) {
            this.server = true;
        }
        this.originalInvokeId = byteArrayInputStream.read();
        this.abortReason = byteArrayInputStream.read();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AbortPdu:");
        stringBuffer.append("\n\tserver = " + this.server);
        stringBuffer.append("\n\toriginalInvokeId = " + this.originalInvokeId);
        stringBuffer.append("\n\tabort reason = " + BBacnetAbortReason.tag(this.abortReason));
        return stringBuffer.toString();
    }

    public AbortPdu(BBacnetAddress bBacnetAddress, BNetworkPriority bNetworkPriority, int n, int n2, boolean bl) {
        super(null, bBacnetAddress, bNetworkPriority, 7);
        this.originalInvokeId = n;
        this.abortReason = n2;
        this.server = bl;
    }

    public AbortPdu(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        super(7);
        this.readNetworkBytes(byteArrayInputStream);
    }
}

