/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BLocalDaemonPlatform;
import com.tridium.install.installable.DistributionManifest;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.log.Log;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RestoreBackup {
    public static final RestoreBackup INSTANCE = new RestoreBackup();
    public static final Log log = Log.getLog((String)"bacnet");
    private DateFormat format;
    static /* synthetic */ Class class$com$tridium$install$BDependency;

    public void restore(BIFile bIFile) throws Exception {
        this.restore(bIFile, false, true);
    }

    public void restore(BIFile bIFile, boolean bl, boolean bl2) throws Exception {
        log.message("Restoring from backup file " + bIFile.getFilePath().getBody());
        RestoreOp restoreOp = new RestoreOp(bIFile, bl, bl2);
        if (!restoreOp.ignoreDependencies) {
            this.verifyDependencies(restoreOp);
        }
        log.warning("Shutting down the station for file restore.  Please do not kill or reboot while the restore is in progress.");
        log.warning("The station will be restarted automatically once the restore completes.");
        new Thread(restoreOp).start();
    }

    /*
     * Exception decompiling
     */
    private final void doRestore(RestoreOp var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 112->116)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void verifyDependencies(RestoreOp restoreOp) throws Exception {
        log.message("Verifying backup file dependencies");
        BDependency[] bDependencyArray = restoreOp.manifest().getDependencies();
        Class clazz = class$com$tridium$install$BDependency;
        if (clazz == null) {
            clazz = class$com$tridium$install$BDependency = RestoreBackup.class("[Lcom.tridium.install.BDependency;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bDependencyArray.length) {
            if (!restoreOp.localPlatform().meets(bDependencyArray[n])) {
                array.add((Object)bDependencyArray[n]);
            }
            ++n;
        }
        if (array.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < array.size()) {
                stringBuffer.append(' ').append(array.get(n2).toString());
                ++n2;
            }
            throw new LocalizableRuntimeException("bacnet", "RestoreBackup.error.unmetDeps", new Object[]{stringBuffer});
        }
    }

    private final void restoreFiles(RestoreOp restoreOp) throws Exception {
        this.consoleMessage("Restoring files");
        boolean bl = false;
        Enumeration<? extends ZipEntry> enumeration = restoreOp.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.getName().toLowerCase().startsWith("meta-inf")) continue;
            try {
                BIFile bIFile = BFileSystem.INSTANCE.makeFile(this.getPathForEntry(zipEntry.getName(), restoreOp));
                this.consoleMessage("Copying " + bIFile.getFilePath().getBody());
                InputStream inputStream = restoreOp.zipFile.getInputStream(zipEntry);
                OutputStream outputStream = bIFile.getOutputStream();
                FileUtil.pipe((InputStream)inputStream, (OutputStream)outputStream);
                outputStream.close();
            }
            catch (Exception exception) {
                this.consoleError("File copy failed", exception);
                bl = true;
            }
        }
        if (bl) {
            this.consoleWarning("Restore completed with errors");
        } else {
            this.consoleMessage("Restore completed successfully");
        }
    }

    private final FilePath getPathForEntry(String string, RestoreOp restoreOp) throws Exception {
        if (restoreOp.manifest().useAbsoluteElementPaths()) {
            return new FilePath("/" + string);
        }
        return new FilePath("!" + string);
    }

    private final void restartStation(RestoreOp restoreOp) throws Exception {
        if (restoreOp.surrogate().isRestartEnabled()) {
            this.consoleMessage("Requesting station restart from niagarad");
            restoreOp.surrogate().restartStationAsync(true);
        } else {
            this.consoleMessage("Requesting reboot from niagarad");
            restoreOp.daemonPlatform().getDaemonSession().sendForceRebootRequest();
        }
    }

    protected void consoleError(String string) {
        this.consoleError(string, null);
    }

    protected void consoleError(String string, Exception exception) {
        this.consoleLog(3, string, exception);
    }

    protected void consoleWarning(String string) {
        this.consoleLog(2, string, null);
    }

    protected void consoleMessage(String string) {
        this.consoleLog(1, string, null);
    }

    protected void consoleLog(int n, String string, Exception exception) {
        switch (n) {
            case 3: {
                System.out.print("ERROR [");
                break;
            }
            case 2: {
                System.out.print("WARNING [");
                break;
            }
            case 1: {
                System.out.print("MESSAGE [");
                break;
            }
        }
        System.out.print(this.format.format(new Date()));
        System.out.print("][backup] ");
        System.out.println(string);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy z");
    }

    protected RestoreBackup() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RestoreOp
    implements Runnable {
        private DistributionManifest manifest;
        public ZipFile zipFile;
        public boolean ignoreDependencies;
        public boolean deleteFile;
        public BIFile backupFile;

        public void run() {
            RestoreBackup.this.doRestore(this);
        }

        public DistributionManifest manifest() throws Exception {
            if (this.manifest == null) {
                ZipEntry zipEntry = this.zipFile.getEntry("META-INF/dist.xml");
                if (zipEntry == null) {
                    zipEntry = this.zipFile.getEntry("meta-inf/dist.xml");
                }
                if (zipEntry == null) {
                    throw new LocalizableRuntimeException("bacnet", "RestoreBackup.error.noManifest");
                }
                this.manifest = DistributionManifest.make((InputStream)this.zipFile.getInputStream(zipEntry));
                if (!"backupdist".equals(this.manifest.getInstallableName())) {
                    throw new LocalizableRuntimeException("bacnet", "RestoreBackup.error.invalidName");
                }
            }
            return this.manifest;
        }

        public BDaemonPlatform localPlatform() throws Exception {
            return this.daemonPlatform();
        }

        public BDaemonPlatform daemonPlatform() throws Exception {
            BLocalDaemonPlatform bLocalDaemonPlatform = BLocalDaemonPlatform.getInstance();
            if (bLocalDaemonPlatform == null) {
                throw new LocalizableRuntimeException("bacnet", "RestoreBackup.error.noDaemonSession");
            }
            bLocalDaemonPlatform.checkSession();
            return bLocalDaemonPlatform;
        }

        public BStationSurrogate surrogate() throws Exception {
            return BStationSurrogate.make((BDaemonSession)this.daemonPlatform().getDaemonSession(), (String)Sys.getStation().getStationName());
        }

        private final /* synthetic */ void this() {
            this.manifest = null;
        }

        public RestoreOp(BIFile bIFile, boolean bl, boolean bl2) throws Exception {
            this.this();
            this.backupFile = bIFile;
            this.ignoreDependencies = bl;
            this.deleteFile = bl2;
            if (!(bIFile.getStore() instanceof BLocalFileStore)) {
                throw new LocalizableRuntimeException("bacnet", "RestoreBackup.error.backupNotLocal");
            }
            this.zipFile = new ZipFile(((BLocalFileStore)bIFile.getStore()).getLocalFile());
            this.manifest();
            this.daemonPlatform();
            if (this.surrogate() == null) {
                throw new LocalizableRuntimeException("bacnet", "RestoreBackup.error.noSurrogate");
            }
        }
    }
}

