/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.datatypes.BSvoSubordinate;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bacnet.stack.server.BIBacnetExportFolder;
import java.util.ArrayList;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetNodeType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetExportFolder
extends BFolder
implements BIAgent,
BIBacnetExportObject,
BIBacnetExportFolder {
    public static final Property status = BBacnetExportFolder.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBacnetExportFolder.newProperty((int)3, (String)"", null);
    public static final Property objectId = BBacnetExportFolder.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(29), null);
    public static final Property objectName = BBacnetExportFolder.newProperty((int)64, (String)"", null);
    public static final Property description = BBacnetExportFolder.newProperty((int)0, (String)"", null);
    public static final Property nodeType = BBacnetExportFolder.newProperty((int)0, (BValue)BBacnetNodeType.unknown, null);
    public static final Property nodeSubtype = BBacnetExportFolder.newProperty((int)0, (String)"", null);
    public static final Property subordinates = BBacnetExportFolder.newProperty((int)0, (BValue)new BBacnetArray(BSvoSubordinate.TYPE), null);
    public static final Topic subordinateAnnotationChanged = BBacnetExportFolder.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static AsnOutputStream asnOut;
    private static Log log;
    private static Lexicon lex;
    private static final int[] REQUIRED_PROPS;
    private static final int[] OPTIONAL_PROPS;
    private boolean fatalFault;
    private BBacnetObjectIdentifier oldId;
    private String oldName;
    private boolean duplicate;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$server$BBacnetExportFolder;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BIBacnetExportObject;
    static /* synthetic */ Class class$com$tridium$bacnet$datatypes$BSvoSubordinate;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public String getObjectName() {
        return this.getString(objectName);
    }

    public void setObjectName(String string) {
        this.setString(objectName, string, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public BBacnetNodeType getNodeType() {
        return (BBacnetNodeType)this.get(nodeType);
    }

    public void setNodeType(BBacnetNodeType bBacnetNodeType) {
        this.set(nodeType, (BValue)bBacnetNodeType, null);
    }

    public String getNodeSubtype() {
        return this.getString(nodeSubtype);
    }

    public void setNodeSubtype(String string) {
        this.setString(nodeSubtype, string, null);
    }

    public BBacnetArray getSubordinates() {
        return (BBacnetArray)this.get(subordinates);
    }

    public void setSubordinates(BBacnetArray bBacnetArray) {
        this.set(subordinates, (BValue)bBacnetArray, null);
    }

    public void fireSubordinateAnnotationChanged(BValue bValue) {
        this.fire(subordinateAnnotationChanged, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetExportTable getExports() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BBacnetExportTable) {
                return (BBacnetExportTable)bComplex;
            }
            bComplex = bComplex.getParent();
        }
        throw new IllegalStateException();
    }

    public final void started() throws Exception {
        super.started();
        this.checkFatalFault();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.checkConfiguration();
        if (Sys.isStationStarted() && this.getStatus().isOk()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        bLocalBacnetDevice.unexport(this.oldId, this.oldName, this);
        this.oldId = null;
        this.oldName = null;
        if (this.getStatus().isOk() && bLocalBacnetDevice.isRunning()) {
            bLocalBacnetDevice.incrementDatabaseRevision();
        }
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(BacnetConst.nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {
                duplicateSlotException.printStackTrace();
            }
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        }
    }

    public final BFacets getSlotFacets(Slot slot) {
        if (slot == objectId) {
            return BBacnetObjectType.getObjectIdFacets(29);
        }
        return super.getSlotFacets(slot);
    }

    public final BObject getObject() {
        return this;
    }

    public final BOrd getObjectOrd() {
        return this.getOrdInSession();
    }

    public final void setObjectOrd(BOrd bOrd, Context context) {
        throw new UnsupportedOperationException(lex.getText("UnsupportedOperationException.structuredView.setObjectOrd"));
    }

    public void checkConfiguration() {
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        boolean bl = true;
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            bl = false;
        }
        if (bl) {
            String string = bLocalBacnetDevice.export(this);
            if (string != null) {
                this.duplicate = true;
                this.setFaultCause(string);
                bl = false;
            } else {
                this.duplicate = false;
            }
        }
        if (bl) {
            this.setFaultCause("");
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)(bl ^ true)));
    }

    public final PropertyValue readProperty(PropertyReference propertyReference) throws RejectException {
        return this.readProperty(propertyReference.getPropertyId(), propertyReference.getPropertyArrayIndex());
    }

    public final PropertyValue[] readPropertyMultiple(PropertyReference[] propertyReferenceArray) throws RejectException {
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(propertyReferenceArray.length);
        int n = 0;
        while (n < propertyReferenceArray.length) {
            switch (propertyReferenceArray[n].getPropertyId()) {
                case 8: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    nArray = OPTIONAL_PROPS;
                    n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 80: {
                    int[] nArray = OPTIONAL_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 105: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                default: {
                    arrayList.add(this.readProperty(propertyReferenceArray[n].getPropertyId(), propertyReferenceArray[n].getPropertyArrayIndex()));
                }
            }
            ++n;
        }
        return arrayList.toArray(propertyValueArray);
    }

    public final RangeData readRange(RangeReference rangeReference) throws RejectException {
        return new ReadRangeAck(2, 45);
    }

    public final ErrorType writeProperty(PropertyValue propertyValue) throws BacnetException {
        return this.writeProperty(propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex(), propertyValue.getPropertyValue(), propertyValue.getPriority());
    }

    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n2]) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < OPTIONAL_PROPS.length) {
            if (n == OPTIONAL_PROPS[n2]) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        return new NChangeListError(8, new NErrorType(2, 32), 0L);
    }

    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n2]) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < OPTIONAL_PROPS.length) {
            if (n == OPTIONAL_PROPS[n2]) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        return new NChangeListError(9, new NErrorType(2, 32), 0L);
    }

    protected PropertyValue readProperty(int n, int n2) {
        if (n2 >= 0) {
            return new NReadPropertyResult(n, n2, new NErrorType(5, 7));
        }
        switch (n) {
            case 75: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 77: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 79: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 28: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
            case 208: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated((BEnum)this.getNodeType()));
            }
            case 207: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getNodeSubtype()));
            }
            case 211: {
                return this.readSubordinateList(n2);
            }
            case 210: {
                return this.readSubordinateAnnotations(n2);
            }
        }
        return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
    }

    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        if (n2 >= 0 && !this.isArray(n)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (n) {
                case 75: {
                    return new NErrorType(2, 40);
                }
                case 77: {
                    return BacUtil.setObjectName((BComponent)this, objectName, byArray);
                }
                case 79: {
                    return new NErrorType(2, 40);
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(byArray), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 208: {
                    return new NErrorType(2, 40);
                }
                case 207: {
                    return new NErrorType(2, 40);
                }
                case 211: {
                    return new NErrorType(2, 40);
                }
                case 210: {
                    return new NErrorType(2, 40);
                }
            }
            return new NErrorType(2, 32);
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    public String toString(Context context) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + ']';
    }

    boolean isArray(int n) {
        if (n == 210) {
            return true;
        }
        return n == 211;
    }

    public boolean addSubordinate(BSvoSubordinate bSvoSubordinate) {
        try {
            this.getSubordinates().addElement((BValue)bSvoSubordinate);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean modifySubordinate(int n, BSvoSubordinate bSvoSubordinate) {
        try {
            this.getSubordinates().setElement(n, (BValue)bSvoSubordinate);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean removeSubordinate(int n) {
        try {
            this.getSubordinates().removeElement(BInteger.make((int)n));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int countLocalSubordinates() {
        var1_1 = this.getProperties();
        var2_2 = 0;
        if (true) ** GOTO lbl6
        do {
            ++var2_2;
lbl6:
            // 2 sources

            if ((v0 = BBacnetExportFolder.class$javax$baja$bacnet$export$BIBacnetExportObject) != null) continue;
            v0 = BBacnetExportFolder.class("[Ljavax.baja.bacnet.export.BIBacnetExportObject;", false);
        } while (var1_1.next(v0));
        return var2_2;
    }

    public BIBacnetExportObject[] getLocalSubordinates() {
        Class clazz = class$javax$baja$bacnet$export$BIBacnetExportObject;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BIBacnetExportObject = BBacnetExportFolder.class("[Ljavax.baja.bacnet.export.BIBacnetExportObject;", false);
        }
        return (BIBacnetExportObject[])this.getChildren(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final NReadPropertyResult readSubordinateList(int var1_1) {
        block12: {
            if (var1_1 == 0) {
                var2_2 = this.countLocalSubordinates();
                return new NReadPropertyResult(211, var1_1, AsnUtil.toAsnUnsigned(var2_2 + this.getSubordinates().getSize()));
            }
            if (var1_1 != -1) break block12;
            var2_3 = BBacnetExportFolder.asnOut;
            synchronized (var2_3) {
                BBacnetExportFolder.asnOut.reset();
                var5_5 = this.getLocalSubordinates();
                var6_6 = 0;
                while (true) {
                    block13: {
                        if (var6_6 < var5_5.length) break block13;
                        v1 = this.getSubordinates();
                        v2 = BBacnetExportFolder.class$com$tridium$bacnet$datatypes$BSvoSubordinate;
                        if (v2 == null) {
                            v2 = BBacnetExportFolder.class$com$tridium$bacnet$datatypes$BSvoSubordinate = BBacnetExportFolder.class("[Lcom.tridium.bacnet.datatypes.BSvoSubordinate;", false);
                        }
                        var6_7 = (BSvoSubordinate[])v1.getChildren(v2);
                        var7_8 = 0;
                        if (true) ** GOTO lbl45
                    }
                    BBacnetExportFolder.asnOut.writeObjectIdentifier(1, var5_5[var6_6].getObjectId());
                    ++var6_6;
                }
            }
        }
        var2_4 = this.countLocalSubordinates();
        if (var1_1 < 0 || var1_1 > var2_4 + this.getSubordinates().getSize()) {
            return new NReadPropertyResult(211, var1_1, new NErrorType(2, 42));
        }
        if (var1_1 > var2_4) {
            return new NReadPropertyResult(211, var1_1, AsnUtil.toAsn((BValue)((BSvoSubordinate)this.getSubordinates().getElement(var1_1 - var2_4)).getReference()));
        }
        var3_9 = this.getLocalSubordinates();
        var4_10 = BBacnetExportFolder.asnOut;
        synchronized (var4_10) {
            BBacnetExportFolder.asnOut.reset();
            BBacnetExportFolder.asnOut.writeObjectIdentifier(1, var3_9[var1_1 - 1].getObjectId());
            return new NReadPropertyResult(211, var1_1, BBacnetExportFolder.asnOut.toByteArray());
        }
        {
            do {
                var6_7[var7_8].getReference().writeAsn(BBacnetExportFolder.asnOut);
                ++var7_8;
lbl45:
                // 2 sources

            } while (var7_8 < var6_7.length);
            return new NReadPropertyResult(211, var1_1, BBacnetExportFolder.asnOut.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final NReadPropertyResult readSubordinateAnnotations(int var1_1) {
        block12: {
            if (var1_1 == 0) {
                var2_2 = this.countLocalSubordinates();
                return new NReadPropertyResult(210, var1_1, AsnUtil.toAsnUnsigned(var2_2 + this.getSubordinates().getSize()));
            }
            if (var1_1 != -1) break block12;
            var2_3 = BBacnetExportFolder.asnOut;
            synchronized (var2_3) {
                BBacnetExportFolder.asnOut.reset();
                var5_5 = this.getLocalSubordinates();
                var6_6 = 0;
                while (true) {
                    block13: {
                        if (var6_6 < var5_5.length) break block13;
                        v1 = this.getSubordinates();
                        v2 = BBacnetExportFolder.class$com$tridium$bacnet$datatypes$BSvoSubordinate;
                        if (v2 == null) {
                            v2 = BBacnetExportFolder.class$com$tridium$bacnet$datatypes$BSvoSubordinate = BBacnetExportFolder.class("[Lcom.tridium.bacnet.datatypes.BSvoSubordinate;", false);
                        }
                        var6_7 = (BSvoSubordinate[])v1.getChildren(v2);
                        var7_8 = 0;
                        if (true) ** GOTO lbl45
                    }
                    BBacnetExportFolder.asnOut.writeCharacterString((BString)((BComplex)var5_5[var6_6]).get("description"));
                    ++var6_6;
                }
            }
        }
        var2_4 = this.countLocalSubordinates();
        if (var1_1 < 0 || var1_1 > var2_4 + this.getSubordinates().getSize()) {
            return new NReadPropertyResult(210, var1_1, new NErrorType(2, 42));
        }
        if (var1_1 > var2_4) {
            return new NReadPropertyResult(210, var1_1, AsnUtil.toAsnCharacterString(((BSvoSubordinate)this.getSubordinates().getElement(var1_1 - var2_4)).getAnnotation()));
        }
        var3_9 = this.getLocalSubordinates();
        var4_10 = BBacnetExportFolder.asnOut;
        synchronized (var4_10) {
            BBacnetExportFolder.asnOut.reset();
            BBacnetExportFolder.asnOut.writeCharacterString((BString)((BComplex)var3_9[var1_1 - 1]).get("description"));
            return new NReadPropertyResult(210, var1_1, BBacnetExportFolder.asnOut.toByteArray());
        }
        {
            do {
                BBacnetExportFolder.asnOut.writeCharacterString(var6_7[var7_8].getAnnotation());
                ++var7_8;
lbl45:
                // 2 sources

            } while (var7_8 < var6_7.length);
            return new NReadPropertyResult(210, var1_1, BBacnetExportFolder.asnOut.toByteArray());
        }
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private final void checkFatalFault() {
        BBacnetExportTable bBacnetExportTable = null;
        BLocalBacnetDevice bLocalBacnetDevice = null;
        BBacnetNetwork bBacnetNetwork = null;
        if (this.fatalFault) {
            return;
        }
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BBacnetExportTable) {
                bBacnetExportTable = (BBacnetExportTable)bComplex;
            } else if (bComplex instanceof BLocalBacnetDevice) {
                bLocalBacnetDevice = (BLocalBacnetDevice)bComplex;
                break;
            }
            bComplex = bComplex.getParent();
        }
        if (bBacnetExportTable == null || bLocalBacnetDevice == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under LocalBacnetDevice Export Table");
            return;
        }
        if (bLocalBacnetDevice.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("LocalDevice fault: " + bLocalBacnetDevice.getFaultCause());
            return;
        }
        bBacnetNetwork = (BBacnetNetwork)bLocalBacnetDevice.getParent();
        if (bBacnetNetwork == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under BacnetNetwork");
            return;
        }
        if (bBacnetNetwork.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + bBacnetNetwork.getFaultCause());
            return;
        }
        Feature feature = bBacnetNetwork.getLicenseFeature();
        boolean bl = feature.getb("export", false);
        if (!bl) {
            this.fatalFault = true;
            this.setFaultCause("Server capability not licensed");
            return;
        }
        this.setFaultCause("");
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetStructuredViewDescriptor", 2);
        spyWriter.prop((Object)"fatalFault", this.fatalFault);
        spyWriter.prop((Object)"oldId", (Object)this.oldId);
        spyWriter.prop((Object)"oldName", (Object)this.oldName);
        spyWriter.prop((Object)"duplicate", this.duplicate);
        spyWriter.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.toTop("bacnet:BacnetExportManager");
        return agentList;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.fatalFault = false;
        this.oldId = null;
        this.oldName = null;
        this.duplicate = false;
    }

    public BBacnetExportFolder() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$server$BBacnetExportFolder;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$server$BBacnetExportFolder = BBacnetExportFolder.class("[Lcom.tridium.bacnet.stack.server.BBacnetExportFolder;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"folder.png"), (BIcon)BIcon.std((String)"badges/export.png"));
        asnOut = new AsnOutputStream();
        log = Log.getLog((String)"bacnet.server");
        lex = Lexicon.make((String)"bacnet");
        REQUIRED_PROPS = new int[]{75, 77, 79, 208, 211};
        OPTIONAL_PROPS = new int[]{28, 207, 210};
    }
}

