/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network.messages;

import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.InvalidNetworkMsgException;
import com.tridium.bacnet.stack.network.messages.NetworkLayerMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class RouterBusyToNetwork
extends NetworkLayerMsg {
    private int[] networkNumbers;

    public boolean isAllNetworks() {
        boolean bl = false;
        if (this.networkNumbers == null || this.networkNumbers.length == 0) {
            bl = true;
        }
        return bl;
    }

    public int[] getNetworkNumbers() {
        return this.networkNumbers;
    }

    public String getMsgString() {
        StringBuffer stringBuffer = new StringBuffer("RouterBusyToNetwork; networks=");
        if (this.networkNumbers == null || this.networkNumbers.length == 0) {
            stringBuffer.append("none ");
        } else {
            int n = 0;
            while (n < this.networkNumbers.length) {
                stringBuffer.append(String.valueOf(this.networkNumbers[n])).append(',');
                ++n;
            }
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        if (byteArrayInputStream.available() % 2 != 0) {
            throw new InvalidNetworkMsgException();
        }
        this.networkNumbers = new int[byteArrayInputStream.available() / 2];
        int n = 0;
        while (n < this.networkNumbers.length) {
            this.networkNumbers[n] = byteArrayInputStream.read() << 8;
            int n2 = n++;
            this.networkNumbers[n2] = this.networkNumbers[n2] | byteArrayInputStream.read();
        }
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        super.writeNetworkBytes(byteArrayOutputStream);
        int n = 0;
        while (n < this.networkNumbers.length) {
            byteArrayOutputStream.write(this.networkNumbers[n] >> 8);
            byteArrayOutputStream.write(this.networkNumbers[n]);
            ++n;
        }
    }

    public RouterBusyToNetwork(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        super(4);
        this.readNetworkBytes(byteArrayInputStream);
    }

    public RouterBusyToNetwork() {
        super(4);
        this.networkNumbers = new int[0];
    }

    public RouterBusyToNetwork(int n) {
        super(4);
        this.networkNumbers = new int[]{n};
    }

    public RouterBusyToNetwork(int[] nArray) {
        super(4);
        this.networkNumbers = nArray;
    }
}

