/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network.messages;

import com.tridium.bacnet.stack.BacnetInputStream;
import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.NetworkPdu;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class NetworkLayerMsg
extends NetworkPdu {
    private int messageType;
    private int vendorId;
    private byte[] msgData;

    public boolean isNetworkLayerMsg() {
        return true;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public String getMsgString() {
        return "msgType=" + this.messageType + ", vID=" + this.vendorId;
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        this.msgData = new byte[byteArrayInputStream.available()];
        try {
            byteArrayInputStream.read(this.msgData);
        }
        catch (IOException iOException) {
            System.out.println("IOException parsing proprietary network layer message!");
            throw new BacnetStackException("Unsupported Network Layer Message");
        }
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        super.writeNetworkBytes(byteArrayOutputStream);
        byteArrayOutputStream.write(this.messageType);
        if ((this.messageType & 0x80) != 0) {
            byteArrayOutputStream.write(this.vendorId);
            byteArrayOutputStream.write(this.msgData, 0, this.msgData.length);
        }
    }

    protected NetworkLayerMsg(int n) {
        this.messageType = n;
        this.vendorId = 0;
    }

    public NetworkLayerMsg(int n, BacnetInputStream bacnetInputStream) throws BacnetStackException {
        this.messageType = n;
        this.vendorId = 0;
        this.readNetworkBytes(bacnetInputStream);
    }

    public NetworkLayerMsg(int n, int n2, BacnetInputStream bacnetInputStream) throws BacnetStackException {
        this.messageType = n;
        this.vendorId = n2;
        this.readNetworkBytes(bacnetInputStream);
    }
}

