/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network.messages;

import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.InvalidNetworkMsgException;
import com.tridium.bacnet.stack.network.messages.NetworkLayerMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class ICouldBeRouterToNetwork
extends NetworkLayerMsg {
    private int networkNumber;
    private int performanceIndex;

    public int getNetworkNumber() {
        return this.networkNumber;
    }

    public int getPerformanceIndex() {
        return this.performanceIndex;
    }

    public String getMsgString() {
        return "ICouldBeRouterToNetwork; network=" + this.networkNumber + ", perfNdx=" + this.performanceIndex;
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        if (byteArrayInputStream.available() < 3) {
            throw new InvalidNetworkMsgException();
        }
        this.networkNumber = byteArrayInputStream.read() << 8;
        this.networkNumber |= byteArrayInputStream.read();
        this.performanceIndex = byteArrayInputStream.read();
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        super.writeNetworkBytes(byteArrayOutputStream);
        byteArrayOutputStream.write(this.networkNumber >> 8 & 0xFF);
        byteArrayOutputStream.write(this.networkNumber & 0xFF);
        byteArrayOutputStream.write(this.performanceIndex);
    }

    public ICouldBeRouterToNetwork(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        super(2);
        this.readNetworkBytes(byteArrayInputStream);
    }

    public ICouldBeRouterToNetwork(int n, int n2) {
        super(2);
        this.networkNumber = n;
        this.performanceIndex = n2;
    }
}

