/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network.messages;

import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.InvalidNetworkMsgException;
import com.tridium.bacnet.stack.network.messages.NetworkLayerMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class DisconnectConnectionToNetwork
extends NetworkLayerMsg {
    private int networkNumber;

    public int getNetworkNumber() {
        return this.networkNumber;
    }

    public String getMsgString() {
        return "DisconnectConnectionToNetwork; network=" + this.networkNumber;
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        if (byteArrayInputStream.available() != 2) {
            throw new InvalidNetworkMsgException();
        }
        this.networkNumber = byteArrayInputStream.read() << 8;
        this.networkNumber |= byteArrayInputStream.read();
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        super.writeNetworkBytes(byteArrayOutputStream);
        byteArrayOutputStream.write(this.networkNumber >> 8 & 0xFF);
        byteArrayOutputStream.write(this.networkNumber & 0xFF);
    }

    public DisconnectConnectionToNetwork(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        super(9);
        this.readNetworkBytes(byteArrayInputStream);
    }

    public DisconnectConnectionToNetwork(int n) {
        super(9);
        this.networkNumber = n;
    }
}

