/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network;

import com.tridium.bacnet.stack.BBacnetMultiPoll;
import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.BacnetInputStream;
import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.link.BLinkLayerChoice;
import com.tridium.bacnet.stack.link.LinkListener;
import com.tridium.bacnet.stack.link.ethernet.BBacnetEthernetLinkLayer;
import com.tridium.bacnet.stack.link.ip.BBacnetIpLinkLayer;
import com.tridium.bacnet.stack.link.mstp.BBacnetMstpLinkLayer;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BRouterStatus;
import com.tridium.bacnet.stack.network.NetworkPdu;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.QueueFullException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNetworkPort
extends BComponent
implements LinkListener,
BacnetConst {
    public static final Property networkNumber = BNetworkPort.newProperty((int)0, (int)-1, null);
    public static final Property link = BNetworkPort.newProperty((int)0, (BValue)new BBacnetEthernetLinkLayer(), null);
    public static final Property status = BNetworkPort.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property faultCause = BNetworkPort.newProperty((int)3, (String)"", null);
    public static final Property multiPoll = BNetworkPort.newProperty((int)4, (boolean)true, null);
    public static final Property pollService = BNetworkPort.newProperty((int)0, (BValue)new BBacnetMultiPoll(), null);
    public static final Property maxDevices = BNetworkPort.newProperty((int)1, (int)Integer.MAX_VALUE, null);
    public static final Property enabled = BNetworkPort.newProperty((int)65, (boolean)false, null);
    public static final Property portId = BNetworkPort.newProperty((int)65, (int)-1, null);
    public static final Property portInfo = BNetworkPort.newProperty((int)1, (String)"", null);
    public static final Action enable = BNetworkPort.newAction((int)0, null);
    public static final Action disable = BNetworkPort.newAction((int)0, null);
    public static final Type TYPE;
    protected static final Log log;
    private static int portIds;
    private boolean fatalFault;
    private boolean fault;
    private boolean ready;
    private int oldDnet;
    private int oldStatus;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$network$BNetworkPort;

    public int getNetworkNumber() {
        return this.getInt(networkNumber);
    }

    public void setNetworkNumber(int n) {
        this.setInt(networkNumber, n, null);
    }

    public BBacnetLinkLayer getLink() {
        return (BBacnetLinkLayer)this.get(link);
    }

    public void setLink(BBacnetLinkLayer bBacnetLinkLayer) {
        this.set(link, (BValue)bBacnetLinkLayer, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public boolean getMultiPoll() {
        return this.getBoolean(multiPoll);
    }

    public void setMultiPoll(boolean bl) {
        this.setBoolean(multiPoll, bl, null);
    }

    public BBacnetPoll getPollService() {
        return (BBacnetPoll)this.get(pollService);
    }

    public void setPollService(BBacnetPoll bBacnetPoll) {
        this.set(pollService, (BValue)bBacnetPoll, null);
    }

    public int getMaxDevices() {
        return this.getInt(maxDevices);
    }

    public void setMaxDevices(int n) {
        this.setInt(maxDevices, n, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public int getPortId() {
        return this.getInt(portId);
    }

    public void setPortId(int n) {
        this.setInt(portId, n, null);
    }

    public String getPortInfo() {
        return this.getString(portInfo);
    }

    public void setPortInfo(String string) {
        this.setString(portInfo, string, null);
    }

    public void enable() {
        this.invoke(enable, null, null);
    }

    public void disable() {
        this.invoke(disable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BNetworkPort make(int n, BLinkLayerChoice bLinkLayerChoice) {
        BNetworkPort bNetworkPort = new BNetworkPort();
        bNetworkPort.setNetworkNumber(n);
        switch (bLinkLayerChoice.getOrdinal()) {
            case 0: {
                bNetworkPort.setLink(new BBacnetIpLinkLayer());
                bNetworkPort.setPortInfo("Annex J IP");
                return bNetworkPort;
            }
            case 1: {
                bNetworkPort.setLink(new BBacnetEthernetLinkLayer());
                bNetworkPort.setPortInfo("Ethernet");
                return bNetworkPort;
            }
            case 3: {
                bNetworkPort.setLink(new BBacnetMstpLinkLayer());
                bNetworkPort.setPortInfo("MS/TP");
                return bNetworkPort;
            }
        }
        throw new IllegalArgumentException("Unsupported Link Layer Choice!");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doEnable() {
        if (!this.isRunning()) {
            return;
        }
        if (this.fatalFault) {
            return;
        }
        try {
            try {
                this.getLink().linkInit();
                this.getLink().addLinkListener(this);
                this.getLink().linkStart();
                this.network().updateRouterAddress(this.getNetworkNumber(), this.getNetworkNumber(), this.getLink().getMacAddress(), BRouterStatus.ok, this.getPortInfo());
                this.getPollService().pollStart();
                this.network().issueIAmRouterToNetworks();
                BBacnetNetwork.localDevice().sendIAm();
                this.setEnabled(true);
                this.ok();
            }
            catch (BajaRuntimeException bajaRuntimeException) {
                Throwable throwable = bajaRuntimeException.getCause();
                log.warning("Exception enabling BACnet network port: " + this + ':' + throwable, throwable);
                this.fault(throwable.toString());
            }
            catch (Exception exception) {
                log.warning("Cannot enable BACnet network port: " + this + ':' + exception, (Throwable)exception);
                this.fault(exception.toString());
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.updateStatus();
            throw throwable;
        }
        {
            Object var2_6 = null;
            this.updateStatus();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDisable() {
        if (!this.isRunning()) {
            return;
        }
        try {
            try {
                this.setEnabled(false);
                this.getPollService().pollStop();
                this.network().getRouterTable().removeRouterByPortId(this.getPortId());
                this.getLink().removeLinkListener(this);
                this.getLink().linkStop();
                this.getLink().linkCleanup();
            }
            catch (Exception exception) {
                log.warning("Exception disabling BACnet network port: " + this + ':' + exception);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.updateStatus();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.updateStatus();
            return;
        }
    }

    public void started() throws Exception {
        super.started();
        this.checkFatalFault();
        Type type = this.getPollService().getType();
        if (this.getMultiPoll() || this.getLink().getType().is(BBacnetMstpLinkLayer.TYPE)) {
            if (!type.is(BBacnetMultiPoll.TYPE)) {
                this.setPollService(new BBacnetMultiPoll());
            }
        } else if (type.is(BBacnetMultiPoll.TYPE)) {
            this.setPollService(new BBacnetPoll());
        }
        this.setPortId(portIds++);
        this.oldDnet = this.getNetworkNumber();
        if (Sys.atSteadyState()) {
            this.ready = true;
        }
        if (!this.fatalFault && this.getEnabled()) {
            this.getLink().linkInit();
        }
    }

    public void stopped() {
        this.stackStopped();
    }

    public void stackStopped() {
        try {
            if (this.getEnabled()) {
                this.getPollService().pollStop();
                this.network().getRouterTable().removeRouterByPortId(this.getPortId());
                this.getLink().removeLinkListener(this);
                this.getLink().linkStop();
                this.getLink().linkCleanup();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)networkNumber)) {
            if (this.getNetworkNumber() == 0) {
                this.fault("Invalid network number:" + this.getNetworkNumber());
            } else if (this.network().getPortByNetwork(this.getNetworkNumber()) != this) {
                log.error("Duplicate network number! Resetting to old DNET " + this.oldDnet + "...");
                this.setInt(networkNumber, this.oldDnet, BacnetConst.fallback);
            } else {
                this.network().getRouterTable().removeRouterByDnet(this.oldDnet);
                if (this.getEnabled() && this.getNetworkNumber() > 0) {
                    this.network().updateRouterAddress(this.getNetworkNumber(), this.getNetworkNumber(), this.getLink().getMacAddress(), BRouterStatus.ok, this.getPortInfo());
                }
                this.oldDnet = this.getNetworkNumber();
                this.ok();
            }
        }
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetNetworkLayer;
    }

    public void sendToLink(byte[] byArray, NetworkPdu networkPdu) {
        if (this.ready && this.getStatus().isValid()) {
            this.getLink().sendRequest(byArray, networkPdu);
        }
    }

    public void rcvIndication(byte[] byArray, byte[] byArray2, BacnetInputStream bacnetInputStream) {
        try {
            NetworkPdu networkPdu = NetworkPdu.parseNetworkBytes(byArray, byArray2, this.getNetworkNumber(), bacnetInputStream);
            if (networkPdu != null && this.ready && this.getStatus().isValid()) {
                networkPdu.setSourcePort(this);
                if (log.isTraceOn()) {
                    log.trace(networkPdu.toString());
                }
                this.network().receiveNpdu(networkPdu);
            }
        }
        catch (BacnetStackException bacnetStackException) {
            log.error("Unable to parse Bacnet Npdu!", (Throwable)((Object)bacnetStackException));
            bacnetInputStream.release();
        }
        catch (QueueFullException queueFullException) {
            log.error("Network layer message queue overflow!", (Throwable)queueFullException);
            bacnetInputStream.release();
        }
    }

    public BBacnetAddress getAddress() {
        return new BBacnetAddress(this.getNetworkNumber(), this.getLink().getMacAddress());
    }

    void networkReady() {
        this.ready = true;
        try {
            if (!this.fatalFault && this.getEnabled()) {
                this.getLink().addLinkListener(this);
                this.getLink().linkStart();
                this.network().updateRouterAddress(this.getNetworkNumber(), this.getNetworkNumber(), this.getLink().getMacAddress(), BRouterStatus.ok, this.getPortInfo());
            }
        }
        catch (Exception exception) {
            this.fault(exception.toString());
        }
        this.updateStatus();
        if (this.getEnabled()) {
            this.getPollService().pollStart();
        }
    }

    private final BBacnetNetworkLayer network() {
        return (BBacnetNetworkLayer)this.getParent();
    }

    public String toString(Context context) {
        return "NetworkPort: id=" + this.getPortId() + " net=" + this.getNetworkNumber() + (this.getEnabled() ? " enabled" : " disabled") + " max=" + this.getMaxDevices() + " link=" + (Object)((Object)this.getLink());
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"NetworkPort", 2);
        spyWriter.prop((Object)"portIds (static)", portIds);
        spyWriter.prop((Object)"ready", this.ready);
        spyWriter.prop((Object)"oldDnet", this.oldDnet);
        spyWriter.prop((Object)"fatalFault", this.fatalFault);
        spyWriter.prop((Object)"oldStatus", this.oldStatus);
        spyWriter.endProps();
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    public final void fault(String string) {
        this.fault = true;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause(string);
        this.updateStatus();
    }

    public final void ok() {
        this.fault = false;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause("");
        this.updateStatus();
    }

    public final void fatalFault(String string) {
        this.fatalFault = true;
        this.setFaultCause(string);
        this.updateStatus();
    }

    public void updateStatus() {
        int n = this.getStatus().getBits();
        n = !this.getEnabled() ? (n |= 1) : (n &= 0xFFFFFFFE);
        n = this.fatalFault || this.fault ? (n |= 2) : (n &= 0xFFFFFFFD);
        if (n == this.oldStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        this.oldStatus = n;
    }

    private final void checkFatalFault() {
        this.getLink().checkFatalFault();
    }

    static void d(String string) {
        System.out.println(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.fatalFault = false;
        this.fault = false;
        this.ready = false;
        this.oldDnet = -1;
        this.oldStatus = 0;
    }

    public BNetworkPort() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$network$BNetworkPort;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$network$BNetworkPort = BNetworkPort.class("[Lcom.tridium.bacnet.stack.network.BNetworkPort;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.network");
        portIds = 1;
    }
}

