/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network;

import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.network.BRouterStatus;
import com.tridium.bacnet.timers.Timers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetRouterEntry
extends BStruct {
    public static final Property dnet = BBacnetRouterEntry.newProperty((int)0, (int)-1, null);
    public static final Property routerAddress = BBacnetRouterEntry.newProperty((int)0, (BValue)BBacnetAddress.DEFAULT, null);
    public static final Property portId = BBacnetRouterEntry.newProperty((int)1, (int)-1, null);
    public static final Property portInfo = BBacnetRouterEntry.newProperty((int)1, (String)"", null);
    public static final Property routerStatus = BBacnetRouterEntry.newProperty((int)1, (BValue)BRouterStatus.unknown, null);
    public static final Type TYPE;
    public static final int BUSY_TIMEOUT = 30000;
    private int busyTimerId;
    long lastUpdateTicks;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$network$BBacnetRouterEntry;

    public int getDnet() {
        return this.getInt(dnet);
    }

    public void setDnet(int n) {
        this.setInt(dnet, n, null);
    }

    public BBacnetAddress getRouterAddress() {
        return (BBacnetAddress)this.get(routerAddress);
    }

    public void setRouterAddress(BBacnetAddress bBacnetAddress) {
        this.set(routerAddress, (BValue)bBacnetAddress, null);
    }

    public int getPortId() {
        return this.getInt(portId);
    }

    public void setPortId(int n) {
        this.setInt(portId, n, null);
    }

    public String getPortInfo() {
        return this.getString(portInfo);
    }

    public void setPortInfo(String string) {
        this.setString(portInfo, string, null);
    }

    public BRouterStatus getRouterStatus() {
        return (BRouterStatus)this.get(routerStatus);
    }

    public void setRouterStatus(BRouterStatus bRouterStatus) {
        this.set(routerStatus, (BValue)bRouterStatus, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context context) {
        return "" + this.getPortId() + ':' + this.getRouterAddress() + "->" + this.getDnet() + '-' + (Object)((Object)this.getRouterStatus());
    }

    public boolean isDisconnected() {
        boolean bl = false;
        if (this.getRouterStatus() == BRouterStatus.routerNotConnected) {
            bl = true;
        }
        return bl;
    }

    public boolean isUnavailable() {
        boolean bl = false;
        if (this.getRouterStatus() == BRouterStatus.routerUnavailable) {
            bl = true;
        }
        return bl;
    }

    public boolean isBusy() {
        boolean bl = false;
        if (this.getRouterStatus() == BRouterStatus.routerBusy) {
            bl = true;
        }
        return bl;
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws IOException {
        int n = byteArrayInputStream.read() << 8;
        this.setDnet(n |= byteArrayInputStream.read());
        this.setPortId(byteArrayInputStream.read());
        int n2 = byteArrayInputStream.read();
        byte[] byArray = new byte[n2];
        byteArrayInputStream.read(byArray);
        this.setPortInfo(new String(byArray));
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        int n = this.getDnet();
        byteArrayOutputStream.write(n >> 8);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(this.getPortId());
        byte[] byArray = this.getPortInfo().getBytes();
        if (byArray == null) {
            byteArrayOutputStream.write(0);
        } else {
            byteArrayOutputStream.write(byArray.length);
        }
        byteArrayOutputStream.write(byArray, 0, byArray.length);
    }

    public void startBusyTimer() {
        Timers.cancel(this.busyTimerId);
        this.busyTimerId = Timers.add(((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getNetwork(), 30000L, (Object)this);
    }

    public void stopBusyTimer() {
        Timers.cancel(this.busyTimerId);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastUpdateTicks = 0L;
    }

    public BBacnetRouterEntry() {
        this.this();
        this.lastUpdateTicks = Clock.ticks();
    }

    public BBacnetRouterEntry(int n, BBacnetAddress bBacnetAddress, int n2, String string, BRouterStatus bRouterStatus) {
        this.this();
        this.lastUpdateTicks = Clock.ticks();
        this.setDnet(n);
        this.setRouterAddress(bBacnetAddress);
        this.setPortId(n2);
        this.setPortInfo(string == null ? "" : string);
        this.setRouterStatus(bRouterStatus);
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$network$BBacnetRouterEntry;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$network$BBacnetRouterEntry = BBacnetRouterEntry.class("[Lcom.tridium.bacnet.stack.network.BBacnetRouterEntry;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

