/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.mstp;

import com.tridium.bacnet.enums.BBacnetMstpBaudRate;
import com.tridium.bacnet.stack.BacnetInputStream;
import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.network.NetworkPdu;
import com.tridium.platMstp.BBacnetMstpPlatformService;
import com.tridium.platMstp.MstpListener;
import java.io.ByteArrayOutputStream;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.serial.BISerialService;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetMstpLinkLayer
extends BBacnetLinkLayer
implements MstpListener {
    public static final Property portName = BBacnetMstpLinkLayer.newProperty((int)64, (String)new String("COM1"), null);
    public static final Property mstpTrunk = BBacnetMstpLinkLayer.newProperty((int)5, (int)0, null);
    public static final Property baudRate = BBacnetMstpLinkLayer.newProperty((int)0, (BValue)BBacnetMstpBaudRate.baud_9600, null);
    public static final Property mstpAddress = BBacnetMstpLinkLayer.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)127));
    public static final Property maxMaster = BBacnetMstpLinkLayer.newProperty((int)0, (int)127, (BFacets)BFacets.makeInt((int)0, (int)127));
    public static final Property maxInfoFrames = BBacnetMstpLinkLayer.newProperty((int)0, (int)20, (BFacets)BFacets.makeInt((int)1, (int)100));
    public static final Property supportExtendedFrames = BBacnetMstpLinkLayer.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE;
    private static boolean licenseChecked;
    protected static int[] trunks;
    public static final int MAX_NPDU_LENGTH = 501;
    public static final int DEFAULT_MAX_APDU_LENGTH_ACCEPTED = 480;
    public static final int MAX_EXT_NPDU_LENGTH = 1497;
    public static final int DEFAULT_MAX_EXT_APDU_LENGTH_ACCEPTED = 1476;
    public static final byte MSTP_BROADCAST_MAC_ADDRESS = -1;
    public static final String MSTP_TRUNK_PREFIX = "/dev/mstp";
    private ByteArrayOutputStream os;
    private Log log;
    protected int handle;
    protected boolean commStarted;
    protected BComponent portComp;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$link$mstp$BBacnetMstpLinkLayer;

    public String getPortName() {
        return this.getString(portName);
    }

    public void setPortName(String string) {
        this.setString(portName, string, null);
    }

    public int getMstpTrunk() {
        return this.getInt(mstpTrunk);
    }

    public void setMstpTrunk(int n) {
        this.setInt(mstpTrunk, n, null);
    }

    public BBacnetMstpBaudRate getBaudRate() {
        return (BBacnetMstpBaudRate)this.get(baudRate);
    }

    public void setBaudRate(BBacnetMstpBaudRate bBacnetMstpBaudRate) {
        this.set(baudRate, (BValue)bBacnetMstpBaudRate, null);
    }

    public int getMstpAddress() {
        return this.getInt(mstpAddress);
    }

    public void setMstpAddress(int n) {
        this.setInt(mstpAddress, n, null);
    }

    public int getMaxMaster() {
        return this.getInt(maxMaster);
    }

    public void setMaxMaster(int n) {
        this.setInt(maxMaster, n, null);
    }

    public int getMaxInfoFrames() {
        return this.getInt(maxInfoFrames);
    }

    public void setMaxInfoFrames(int n) {
        this.setInt(maxInfoFrames, n, null);
    }

    public boolean getSupportExtendedFrames() {
        return this.getBoolean(supportExtendedFrames);
    }

    public void setSupportExtendedFrames(boolean bl) {
        this.setBoolean(supportExtendedFrames, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    private final void checkLicense() {
        try {
            if (!licenseChecked) {
                Feature feature = Sys.getLicenseManager().getFeature("tridium", "mstp");
                if (feature == null) {
                    throw new FeatureNotLicensedException("MSTP not licensed");
                }
                feature.check();
                int n = feature.geti("port.limit", 0);
                trunks = new int[n];
                licenseChecked = true;
            }
        }
        catch (Exception exception) {
            this.getNetworkPort().fault("BACnet MSTP not licensed");
        }
    }

    private final int nextOpenTrunk() {
        if (trunks == null) {
            return 0;
        }
        int n = 0;
        while (n < trunks.length) {
            if (trunks[n] == 0) {
                BBacnetMstpLinkLayer.trunks[n] = n + 1;
                return n + 1;
            }
            ++n;
        }
        this.getNetworkPort().fault("Exceeded mstp port.limit");
        return 0;
    }

    public void checkFatalFault() {
        try {
            this.checkLicense();
            this.setMstpTrunk(this.nextOpenTrunk());
        }
        catch (Exception exception) {
            this.getNetworkPort().fault(exception.toString());
        }
    }

    public void started() throws Exception {
        super.started();
        this.log = Log.getLog((String)("bacnet.link.mstp" + this.getMstpTrunk()));
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.getMstpTrunk() > 0 && trunks != null) {
            BBacnetMstpLinkLayer.trunks[this.getMstpTrunk() - 1] = 0;
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)portName)) {
            try {
                if (this.getNetworkPort().getEnabled()) {
                    this.linkCommStop();
                    this.linkCommStart();
                }
            }
            catch (Exception exception) {
                this.log.warning("Exception changing BACnet MS/TP port name:" + exception);
                this.getNetworkPort().fault(exception.toString());
            }
        } else if (property.equals((Object)mstpTrunk)) {
            try {
                this.log = Log.getLog((String)("bacnet.link.mstp" + this.getMstpTrunk()));
                if (this.getNetworkPort().getEnabled()) {
                    this.linkCommStop();
                    this.linkCommStart();
                }
            }
            catch (Exception exception) {
                this.log.warning("Exception changing BACnet MS/TP trunk:" + exception);
                this.getNetworkPort().fault(exception.toString());
            }
        } else if (property.equals((Object)baudRate)) {
            if (this.commStarted) {
                this.getPlatformService().setBaudRate(this.handle, this.getBaudRate().getOrdinal());
            }
        } else if (property.equals((Object)mstpAddress)) {
            if (this.commStarted) {
                this.getPlatformService().setAddress(this.handle, this.getMstpAddress());
            }
        } else if (property.equals((Object)maxMaster)) {
            if (this.commStarted) {
                this.getPlatformService().setMaxMaster(this.handle, this.getMaxMaster());
            }
        } else if (property.equals((Object)maxInfoFrames)) {
            if (this.commStarted) {
                this.getPlatformService().setMaxInfoFrames(this.handle, this.getMaxInfoFrames());
            }
        } else if (property.equals((Object)supportExtendedFrames) && this.commStarted) {
            BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
            bLocalBacnetDevice.setMaxAPDULengthAccepted(this.getMaxAPDULengthAccepted());
        }
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MAC ").append(this.getMstpAddress()).append(" on ").append(this.getPortName()).append(" at " + (Object)((Object)this.getBaudRate()));
        return stringBuffer.toString();
    }

    public BBacnetMstpPlatformService getPlatformService() {
        try {
            BBacnetMstpPlatformService bBacnetMstpPlatformService = (BBacnetMstpPlatformService)Sys.getService((Type)BBacnetMstpPlatformService.TYPE);
            bBacnetMstpPlatformService.checkPropertiesLoaded();
            return bBacnetMstpPlatformService;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public final void linkCommStart() throws Exception {
        if (this.getMstpTrunk() == 0) {
            return;
        }
        this.getPlatformService().loadPlatformServiceProperties();
        BISerialService bISerialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
        bISerialService.checkPropertiesLoaded();
        this.portComp = (BComponent)((BComponent)bISerialService).get(this.getPortName());
        if (this.portComp == null) {
            throw new PortNotFoundException(this.getPortName());
        }
        Property property = this.portComp.getProperty("owner");
        String string = this.portComp.getString(property);
        if (string == null) {
            this.portComp.setString(property, "mstp" + this.getMstpTrunk());
        } else if (string.equals("none") || string.equals("")) {
            this.portComp.setString(property, "mstp" + this.getMstpTrunk());
        } else {
            throw new PortDeniedException(this.getPortName() + " is already owned by " + string);
        }
        Property property2 = this.portComp.getProperty("osPortName");
        String string2 = this.portComp.getString(property2);
        BBacnetMstpPlatformService bBacnetMstpPlatformService = this.getPlatformService();
        if (bBacnetMstpPlatformService != null) {
            this.handle = bBacnetMstpPlatformService.startDriver(MSTP_TRUNK_PREFIX + this.getMstpTrunk(), string2, this.getBaudRate().getOrdinal(), this.getMstpAddress(), this.getMaxMaster(), this.getMaxInfoFrames(), (MstpListener)this);
            this.log.trace("BACnet/MSTP Driver started on port " + this.getPortName());
            this.getNetworkPort().ok();
            this.commStarted = true;
        } else {
            this.getNetworkPort().fault("Cannot find MSTP platform service");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void linkCommStop() throws Exception {
        block4: {
            if (!this.commStarted) return;
            this.commStarted = false;
            try {
                this.getPlatformService().stopDriver(this.handle);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.portComp != null) {
                    this.portComp.setString(this.portComp.getProperty("owner"), "none");
                    this.portComp = null;
                }
                this.handle = -1;
                throw throwable;
            }
            {
                Object var2_3 = null;
                if (this.portComp == null) break block4;
            }
            this.portComp.setString(this.portComp.getProperty("owner"), "none");
            this.portComp = null;
        }
        this.handle = -1;
    }

    public Log log() {
        return this.log;
    }

    public byte[] getMacAddress() {
        return new byte[]{(byte)this.getMstpAddress()};
    }

    public int getMaxAPDULengthAccepted() {
        if (this.getSupportExtendedFrames()) {
            return 1476;
        }
        return 480;
    }

    public synchronized void sendRequest(byte[] byArray, NetworkPdu networkPdu) {
        byte by = byArray == null || byArray.length == 0 ? (byte)-1 : byArray[0];
        this.os.reset();
        networkPdu.writeNetworkBytes(this.os);
        byte[] byArray2 = this.os.toByteArray();
        try {
            if (this.commStarted) {
                this.getPlatformService().sendFrame(this.handle, by, byArray2, networkPdu.getDataExpectingReply());
                if (this.log.isTraceOn()) {
                    this.log.trace("\nMSTP Packet Sent to " + by + " Size=" + this.os.size() + " DER=" + networkPdu.getDataExpectingReply() + " on " + this.getPortName() + ':');
                    ByteArrayUtil.hexDump((byte[])byArray2);
                }
            } else {
                this.log.message("Cannot send MSTP packet! commStarted=" + this.commStarted);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception in BacnetMSTPLinkLayer!\n trunk=" + this.getMstpTrunk() + "\n platlet=" + this.getPlatformService() + "\n npdu=" + networkPdu + "\n log=" + this.log);
        }
    }

    public void receiveFrame(byte by, byte[] byArray, boolean bl) {
        byte[] byArray2 = new byte[]{by};
        if (this.log.isTraceOn()) {
            this.log.trace("\nMSTP Packet Received from " + by + " Size=" + byArray.length + " DER=" + bl + " on " + this.getPortName() + ':');
            ByteArrayUtil.hexDump((byte[])byArray);
        }
        if (this.linkListener != null) {
            this.linkListener.rcvIndication(byArray2, new byte[]{(byte)this.getMstpAddress()}, BacnetInputStream.make(byArray, 0, byArray.length));
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"MSTP Link Layer", 2);
        spyWriter.prop((Object)"trunks (static)", (Object)trunks);
        if (trunks != null) {
            int n = 0;
            while (n < trunks.length) {
                spyWriter.prop((Object)("trunks[" + n + ']'), trunks[n]);
                ++n;
            }
        }
        spyWriter.prop((Object)"handle", this.handle);
        spyWriter.prop((Object)"commStarted", this.commStarted);
        spyWriter.prop((Object)"port", (Object)this.portComp);
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.os = new ByteArrayOutputStream();
        this.handle = -1;
        this.commStarted = false;
        this.portComp = null;
    }

    public BBacnetMstpLinkLayer() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$link$mstp$BBacnetMstpLinkLayer;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$link$mstp$BBacnetMstpLinkLayer = BBacnetMstpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.mstp.BBacnetMstpLinkLayer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        licenseChecked = false;
    }
}

