/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.client;

import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.DeviceRegistry;
import java.util.StringTokenizer;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.log.Log;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class AckAlarmRequest
implements Runnable,
BacnetAlarmConst {
    private BAlarmRecord ackRequest;

    public void run() {
        BBacnetDevice bBacnetDevice = null;
        try {
            BBacnetAddress bBacnetAddress;
            BBacnetNetwork bBacnetNetwork = BBacnetNetwork.bacnet();
            BFacets bFacets = this.ackRequest.getAlarmData();
            long l = Long.parseLong(((BString)bFacets.getFacet("processId")).getString());
            String string = ((BString)bFacets.getFacet("objectId")).getString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetObjectIdentifier.make(BBacnetObjectType.ordinal(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            String string2 = this.ackRequest.getUser();
            if (string2 == null || string2.length() == 0) {
                string2 = "Niagara AX:" + Sys.getStation().getStationName();
            }
            BBacnetTimeStamp bBacnetTimeStamp = new BBacnetTimeStamp(this.ackRequest.getAckTime());
            string = ((BString)bFacets.getFacet("deviceId")).getString();
            stringTokenizer = new StringTokenizer(string, "_");
            BBacnetObjectIdentifier bBacnetObjectIdentifier2 = BBacnetObjectIdentifier.make(BBacnetObjectType.ordinal(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            BCharacterSetEncoding bCharacterSetEncoding = bBacnetNetwork.getLocalDevice().getCharacterSet();
            bBacnetDevice = bBacnetNetwork.doLookupDeviceById(bBacnetObjectIdentifier2);
            if (bBacnetDevice != null) {
                bCharacterSetEncoding = bBacnetDevice.getCharacterSet();
            }
            if ((bBacnetAddress = DeviceRegistry.getDeviceAddress(bBacnetObjectIdentifier2)) == null) {
                System.out.println("Device ID " + (Object)((Object)bBacnetObjectIdentifier2) + " not found in device address table, unable to acknowledge alarm!");
                return;
            }
            BString bString = (BString)bFacets.getFacet("bacnetAcksRequired");
            if (bString == null) {
                Log.getLog((String)"bacnet.client").message("No states requiring BACnet acknowledgment for this alarm record!");
                try {
                    BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                    this.ackRequest.ackAlarm();
                    this.ackRequest.setAckState(BAckState.acked);
                    bAlarmService.routeAlarm(this.ackRequest);
                }
                catch (ServiceNotFoundException serviceNotFoundException) {
                    Log.getLog((String)"bacnet.client").error("AckAlarmRequest.run:Unable to find Alarm Service to clear alarm!", (Throwable)serviceNotFoundException);
                    serviceNotFoundException.printStackTrace();
                }
                return;
            }
            String string3 = bString.getString();
            stringTokenizer = new StringTokenizer(string3, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                int n = string4.indexOf("@");
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n + 1);
                BBacnetEventState bBacnetEventState = BBacnetEventState.make(string5);
                BBacnetTimeStamp bBacnetTimeStamp2 = BBacnetTimeStamp.fromText(string6);
                try {
                    ((BBacnetStack)bBacnetNetwork.getBacnetComm()).getClient().acknowledgeAlarm(bBacnetAddress, l, bBacnetObjectIdentifier, bBacnetEventState, bBacnetTimeStamp2, string2, bBacnetTimeStamp, bCharacterSetEncoding);
                }
                catch (BacnetException bacnetException) {
                    Log.getLog((String)"bacnet.client").error("BacnetException sending AcknowledgeAlarm:" + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            Log.getLog((String)"bacnet.client").error("Unable to send Bacnet Ack! Required Bacnet information not found in record!", (Throwable)nullPointerException);
        }
        catch (Exception exception) {
            Log.getLog((String)"bacnet.client").error("Exception in AckAlarmRequest! -- ACK not received?", (Throwable)exception);
        }
    }

    public AckAlarmRequest(BAlarmRecord bAlarmRecord) {
        this.ackRequest = bAlarmRecord;
    }
}

