/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack;

import java.util.Iterator;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.nre.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DeviceRegistry {
    private static DeviceRegistry registry = new DeviceRegistry();
    private IntHashMap byAddress;
    private IntHashMap byId;

    public static Iterator addressIterator() {
        return DeviceRegistry.registry.byAddress.iterator();
    }

    public static Iterator idIterator() {
        return DeviceRegistry.registry.byId.iterator();
    }

    public static void dump() {
        int n;
        DeviceEntry deviceEntry;
        System.out.println("By Address Table");
        IntHashMap.Iterator iterator = DeviceRegistry.registry.byAddress.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            deviceEntry = (DeviceEntry)iterator.next();
            n = iterator.key();
            System.out.println(++n2 + "  k=" + n + " -> " + deviceEntry);
        }
        System.out.println("\nBy ID Table");
        iterator = DeviceRegistry.registry.byId.iterator();
        n2 = 0;
        while (iterator.hasNext()) {
            deviceEntry = (DeviceEntry)iterator.next();
            n = iterator.key();
            System.out.println(++n2 + "  k=" + n + " -> " + deviceEntry);
        }
        System.out.println();
    }

    public static void update(BBacnetDevice bBacnetDevice) {
        registry.updateEntry(bBacnetDevice.getObjectId(), bBacnetDevice.getAddress(), bBacnetDevice.getMaxAPDULengthAccepted(), bBacnetDevice.getSegmentationSupported(), bBacnetDevice.getProtocolRevision());
    }

    public static void update(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetAddress bBacnetAddress, int n, BBacnetSegmentation bBacnetSegmentation) {
        registry.updateEntry(bBacnetObjectIdentifier, bBacnetAddress, n, bBacnetSegmentation);
    }

    public static void remove(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        registry.removeEntry(bBacnetObjectIdentifier);
    }

    public static int getMaxApduLengthSupported(BBacnetAddress bBacnetAddress) {
        return registry.getMaxLength(bBacnetAddress);
    }

    public static BBacnetObjectIdentifier getDeviceId(BBacnetAddress bBacnetAddress) {
        return registry.getDeviceObjectId(bBacnetAddress);
    }

    public static BBacnetAddress getDeviceAddress(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return registry.getAddress(bBacnetObjectIdentifier);
    }

    public static int getProtocolRevision(BBacnetAddress bBacnetAddress) {
        return registry.getProtRev(bBacnetAddress);
    }

    public static BBacnetSegmentation getSegmentationSupported(BBacnetAddress bBacnetAddress) {
        return registry.getSegSupp(bBacnetAddress);
    }

    private final void updateEntry(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetAddress bBacnetAddress, int n, BBacnetSegmentation bBacnetSegmentation, int n2) {
        DeviceEntry deviceEntry = (DeviceEntry)this.byId.get(bBacnetObjectIdentifier.hashCode());
        if (deviceEntry != null) {
            deviceEntry.maxApduLengthSupported = n;
            deviceEntry.segmentationSupported = bBacnetSegmentation;
            deviceEntry.protocolRevision = n2;
            if (!deviceEntry.address.equals(bBacnetAddress)) {
                this.byAddress.remove(deviceEntry.address.hash());
                deviceEntry.address = bBacnetAddress;
                this.byAddress.put(bBacnetAddress.hash(), (Object)deviceEntry);
            }
            return;
        }
        deviceEntry = (DeviceEntry)this.byAddress.get(bBacnetAddress.hash());
        if (deviceEntry != null) {
            deviceEntry.maxApduLengthSupported = n;
            deviceEntry.segmentationSupported = bBacnetSegmentation;
            deviceEntry.protocolRevision = n2;
            if (!deviceEntry.deviceId.equals((Object)bBacnetObjectIdentifier)) {
                this.byId.remove(deviceEntry.deviceId.hashCode());
                deviceEntry.deviceId = bBacnetObjectIdentifier;
                this.byId.put(bBacnetObjectIdentifier.hashCode(), (Object)deviceEntry);
            }
            return;
        }
        deviceEntry = new DeviceEntry(bBacnetObjectIdentifier, bBacnetAddress, n, bBacnetSegmentation, n2);
        this.byId.put(bBacnetObjectIdentifier.hashCode(), (Object)deviceEntry);
        this.byAddress.put(bBacnetAddress.hash(), (Object)deviceEntry);
    }

    private final void updateEntry(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetAddress bBacnetAddress, int n, BBacnetSegmentation bBacnetSegmentation) {
        DeviceEntry deviceEntry = (DeviceEntry)this.byId.get(bBacnetObjectIdentifier.hashCode());
        if (deviceEntry != null) {
            deviceEntry.maxApduLengthSupported = n;
            deviceEntry.segmentationSupported = bBacnetSegmentation;
            if (!deviceEntry.address.equals(bBacnetAddress)) {
                this.byAddress.remove(deviceEntry.address.hash());
                deviceEntry.address = bBacnetAddress;
                this.byAddress.put(bBacnetAddress.hash(), (Object)deviceEntry);
                return;
            }
        } else {
            deviceEntry = (DeviceEntry)this.byAddress.get(bBacnetAddress.hash());
            if (deviceEntry != null) {
                deviceEntry.maxApduLengthSupported = n;
                deviceEntry.segmentationSupported = bBacnetSegmentation;
                if (!deviceEntry.deviceId.equals((Object)bBacnetObjectIdentifier)) {
                    this.byId.remove(deviceEntry.deviceId.hashCode());
                    deviceEntry.deviceId = bBacnetObjectIdentifier;
                    this.byId.put(bBacnetObjectIdentifier.hashCode(), (Object)deviceEntry);
                    return;
                }
            }
        }
        deviceEntry = new DeviceEntry(bBacnetObjectIdentifier, bBacnetAddress, n, bBacnetSegmentation);
        this.byId.put(bBacnetObjectIdentifier.hashCode(), (Object)deviceEntry);
        this.byAddress.put(bBacnetAddress.hash(), (Object)deviceEntry);
    }

    private final void removeEntry(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        int n = bBacnetObjectIdentifier.hashCode();
        DeviceEntry deviceEntry = (DeviceEntry)this.byId.get(n);
        if (deviceEntry != null) {
            BBacnetAddress bBacnetAddress = deviceEntry.address;
            this.byId.remove(n);
            this.byAddress.remove(bBacnetAddress.hash());
        }
    }

    private final int getMaxLength(BBacnetAddress bBacnetAddress) {
        DeviceEntry deviceEntry = (DeviceEntry)this.byAddress.get(bBacnetAddress.hash());
        if (deviceEntry == null) {
            return 50;
        }
        return deviceEntry.maxApduLengthSupported;
    }

    private final BBacnetObjectIdentifier getDeviceObjectId(BBacnetAddress bBacnetAddress) {
        DeviceEntry deviceEntry = (DeviceEntry)this.byAddress.get(bBacnetAddress.hash());
        if (deviceEntry != null) {
            return deviceEntry.deviceId;
        }
        return null;
    }

    private final BBacnetAddress getAddress(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        DeviceEntry deviceEntry = (DeviceEntry)this.byId.get(bBacnetObjectIdentifier.hashCode());
        if (deviceEntry != null) {
            return deviceEntry.address;
        }
        return null;
    }

    private final int getProtRev(BBacnetAddress bBacnetAddress) {
        DeviceEntry deviceEntry = (DeviceEntry)this.byAddress.get(bBacnetAddress.hash());
        if (deviceEntry == null) {
            return 0;
        }
        return deviceEntry.protocolRevision;
    }

    private final BBacnetSegmentation getSegSupp(BBacnetAddress bBacnetAddress) {
        DeviceEntry deviceEntry = (DeviceEntry)this.byAddress.get(bBacnetAddress.hash());
        if (deviceEntry == null) {
            return BBacnetSegmentation.noSegmentation;
        }
        return deviceEntry.segmentationSupported;
    }

    private final /* synthetic */ void this() {
        this.byAddress = new IntHashMap();
        this.byId = new IntHashMap();
    }

    public DeviceRegistry() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DeviceEntry {
        BBacnetObjectIdentifier deviceId;
        BBacnetAddress address;
        int maxApduLengthSupported;
        BBacnetSegmentation segmentationSupported;
        int protocolRevision;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.deviceId.toString()).append(" [").append(this.address.toString()).append(']').append(" APDU=").append(this.maxApduLengthSupported).append(" SEG=").append((Object)this.segmentationSupported).append(" PRev=").append(this.protocolRevision);
            return stringBuffer.toString();
        }

        public DeviceEntry(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetAddress bBacnetAddress, int n, BBacnetSegmentation bBacnetSegmentation) {
            this(bBacnetObjectIdentifier, bBacnetAddress, n, bBacnetSegmentation, 0);
        }

        public DeviceEntry(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetAddress bBacnetAddress, int n, BBacnetSegmentation bBacnetSegmentation, int n2) {
            this.deviceId = bBacnetObjectIdentifier;
            this.address = bBacnetAddress;
            this.maxApduLengthSupported = n;
            this.segmentationSupported = bBacnetSegmentation;
            this.protocolRevision = n2;
        }
    }
}

