/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack;

import com.tridium.bacnet.asn.BacnetNotificationParameters;
import com.tridium.bacnet.asn.CovNotificationParameters;
import com.tridium.bacnet.asn.EventNotificationParameters;
import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.IAmListener;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.transport.BBacnetTransportLayer;
import com.tridium.bacnet.stack.transport.IdManager;
import com.tridium.bacnet.timers.Timers;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.datatypes.BBacnetRecipientProcess;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetCommControl;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetReinitializedDeviceState;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.io.BBacnetComm;
import javax.baja.bacnet.io.BacnetServiceListener;
import javax.baja.bacnet.io.FileData;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetStack
extends BBacnetComm
implements IAmListener {
    public static final Property client = BBacnetStack.newProperty((int)0, (BValue)new BBacnetClientLayer(), null);
    public static final Property server = BBacnetStack.newProperty((int)0, (BValue)new BBacnetServerLayer(), null);
    public static final Property transport = BBacnetStack.newProperty((int)0, (BValue)new BBacnetTransportLayer(), null);
    public static final Property network = BBacnetStack.newProperty((int)0, (BValue)new BBacnetNetworkLayer(), null);
    public static final Action dumpDeviceRegistry = BBacnetStack.newAction((int)0, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$BBacnetStack;

    public BBacnetClientLayer getClient() {
        return (BBacnetClientLayer)this.get(client);
    }

    public void setClient(BBacnetClientLayer bBacnetClientLayer) {
        this.set(client, (BValue)bBacnetClientLayer, null);
    }

    public BBacnetServerLayer getServer() {
        return (BBacnetServerLayer)this.get(server);
    }

    public void setServer(BBacnetServerLayer bBacnetServerLayer) {
        this.set(server, (BValue)bBacnetServerLayer, null);
    }

    public BBacnetTransportLayer getTransport() {
        return (BBacnetTransportLayer)this.get(transport);
    }

    public void setTransport(BBacnetTransportLayer bBacnetTransportLayer) {
        this.set(transport, (BValue)bBacnetTransportLayer, null);
    }

    public BBacnetNetworkLayer getNetwork() {
        return (BBacnetNetworkLayer)this.get(network);
    }

    public void setNetwork(BBacnetNetworkLayer bBacnetNetworkLayer) {
        this.set(network, (BValue)bBacnetNetworkLayer, null);
    }

    public void dumpDeviceRegistry() {
        this.invoke(dumpDeviceRegistry, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void descendantsStarted() {
        Timers.start();
        this.getServer().registerIAmListener(this);
    }

    public void stopped() {
        this.getServer().unregisterIAmListener(this);
        Timers.stop();
    }

    public void stopStack() {
        this.getServer().stackStopped();
        this.getTransport().stackStopped();
        this.getNetwork().stackStopped();
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetNetwork;
    }

    public BBacnetNetwork bacnet() {
        return (BBacnetNetwork)this.getParent();
    }

    public void receiveIAm(IAmRequest iAmRequest, BBacnetAddress bBacnetAddress) {
        this.bacnet().updateDeviceInfo(iAmRequest.getObjectId(), bBacnetAddress, iAmRequest.getMaxAPDULengthAccepted(), iAmRequest.getSegmentationSupported(), iAmRequest.getVendorId());
    }

    public void doDumpDeviceRegistry() {
        DeviceRegistry.dump();
        System.out.println("Invoke ID Manager dump:");
        IdManager.dumpTable();
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetStack", 2);
        Iterator iterator = DeviceRegistry.addressIterator();
        int n = 0;
        while (iterator.hasNext()) {
            DeviceRegistry.DeviceEntry deviceEntry = (DeviceRegistry.DeviceEntry)iterator.next();
            spyWriter.prop((Object)("" + ++n), (Object)deviceEntry);
        }
        spyWriter.endProps();
        IdManager.spy(spyWriter);
        Timers.spy(spyWriter);
    }

    public void acknowledgeAlarm(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetEventState bBacnetEventState, BBacnetTimeStamp bBacnetTimeStamp, String string, BBacnetTimeStamp bBacnetTimeStamp2, BCharacterSetEncoding bCharacterSetEncoding) throws BacnetException {
        this.getClient().acknowledgeAlarm(bBacnetAddress, l, bBacnetObjectIdentifier, bBacnetEventState, bBacnetTimeStamp, string, bBacnetTimeStamp2, bCharacterSetEncoding);
    }

    public void confirmedCovNotification(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetObjectIdentifier bBacnetObjectIdentifier2, long l2, PropertyValue[] propertyValueArray) throws BacnetException {
        CovNotificationParameters covNotificationParameters = new CovNotificationParameters(l, bBacnetObjectIdentifier, bBacnetObjectIdentifier2, l2, propertyValueArray);
        this.getClient().confirmedCovNotification(bBacnetAddress, covNotificationParameters);
    }

    public void confirmedEventNotification(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetObjectIdentifier bBacnetObjectIdentifier2, BBacnetTimeStamp bBacnetTimeStamp, long l2, int n, BEnum bEnum, String string, BBacnetNotifyType bBacnetNotifyType, boolean bl, BEnum bEnum2, BEnum bEnum3, BacnetNotificationParameters bacnetNotificationParameters, BCharacterSetEncoding bCharacterSetEncoding) throws BacnetException {
        EventNotificationParameters eventNotificationParameters = new EventNotificationParameters(l, bBacnetObjectIdentifier, bBacnetObjectIdentifier2, bBacnetTimeStamp, l2, n, bEnum, string, bBacnetNotifyType, bl, bEnum2, bEnum3, bacnetNotificationParameters, bCharacterSetEncoding);
        this.getClient().confirmedEventNotification(bBacnetAddress, eventNotificationParameters);
    }

    public Vector getAlarmSummary(BBacnetAddress bBacnetAddress) throws BacnetException {
        return this.getClient().getAlarmSummary(bBacnetAddress);
    }

    public Vector getEnrollmentSummary(BBacnetAddress bBacnetAddress, int n, BBacnetRecipientProcess bBacnetRecipientProcess, int n2, BEnum bEnum, int[] nArray, long l) throws BacnetException {
        return this.getClient().getEnrollmentSummary(bBacnetAddress, n, bBacnetRecipientProcess, n2, bEnum, nArray, l);
    }

    public Vector getEventInformation(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier) throws BacnetException {
        return this.getClient().getEventInformation(bBacnetAddress, bBacnetObjectIdentifier);
    }

    public void subscribeCov(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, boolean bl, long l2) throws BacnetException {
        this.getClient().subscribeCov(bBacnetAddress, l, bBacnetObjectIdentifier, bl, l2);
    }

    public void unsubscribeCov(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier) throws BacnetException {
        this.getClient().unsubscribeCov(bBacnetAddress, l, bBacnetObjectIdentifier);
    }

    public void subscribeCovProperty(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, boolean bl, long l2, PropertyReference propertyReference, BDouble bDouble) throws BacnetException {
        this.getClient().subscribeCovProperty(bBacnetAddress, l, bBacnetObjectIdentifier, bl, l2, propertyReference, bDouble);
    }

    public void unsubscribeCovProperty(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, PropertyReference propertyReference) throws BacnetException {
        this.getClient().unsubscribeCovProperty(bBacnetAddress, l, bBacnetObjectIdentifier, propertyReference);
    }

    public FileData atomicReadFileRecord(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, long l) throws BacnetException {
        return this.getClient().atomicReadFile(bBacnetAddress, bBacnetObjectIdentifier, 1, n, l);
    }

    public FileData atomicReadFileStream(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, long l) throws BacnetException {
        return this.getClient().atomicReadFile(bBacnetAddress, bBacnetObjectIdentifier, 0, n, l);
    }

    public int atomicWriteFileRecord(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, long l, BBacnetOctetString[] bBacnetOctetStringArray) throws BacnetException {
        return this.getClient().atomicWriteFileRecord(bBacnetAddress, bBacnetObjectIdentifier, n, l, bBacnetOctetStringArray);
    }

    public int atomicWriteFileStream(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) throws BacnetException {
        return this.getClient().atomicWriteFileStream(bBacnetAddress, bBacnetObjectIdentifier, n, byArray);
    }

    public void addListElement(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) throws BacnetException {
        this.getClient().addListElement(bBacnetAddress, bBacnetObjectIdentifier, n, byArray);
    }

    public void addListElement(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, byte[] byArray) throws BacnetException {
        this.getClient().addListElement(bBacnetAddress, bBacnetObjectIdentifier, n, n2, byArray);
    }

    public void removeListElement(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) throws BacnetException {
        this.getClient().removeListElement(bBacnetAddress, bBacnetObjectIdentifier, n, byArray);
    }

    public void removeListElement(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, byte[] byArray) throws BacnetException {
        this.getClient().removeListElement(bBacnetAddress, bBacnetObjectIdentifier, n, n2, byArray);
    }

    public BBacnetObjectIdentifier createObject(BBacnetAddress bBacnetAddress, int n, Array array) throws BacnetException {
        return this.getClient().createObject(bBacnetAddress, n, array);
    }

    public BBacnetObjectIdentifier createObject(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, Array array) throws BacnetException {
        return this.getClient().createObject(bBacnetAddress, bBacnetObjectIdentifier, array);
    }

    public void deleteObject(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier) throws BacnetException {
        this.getClient().deleteObject(bBacnetAddress, bBacnetObjectIdentifier);
    }

    public byte[] readProperty(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n) throws BacnetException {
        return this.getClient().readProperty(bBacnetAddress, bBacnetObjectIdentifier, n);
    }

    public byte[] readProperty(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2) throws BacnetException {
        return this.getClient().readProperty(bBacnetAddress, bBacnetObjectIdentifier, n, n2);
    }

    public Vector readPropertyMultiple(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, Vector vector) throws BacnetException {
        return this.getClient().readPropertyMultiple(bBacnetAddress, bBacnetObjectIdentifier, vector);
    }

    public Vector readPropertyMultiple(BBacnetAddress bBacnetAddress, Vector vector) throws BacnetException {
        return this.getClient().readPropertyMultiple(bBacnetAddress, vector);
    }

    public RangeData readRange(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, int n3, long l, BBacnetDateTime bBacnetDateTime, int n4) throws BacnetException {
        return this.getClient().readRange(bBacnetAddress, bBacnetObjectIdentifier, n, n2, n3, l, bBacnetDateTime, n4);
    }

    public void writeProperty(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, byte[] byArray) throws BacnetException {
        this.getClient().writeProperty(bBacnetAddress, bBacnetObjectIdentifier, n, n2, byArray);
    }

    public void writeProperty(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) throws BacnetException {
        this.getClient().writeProperty(bBacnetAddress, bBacnetObjectIdentifier, n, byArray);
    }

    public void writeProperty(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, byte[] byArray, int n3) throws BacnetException {
        this.getClient().writeProperty(bBacnetAddress, bBacnetObjectIdentifier, n, n2, byArray, n3);
    }

    public void writePropertyMultiple(BBacnetAddress bBacnetAddress, Vector vector) throws BacnetException {
        this.getClient().writePropertyMultiple(bBacnetAddress, vector);
    }

    public void deviceCommunicationControl(BBacnetAddress bBacnetAddress, BBacnetCommControl bBacnetCommControl, BRelTime bRelTime, String string, BCharacterSetEncoding bCharacterSetEncoding) throws BacnetException {
        this.getClient().deviceCommunicationControl(bBacnetAddress, bBacnetCommControl, bRelTime, string, bCharacterSetEncoding);
    }

    public byte[] confirmedPrivateTransfer(BBacnetAddress bBacnetAddress, int n, int n2, byte[] byArray) throws BacnetException {
        return this.getClient().confirmedPrivateTransfer(bBacnetAddress, n, n2, byArray);
    }

    public void reinitializeDevice(BBacnetAddress bBacnetAddress, BBacnetReinitializedDeviceState bBacnetReinitializedDeviceState, String string, BCharacterSetEncoding bCharacterSetEncoding) throws BacnetException {
        this.getClient().reinitializeDevice(bBacnetAddress, bBacnetReinitializedDeviceState, string, bCharacterSetEncoding);
    }

    public void iAm() {
        this.getServer().iAm();
    }

    public void iHave(BBacnetObjectIdentifier bBacnetObjectIdentifier, String string, BCharacterSetEncoding bCharacterSetEncoding) {
        this.getServer().iHave(bBacnetObjectIdentifier, string, bCharacterSetEncoding);
    }

    public void unconfirmedCovNotification(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetObjectIdentifier bBacnetObjectIdentifier2, long l2, PropertyValue[] propertyValueArray) throws BacnetException {
        CovNotificationParameters covNotificationParameters = new CovNotificationParameters(l, bBacnetObjectIdentifier, bBacnetObjectIdentifier2, l2, propertyValueArray);
        this.getClient().unconfirmedCovNotification(bBacnetAddress, covNotificationParameters);
    }

    public void unconfirmedEventNotification(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetObjectIdentifier bBacnetObjectIdentifier2, BBacnetTimeStamp bBacnetTimeStamp, long l2, int n, BEnum bEnum, String string, BBacnetNotifyType bBacnetNotifyType, boolean bl, BEnum bEnum2, BEnum bEnum3, BacnetNotificationParameters bacnetNotificationParameters, BCharacterSetEncoding bCharacterSetEncoding) throws BacnetException {
        EventNotificationParameters eventNotificationParameters = new EventNotificationParameters(l, bBacnetObjectIdentifier, bBacnetObjectIdentifier2, bBacnetTimeStamp, l2, n, bEnum, string, bBacnetNotifyType, bl, bEnum2, bEnum3, bacnetNotificationParameters, bCharacterSetEncoding);
        this.getClient().unconfirmedEventNotification(bBacnetAddress, eventNotificationParameters);
    }

    public void unconfirmedPrivateTransfer(BBacnetAddress bBacnetAddress, int n, int n2, byte[] byArray) throws BacnetException {
        this.getClient().unconfirmedPrivateTransfer(bBacnetAddress, n, n2, byArray);
    }

    public void timeSynch(BBacnetRecipient bBacnetRecipient) throws BacnetException {
        this.getClient().timeSynch(bBacnetRecipient);
    }

    public void whoHas(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier) throws BacnetException {
        this.getClient().whoHas(bBacnetAddress, bBacnetObjectIdentifier);
    }

    public void whoHas(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2) throws BacnetException {
        this.getClient().whoHas(bBacnetAddress, bBacnetObjectIdentifier, n, n2);
    }

    public void whoHas(BBacnetAddress bBacnetAddress, String string, BCharacterSetEncoding bCharacterSetEncoding) throws BacnetException {
        this.getClient().whoHas(bBacnetAddress, string, bCharacterSetEncoding);
    }

    public void whoHas(BBacnetAddress bBacnetAddress, String string, BCharacterSetEncoding bCharacterSetEncoding, int n, int n2) throws BacnetException {
        this.getClient().whoHas(bBacnetAddress, string, bCharacterSetEncoding, n, n2);
    }

    public void whoIs(BBacnetAddress bBacnetAddress) throws BacnetException {
        this.getClient().whoIs(bBacnetAddress);
    }

    public void whoIs(BBacnetAddress bBacnetAddress, int n, int n2) throws BacnetException {
        this.getClient().whoIs(bBacnetAddress, n, n2);
    }

    public void utcTimeSynch(BBacnetRecipient bBacnetRecipient) throws BacnetException {
        this.getClient().utcTimeSynch(bBacnetRecipient);
    }

    public void registerBacnetListener(BacnetServiceListener bacnetServiceListener, int n) {
        this.getServer().registerBacnetServiceListener(bacnetServiceListener, n);
    }

    public void unregisterBacnetListener(BacnetServiceListener bacnetServiceListener, int n) {
        this.getServer().unregisterBacnetServiceListener(bacnetServiceListener, n);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$BBacnetStack;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$BBacnetStack = BBacnetStack.class("[Lcom.tridium.bacnet.stack.BBacnetStack;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

