/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack;

import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.MultiPollThread;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import java.text.DecimalFormat;
import javax.baja.bacnet.util.PollList;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetMultiPoll
extends BBacnetPoll {
    public static final Property maxDibsPolls = BBacnetMultiPoll.newProperty((int)4, (int)5, null);
    public static final Property numberOfThreads = BBacnetMultiPoll.newProperty((int)1, (int)2, null);
    public static final Type TYPE;
    static final DecimalFormat avgCntFormat;
    long stats;
    MultiPollThread[] pollThreads;
    private int dibsPolls;
    private long sleep;
    private BBacnetPoll.BacnetBucket nextBucket;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$BBacnetMultiPoll;

    public int getMaxDibsPolls() {
        return this.getInt(maxDibsPolls);
    }

    public void setMaxDibsPolls(int n) {
        this.setInt(maxDibsPolls, n, null);
    }

    public int getNumberOfThreads() {
        return this.getInt(numberOfThreads);
    }

    public void setNumberOfThreads(int n) {
        this.setInt(numberOfThreads, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context context) {
        if (this.isRunning()) {
            return "BacnetMultiPoll in " + this.getParent().getName();
        }
        return "BacnetMultiPoll";
    }

    public void pollStart() {
        this.initializeBuckets();
        this.fast.nextBucket = this.norm;
        this.norm.nextBucket = this.slow;
        this.slow.nextBucket = this.fast;
        this.nextBucket = this.fast;
        int n = this.getNumberOfThreads();
        this.pollStop();
        this.isAlive = true;
        this.pollThreads = new MultiPollThread[n];
        this.dibsPolls = 0;
        this.doResetStatistics();
        this.stats = Clock.ticks() + 10000L;
        int n2 = 0;
        while (n2 < n) {
            this.pollThreads[n2] = new MultiPollThread(this, "BnMP" + ((BNetworkPort)this.getParent()).getPortId() + ':' + this.getParent().getName() + ':', n2);
            this.pollThreads[n2].start();
            ++n2;
        }
    }

    public void pollStop() {
        this.isAlive = false;
        if (this.pollThreads == null) {
            return;
        }
        int n = 0;
        while (n < this.pollThreads.length) {
            if (this.pollThreads[n] != null) {
                this.pollThreads[n].stop();
                this.pollThreads[n] = null;
            }
            ++n;
        }
        this.pollThreads = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (!property.equals((Object)numberOfThreads) || !this.isAlive) return;
        this.pollStop();
        ((BBacnetNetworkLayer)this.getParent().getParent()).initializeAsnInputPool();
        Object object = this.lock;
        synchronized (object) {
            this.fast.resetDone();
            this.norm.resetDone();
            this.slow.resetDone();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
            this.pollStart();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollList next() {
        PollList pollList = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.dibs.isEmpty() && this.dibsPolls < this.getMaxDibsPolls()) {
                pollList = (PollList)this.dibs.pop();
                ++this.dibsPollTotal;
                ++this.dibsPolls;
                pollList.setSleep(this.computeSleep());
                return pollList;
            }
            this.dibsPolls = 0;
            pollList = this.checkBuckets();
            if (Clock.ticks() > this.stats) {
                this.checkBucketConfig();
                this.updateStats();
                this.stats = Clock.ticks() + 10000L;
            }
            if (pollList != null) {
                pollList.setSleep(this.computeSleep());
            }
            return pollList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PollList checkBuckets() {
        var1_1 = this.lock;
        synchronized (var1_1) {
            var5_2 = 0;
            while (true) {
                block7: {
                    if (var5_2 < 3) break block7;
                    var5_2 = 0;
                    if (true) ** GOTO lbl22
                }
                var4_3 = this.checkBucket(this.nextBucket, false);
                if (var4_3 != null) {
                    return var4_3;
                }
                ++var5_2;
            }
            do {
                if ((var4_3 = this.checkBucket(this.nextBucket, true)) != null) {
                    return var4_3;
                }
                ++var5_2;
lbl22:
                // 2 sources

            } while (var5_2 < 3);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PollList checkBucket(BBacnetPoll.BacnetBucket var1_1, boolean var2_2) {
        var3_3 = this.lock;
        synchronized (var3_3) {
            block13: {
                block12: {
                    this.nextBucket = var1_1.nextBucket;
                    if (var1_1.nextTicks > Clock.ticks() + (long)5) {
                        return null;
                    }
                    var6_4 = null;
                    var7_5 = 0;
                    var8_6 = var1_1.index;
                    var7_5 = var1_1.q.size();
                    if (var7_5 <= 0) break block12;
                    if (var8_6 >= var7_5) {
                        var8_6 = 0;
                    }
                    var9_7 = 0;
                    if (true) ** GOTO lbl28
                }
                ++var1_1.cycleTotal;
                break block13;
                do {
                    if (!((var10_9 = (PollList)var1_1.q.get(var8_6)).isPolling() || !var2_2 && var10_9.getDevice().isPolling() || var10_9.isDone())) {
                        var6_4 = var10_9;
                        var1_1.index = var8_6 + 1;
                        break;
                    }
                    var8_6 = (var8_6 + 1) % var7_5;
lbl28:
                    // 2 sources

                } while (var9_7++ < var7_5);
                if (var1_1.pollCount >= var7_5) {
                    if (this.log.isTraceOn()) {
                        this.log.trace("Reset bucket " + var1_1 + " on thd " + Thread.currentThread().getName());
                    }
                    ++var1_1.cycleTotal;
                    var1_1.pollCount = 0;
                    var1_1.resetDone();
                }
            }
            if (var6_4 != null) {
                ++var1_1.pollCount;
                ++var1_1.pollTotal;
                var6_4.setIsPolling(true);
                var6_4.setDone(true);
            }
            var11_10 = var9_8 = ((BRelTime)this.get(var1_1.rateProp)).getMillis();
            if (var7_5 > 0) {
                var13_11 = var9_8;
                var15_12 = var7_5;
                var11_10 = (long)((var13_11 - var15_12 * (double)this.lastPollTime) / var15_12);
            } else {
                var11_10 = 1000L;
            }
            var1_1.nextTicks = Clock.ticks() + var11_10;
            return var6_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long computeSleep() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.dibs.isEmpty()) {
                return 0L;
            }
            long l = Clock.ticks();
            long l2 = this.fast.nextTicks - l;
            long l3 = this.norm.nextTicks - l;
            long l4 = this.slow.nextTicks - l;
            this.sleep = 10000L;
            if (l2 < this.sleep) {
                this.sleep = l2;
                this.nextBucket = this.fast;
            }
            if (l3 < this.sleep) {
                this.sleep = l3;
                this.nextBucket = this.norm;
            }
            if (l4 < this.sleep) {
                this.sleep = l4;
                this.nextBucket = this.slow;
            }
            return this.sleep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doResetStatistics() {
        this.totalPollTime = 0L;
        this.totalPollCount = 0;
        this.average = 0.0;
        this.statsCount = 0;
        this.dibsPollTotal = 0;
        this.dibsSizeTotal = 0;
        Object object = this.lock;
        synchronized (object) {
            this.fast.reset();
            this.norm.reset();
            this.slow.reset();
            this.start = Clock.ticks();
            this.setStatisticsStart(BAbsTime.make());
            this.updateStats();
            return;
        }
    }

    protected String toCount(int n, int n2) {
        return "current=" + n + " average=" + avgCntFormat.format((double)n2 / (double)this.statsCount);
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetMultiPoll", 2);
        spyWriter.prop((Object)"dibsPolls", this.dibsPolls);
        spyWriter.prop((Object)"stats", (Object)BLong.make((long)this.stats));
        spyWriter.prop((Object)"sleep", (Object)BLong.make((long)this.sleep));
        spyWriter.prop((Object)"nextBucket", (Object)this.nextBucket);
        if (this.isAlive) {
            spyWriter.prop((Object)"pollThreads", this.pollThreads.length);
            int n = 0;
            while (n < this.pollThreads.length) {
                spyWriter.prop((Object)("  " + n), (Object)this.pollThreads[n].getName());
                this.pollThreads[n].spyImpl(spyWriter);
                ++n;
            }
        }
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.dibsPolls = 0;
    }

    public BBacnetMultiPoll() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$BBacnetMultiPoll;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$BBacnetMultiPoll = BBacnetMultiPoll.class("[Lcom.tridium.bacnet.stack.BBacnetMultiPoll;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        avgCntFormat = new DecimalFormat("0.0#");
    }
}

