/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.unconfirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetUnconfirmedRequest;
import java.util.StringTokenizer;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BString;

public class IHaveRequest
extends BacnetUnconfirmedRequest {
    private BBacnetObjectIdentifier deviceId;
    private BBacnetObjectIdentifier objectId;
    private String objectName;
    private BCharacterSetEncoding encoding;

    public BBacnetObjectIdentifier getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.deviceId = bBacnetObjectIdentifier;
    }

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.objectId = bBacnetObjectIdentifier;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public BCharacterSetEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(BCharacterSetEncoding bCharacterSetEncoding) {
        this.encoding = bCharacterSetEncoding;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeObjectIdentifier(this.deviceId);
        asnOutputStream.writeObjectIdentifier(this.objectId);
        asnOutputStream.writeCharacterString(this.objectName, this.encoding);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.deviceId = asnInputStream.readObjectIdentifier();
        this.objectId = asnInputStream.readObjectIdentifier();
        this.encoding = asnInputStream.peekEncoding();
        this.objectName = asnInputStream.readCharacterString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BacnetUnconfirmedServiceChoice.TAGS[1]);
        stringBuffer.append("\n  deviceId " + (Object)((Object)this.deviceId));
        stringBuffer.append("\n  objectId " + (Object)((Object)this.objectId));
        stringBuffer.append("\n  objectName " + this.objectName);
        return stringBuffer.toString();
    }

    public BString toJob() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.deviceId.toString()).append('|').append(this.objectId.toString()).append('|').append(this.objectName);
        return BString.make((String)stringBuffer.toString());
    }

    public static String fromJob(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringTokenizer.nextToken()).append(" has object ").append(stringTokenizer.nextToken()).append(" named ").append(stringTokenizer.nextToken()).append("\n");
        return stringBuffer.toString();
    }

    public IHaveRequest() {
        this(null, null, null, null);
    }

    public IHaveRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetObjectIdentifier bBacnetObjectIdentifier2, String string) {
        this(bBacnetObjectIdentifier, bBacnetObjectIdentifier2, string, BBacnetNetwork.localDevice().getCharacterSet());
    }

    public IHaveRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetObjectIdentifier bBacnetObjectIdentifier2, String string, BCharacterSetEncoding bCharacterSetEncoding) {
        super(1);
        this.deviceId = bBacnetObjectIdentifier;
        this.objectId = bBacnetObjectIdentifier2;
        this.objectName = string;
        this.encoding = bCharacterSetEncoding;
    }
}

