/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.unconfirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetUnconfirmedRequest;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.bacnet.io.AsnException;

public class IAmRequest
extends BacnetUnconfirmedRequest {
    private BBacnetObjectIdentifier objectId;
    private int maxApduLengthAccepted;
    private BBacnetSegmentation segmentationSupported;
    private int vendorId;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.objectId = bBacnetObjectIdentifier;
    }

    public int getMaxAPDULengthAccepted() {
        return this.maxApduLengthAccepted;
    }

    public BBacnetSegmentation getSegmentationSupported() {
        return this.segmentationSupported;
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeObjectIdentifier(this.objectId);
        asnOutputStream.writeUnsignedInteger(this.maxApduLengthAccepted);
        asnOutputStream.writeEnumerated(this.segmentationSupported.getOrdinal());
        asnOutputStream.writeUnsignedInteger(this.vendorId);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.objectId = asnInputStream.readObjectIdentifier();
        this.maxApduLengthAccepted = asnInputStream.readUnsignedInt();
        this.segmentationSupported = BBacnetSegmentation.make(asnInputStream.readEnumerated());
        this.vendorId = asnInputStream.readUnsignedInt();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BacnetUnconfirmedServiceChoice.TAGS[0]);
        stringBuffer.append("\n  objectId " + (Object)((Object)this.objectId));
        stringBuffer.append("\n  maxApduLengthAccepted " + this.maxApduLengthAccepted);
        stringBuffer.append("\n  segmentationSupported " + (Object)((Object)this.segmentationSupported));
        stringBuffer.append("\n  vendorId " + this.vendorId);
        return stringBuffer.toString();
    }

    public IAmRequest() {
        this(null, 0, BBacnetSegmentation.noSegmentation, 0);
    }

    public IAmRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, BBacnetSegmentation bBacnetSegmentation, int n2) {
        super(0);
        this.objectId = bBacnetObjectIdentifier;
        this.maxApduLengthAccepted = n;
        this.segmentationSupported = bBacnetSegmentation;
        this.vendorId = n2;
    }
}

