/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.error;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.error.SimpleError;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.io.AsnException;

public class WritePropertyMultipleError
extends SimpleError {
    public static final int ERROR_TYPE_TAG = 0;
    public static final int FIRST_FAILED_WRITE_ATTEMPT_TAG = 1;
    private BBacnetObjectPropertyReference firstFailedWriteAttempt;

    public BBacnetObjectPropertyReference getFirstFailedWriteAttempt() {
        return this.firstFailedWriteAttempt;
    }

    public Object[] getErrorParameters() {
        return new Object[]{this.firstFailedWriteAttempt};
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(0);
        this.error.writeEncoded(asnOutputStream);
        asnOutputStream.writeClosingTag(0);
        asnOutputStream.writeOpeningTag(1);
        this.firstFailedWriteAttempt.writeAsn(asnOutputStream);
        asnOutputStream.writeClosingTag(1);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        asnInputStream.skipTag();
        this.error = new NErrorType();
        this.error.readEncoded(asnInputStream);
        asnInputStream.skipTag();
        asnInputStream.skipTag();
        this.firstFailedWriteAttempt = new BBacnetObjectPropertyReference();
        this.firstFailedWriteAttempt.readAsn(asnInputStream);
        asnInputStream.skipTag();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("WritePropertyMultipleError: ");
        stringBuffer.append("\n  errorType:" + this.error.toString());
        stringBuffer.append("\n  firstFailedWriteAttempt:" + this.firstFailedWriteAttempt.toString());
        return stringBuffer.toString();
    }

    public String toUserString() {
        return this.error.toString();
    }

    public WritePropertyMultipleError(NErrorType nErrorType, BBacnetObjectPropertyReference bBacnetObjectPropertyReference) {
        super(16, nErrorType);
        this.firstFailedWriteAttempt = (BBacnetObjectPropertyReference)bBacnetObjectPropertyReference.newCopy();
    }

    public WritePropertyMultipleError(NErrorType nErrorType, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2) {
        super(16, nErrorType);
        this.firstFailedWriteAttempt = new BBacnetObjectPropertyReference(bBacnetObjectIdentifier, n, n2);
    }

    public WritePropertyMultipleError(int n, byte[] byArray) throws AsnException {
        super(n);
        AsnInputStream asnInputStream = new AsnInputStream(byArray);
        this.readEncoded(asnInputStream);
    }
}

