/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.error;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.error.SimpleError;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;

public class CreateObjectError
extends SimpleError {
    public static final int ERROR_TYPE_TAG = 0;
    public static final int FIRST_FAILED_ELEMENT_NUMBER_TAG = 1;
    private long firstFailedElementNumber;

    public long getFirstFailedElementNumber() {
        return this.firstFailedElementNumber;
    }

    public Object[] getErrorParameters() {
        return new Object[]{new Long(this.firstFailedElementNumber)};
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(0);
        this.error.writeEncoded(asnOutputStream);
        asnOutputStream.writeClosingTag(0);
        asnOutputStream.writeUnsignedInteger(1, this.firstFailedElementNumber);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        asnInputStream.skipTag();
        this.error = new NErrorType();
        this.error.readEncoded(asnInputStream);
        asnInputStream.skipTag();
        this.firstFailedElementNumber = asnInputStream.readUnsignedInteger(1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CreateObjectError: ");
        stringBuffer.append("\n  errorType:" + this.error.toString());
        stringBuffer.append("\n  firstFailedElementNumber:" + this.firstFailedElementNumber);
        return stringBuffer.toString();
    }

    public String toUserString() {
        return this.error.toString();
    }

    public CreateObjectError(ErrorType errorType, long l) {
        super(10, errorType);
        this.firstFailedElementNumber = l;
    }

    public CreateObjectError(int n, byte[] byArray) throws AsnException {
        super(n);
        AsnInputStream asnInputStream = new AsnInputStream(byArray);
        this.readEncoded(asnInputStream);
    }
}

