/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BEnum;
import javax.baja.util.ByteArrayUtil;

public class WritePropertyRequest
extends BacnetConfirmedRequest {
    public static final int OBJECT_ID_TAG = 0;
    public static final int PROPERTY_ID_TAG = 1;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 2;
    public static final int PROPERTY_VALUE_TAG = 3;
    public static final int PRIORITY_TAG = 4;
    private BBacnetObjectIdentifier objectId;
    private int propertyId;
    private int propertyArrayIndex;
    private int priority;
    private byte[] encodedValue;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.objectId = bBacnetObjectIdentifier;
    }

    public int getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(BEnum bEnum) {
        this.propertyId = bEnum.getOrdinal();
    }

    public void setPropertyId(int n) {
        this.propertyId = n;
    }

    public boolean isPropertyArrayIndexUsed() {
        boolean bl = false;
        if (this.propertyArrayIndex != -1) {
            bl = true;
        }
        return bl;
    }

    public int getPropertyArrayIndex() {
        return this.propertyArrayIndex;
    }

    public void setPropertyArrayIndex(int n) {
        this.propertyArrayIndex = n;
    }

    public byte[] getEncodedValue() {
        return this.encodedValue;
    }

    public int getPriority() {
        return this.priority;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeObjectIdentifier(0, this.objectId);
        asnOutputStream.writeEnumerated(1, this.propertyId);
        if (this.propertyArrayIndex != -1) {
            asnOutputStream.writeUnsignedInteger(2, this.propertyArrayIndex);
        }
        asnOutputStream.writeEncodedValue(3, this.encodedValue);
        if (this.priority != -1) {
            asnOutputStream.writeUnsignedInteger(4, this.priority);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.propertyArrayIndex = -1;
        this.priority = -1;
        this.objectId = asnInputStream.readObjectIdentifier(0);
        this.propertyId = asnInputStream.readEnumerated(1);
        asnInputStream.peekTag();
        if (asnInputStream.isValueTag(2)) {
            this.propertyArrayIndex = asnInputStream.readUnsignedInt(2);
        }
        this.encodedValue = asnInputStream.readEncodedValue(3);
        asnInputStream.peekTag();
        if (asnInputStream.isValueTag(4)) {
            this.priority = asnInputStream.readUnsignedInt(4);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("WritePropertyRequest: ");
        stringBuffer.append("\n  " + (Object)((Object)this.objectId));
        stringBuffer.append("\n  " + BBacnetPropertyIdentifier.tag(this.propertyId));
        if (this.propertyArrayIndex != -1) {
            stringBuffer.append("[" + this.propertyArrayIndex + ']');
        }
        stringBuffer.append("\n  encodedValue=" + ByteArrayUtil.toHexString((byte[])this.encodedValue));
        if (this.priority != -1) {
            stringBuffer.append("\n  @" + this.priority);
        }
        return stringBuffer.toString();
    }

    public WritePropertyRequest() {
        this(null, -1, -1, null, -1);
    }

    public WritePropertyRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, BEnum bEnum, byte[] byArray) {
        this(bBacnetObjectIdentifier, bEnum.getOrdinal(), -1, byArray, -1);
    }

    public WritePropertyRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, BEnum bEnum, int n, byte[] byArray) {
        this(bBacnetObjectIdentifier, bEnum.getOrdinal(), n, byArray, -1);
    }

    public WritePropertyRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, BEnum bEnum, int n, byte[] byArray, int n2) {
        this(bBacnetObjectIdentifier, bEnum.getOrdinal(), n, byArray, n2);
    }

    public WritePropertyRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) {
        this(bBacnetObjectIdentifier, n, -1, byArray, -1);
    }

    public WritePropertyRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, byte[] byArray) {
        this(bBacnetObjectIdentifier, n, n2, byArray, -1);
    }

    public WritePropertyRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, byte[] byArray, int n3) {
        super(15);
        this.objectId = bBacnetObjectIdentifier;
        this.propertyId = n;
        this.propertyArrayIndex = n2;
        this.encodedValue = byArray;
        this.priority = n3;
    }
}

