/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.sys.BEnum;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ReadRangeRequest
extends BacnetConfirmedRequest
implements RangeReference {
    public static final int OBJECT_ID_TAG = 0;
    public static final int PROPERTY_ID_TAG = 1;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 2;
    public static final int BY_POSITION_TAG = 3;
    public static final int BY_TIME_TAG_DEPRECATED = 4;
    public static final int TIME_RANGE_TAG_DEPRECATED = 5;
    public static final int BY_SEQUENCE_NUMBER_TAG = 6;
    public static final int BY_TIME_TAG = 7;
    private BBacnetObjectIdentifier objectId;
    private int propertyId;
    private int propertyArrayIndex;
    private int rangeType;
    private long referenceIndex;
    private BBacnetDateTime referenceTime;
    private int count;
    private BBacnetDateTime beginningTime;
    private BBacnetDateTime endingTime;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.objectId = bBacnetObjectIdentifier;
    }

    public int getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(BEnum bEnum) {
        this.propertyId = bEnum.getOrdinal();
    }

    public void setPropertyId(int n) {
        this.propertyId = n;
    }

    public boolean isPropertyArrayIndexUsed() {
        boolean bl = false;
        if (this.propertyArrayIndex != -1) {
            bl = true;
        }
        return bl;
    }

    public int getPropertyArrayIndex() {
        return this.propertyArrayIndex;
    }

    public void setPropertyArrayIndex(int n) {
        this.propertyArrayIndex = n;
    }

    public boolean isRangeUsed() {
        boolean bl = false;
        if (this.rangeType != -1) {
            bl = true;
        }
        return bl;
    }

    public int getRangeType() {
        return this.rangeType;
    }

    public long getReferenceIndex() {
        return this.referenceIndex;
    }

    public void setReferenceIndex(long l) {
        this.referenceIndex = l;
    }

    public BBacnetDateTime getReferenceTime() {
        return this.referenceTime;
    }

    public void setReferenceTime(BBacnetDateTime bBacnetDateTime) {
        this.referenceTime = bBacnetDateTime;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public void writeAsn(AsnOutput asnOutput) {
        this.writeEncoded((AsnOutputStream)asnOutput);
    }

    public void readAsn(AsnInput asnInput) throws AsnException {
        this.readEncoded((AsnInputStream)asnInput);
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeObjectIdentifier(0, this.objectId);
        asnOutputStream.writeEnumerated(1, this.propertyId);
        if (this.propertyArrayIndex != -1) {
            asnOutputStream.writeUnsignedInteger(2, this.propertyArrayIndex);
        }
        switch (this.rangeType) {
            case 3: {
                asnOutputStream.writeOpeningTag(this.rangeType);
                asnOutputStream.writeUnsignedInteger(this.referenceIndex);
                asnOutputStream.writeSignedInteger(this.count);
                asnOutputStream.writeClosingTag(this.rangeType);
                break;
            }
            case 4: {
                asnOutputStream.writeOpeningTag(this.rangeType);
                asnOutputStream.writeDate(this.referenceTime.getDate());
                asnOutputStream.writeTime(this.referenceTime.getTime());
                asnOutputStream.writeSignedInteger(this.count);
                asnOutputStream.writeClosingTag(this.rangeType);
                break;
            }
            case 5: {
                asnOutputStream.writeOpeningTag(this.rangeType);
                asnOutputStream.writeDate(this.beginningTime.getDate());
                asnOutputStream.writeTime(this.beginningTime.getTime());
                asnOutputStream.writeDate(this.endingTime.getDate());
                asnOutputStream.writeTime(this.endingTime.getTime());
                asnOutputStream.writeClosingTag(this.rangeType);
                break;
            }
            case 6: {
                asnOutputStream.writeOpeningTag(this.rangeType);
                asnOutputStream.writeUnsignedInteger(this.referenceIndex);
                asnOutputStream.writeSignedInteger(this.count);
                asnOutputStream.writeClosingTag(this.rangeType);
                break;
            }
            case 7: {
                asnOutputStream.writeOpeningTag(this.rangeType);
                this.referenceTime.writeAsn(asnOutputStream);
                asnOutputStream.writeSignedInteger(this.count);
                asnOutputStream.writeClosingTag(this.rangeType);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid range type in ReadRangeRequest:" + this.rangeType);
            }
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.objectId = asnInputStream.readObjectIdentifier(0);
        this.propertyId = asnInputStream.readEnumerated(1);
        asnInputStream.peekTag();
        if (asnInputStream.isValueTag(2)) {
            this.propertyArrayIndex = asnInputStream.readUnsignedInt(2);
            asnInputStream.peekTag();
        } else {
            this.propertyArrayIndex = -1;
        }
        if (asnInputStream.isOpeningTag(3)) {
            this.rangeType = 3;
            asnInputStream.skipTag();
            this.referenceIndex = asnInputStream.readUnsignedInteger();
            this.count = asnInputStream.readSignedInteger();
            asnInputStream.skipTag();
        } else if (asnInputStream.isOpeningTag(4)) {
            this.rangeType = 4;
            asnInputStream.skipTag();
            this.referenceTime = new BBacnetDateTime();
            this.referenceTime.readAsn(asnInputStream);
            this.count = asnInputStream.readSignedInteger();
            asnInputStream.skipTag();
        } else if (asnInputStream.isOpeningTag(5)) {
            this.rangeType = 5;
            asnInputStream.skipTag();
            this.beginningTime = new BBacnetDateTime();
            this.beginningTime.readAsn(asnInputStream);
            this.endingTime = new BBacnetDateTime();
            this.endingTime.readAsn(asnInputStream);
            asnInputStream.skipTag();
        } else if (asnInputStream.isOpeningTag(6)) {
            this.rangeType = 6;
            asnInputStream.skipTag();
            this.referenceIndex = asnInputStream.readUnsignedInteger();
            this.count = asnInputStream.readSignedInteger();
            asnInputStream.skipTag();
        } else if (asnInputStream.isOpeningTag(7)) {
            this.rangeType = 7;
            asnInputStream.skipTag();
            this.referenceTime = new BBacnetDateTime();
            this.referenceTime.readAsn(asnInputStream);
            this.count = asnInputStream.readSignedInteger();
            asnInputStream.skipTag();
        } else {
            this.rangeType = -1;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ReadRangeRequest: ");
        stringBuffer.append("\n  objId  " + (Object)((Object)this.objectId));
        stringBuffer.append("\n  propId " + this.propertyId);
        if (this.propertyArrayIndex != -1) {
            stringBuffer.append("[" + this.propertyArrayIndex + ']');
        }
        stringBuffer.append("\n  rangeType " + this.rangeType);
        switch (this.rangeType) {
            case 3: {
                stringBuffer.append("\n  refNdx(pos) " + this.referenceIndex);
                stringBuffer.append("\n  count       " + this.count);
                break;
            }
            case 4: {
                stringBuffer.append("\n  refTim " + this.referenceTime);
                stringBuffer.append("\n  count  " + this.count);
                break;
            }
            case 5: {
                stringBuffer.append("\n  begTim " + this.beginningTime);
                stringBuffer.append("\n  endTim " + this.endingTime);
                break;
            }
            case 6: {
                stringBuffer.append("\n  refNdx(sqN) " + this.referenceIndex);
                stringBuffer.append("\n  count       " + this.count);
                break;
            }
            case 7: {
                stringBuffer.append("\n  refTim " + this.referenceTime);
                stringBuffer.append("\n  count  " + this.count);
                break;
            }
            case -1: {
                stringBuffer.append("\n  RANGE NOT USED");
                break;
            }
            default: {
                stringBuffer.append("INVALID RANGE TYPE TAG! ");
            }
        }
        return stringBuffer.toString();
    }

    public BacnetServicePrimitive doParseAck(int n, AsnInputStream asnInputStream) throws AsnException {
        return new ReadRangeAck(n, asnInputStream);
    }

    private final /* synthetic */ void this() {
        this.objectId = null;
        this.propertyId = -1;
        this.propertyArrayIndex = -1;
        this.rangeType = -1;
        this.referenceIndex = -1;
        this.referenceTime = null;
        this.count = 0;
        this.beginningTime = null;
        this.endingTime = null;
    }

    public ReadRangeRequest() {
        this(null, -1, -1, -1, -1, null, 0);
    }

    public ReadRangeRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, int n3, long l, int n4) {
        this(bBacnetObjectIdentifier, n, n2, n3, l, null, n4);
    }

    public ReadRangeRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, BBacnetDateTime bBacnetDateTime, int n3) {
        this(bBacnetObjectIdentifier, n, n2, 7, -1, bBacnetDateTime, n3);
    }

    public ReadRangeRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, int n3, long l, BBacnetDateTime bBacnetDateTime, int n4) {
        super(26);
        this.this();
        this.objectId = bBacnetObjectIdentifier;
        this.propertyId = n;
        this.propertyArrayIndex = n2;
        this.rangeType = n3;
        this.referenceIndex = l;
        this.referenceTime = bBacnetDateTime;
        this.count = n4;
    }
}

