/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.confirmed.ReadPropertyAck;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BEnum;

public class ReadPropertyRequest
extends BacnetConfirmedRequest {
    public static final int OBJECT_ID_TAG = 0;
    public static final int PROPERTY_ID_TAG = 1;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 2;
    private BBacnetObjectIdentifier objectId;
    private int propertyId;
    private int propertyArrayIndex;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.objectId = bBacnetObjectIdentifier;
    }

    public int getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(BEnum bEnum) {
        this.propertyId = bEnum.getOrdinal();
    }

    public void setPropertyId(int n) {
        this.propertyId = n;
    }

    public boolean isPropertyArrayIndexUsed() {
        boolean bl = false;
        if (this.propertyArrayIndex != -1) {
            bl = true;
        }
        return bl;
    }

    public int getPropertyArrayIndex() {
        return this.propertyArrayIndex;
    }

    public void setPropertyArrayIndex(int n) {
        this.propertyArrayIndex = n;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeObjectIdentifier(0, this.objectId);
        asnOutputStream.writeEnumerated(1, this.propertyId);
        if (this.propertyArrayIndex != -1) {
            asnOutputStream.writeUnsignedInteger(2, this.propertyArrayIndex);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.objectId = asnInputStream.readObjectIdentifier(0);
        this.propertyId = asnInputStream.readEnumerated(1);
        if (asnInputStream.peekTag() != -1) {
            if (asnInputStream.isValueTag(2)) {
                this.propertyArrayIndex = asnInputStream.readUnsignedInt(2);
            } else {
                throw new AsnException("Invalid tag: " + asnInputStream.peekTag());
            }
        }
        if (asnInputStream.peekTag() != -1) {
            throw new AsnException("Invalid tag: " + asnInputStream.peekTag());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ReadPropertyRequest: ");
        stringBuffer.append("\n  " + (Object)((Object)this.objectId));
        stringBuffer.append("\n  " + BBacnetPropertyIdentifier.tag(this.propertyId));
        if (this.propertyArrayIndex != -1) {
            stringBuffer.append("[" + this.propertyArrayIndex + ']');
        }
        return stringBuffer.toString();
    }

    public BacnetServicePrimitive doParseAck(int n, AsnInputStream asnInputStream) throws AsnException {
        return new ReadPropertyAck(n, asnInputStream);
    }

    public ReadPropertyRequest() {
        this(null, -1, -1);
    }

    public ReadPropertyRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n) {
        this(bBacnetObjectIdentifier, n, -1);
    }

    public ReadPropertyRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2) {
        super(12);
        this.objectId = bBacnetObjectIdentifier;
        this.propertyId = n;
        this.propertyArrayIndex = n2;
    }
}

