/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetComplexAck;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BEnum;

public class ReadPropertyAck
extends BacnetComplexAck {
    public static final int OBJECT_ID_TAG = 0;
    public static final int PROPERTY_ID_TAG = 1;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 2;
    public static final int PROPERTY_VALUE_TAG = 3;
    private BBacnetObjectIdentifier objectId;
    private int propertyId;
    private int propertyArrayIndex;
    private byte[] encodedValue;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.objectId = bBacnetObjectIdentifier;
    }

    public byte[] getEncodedValue() {
        return this.encodedValue;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeObjectIdentifier(0, this.objectId);
        asnOutputStream.writeEnumerated(1, this.propertyId);
        if (this.propertyArrayIndex != -1) {
            asnOutputStream.writeUnsignedInteger(2, this.propertyArrayIndex);
        }
        asnOutputStream.writeEncodedValue(3, this.encodedValue);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.objectId = asnInputStream.readObjectIdentifier(0);
        this.propertyId = asnInputStream.readEnumerated(1);
        asnInputStream.peekTag();
        this.propertyArrayIndex = asnInputStream.isValueTag(2) ? asnInputStream.readUnsignedInt(2) : -1;
        this.encodedValue = asnInputStream.readEncodedValue(3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ReadPropertyACK: ");
        stringBuffer.append("\n  " + (Object)((Object)this.objectId));
        stringBuffer.append("\n  " + BBacnetPropertyIdentifier.tag(this.propertyId));
        if (this.propertyArrayIndex != -1) {
            stringBuffer.append("[" + this.propertyArrayIndex + ']');
        }
        return stringBuffer.toString();
    }

    public ReadPropertyAck() {
        super(12);
    }

    public ReadPropertyAck(BBacnetObjectIdentifier bBacnetObjectIdentifier, BEnum bEnum, byte[] byArray) {
        this(bBacnetObjectIdentifier, bEnum.getOrdinal(), -1, byArray);
    }

    public ReadPropertyAck(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) {
        this(bBacnetObjectIdentifier, n, -1, byArray);
    }

    public ReadPropertyAck(BBacnetObjectIdentifier bBacnetObjectIdentifier, BEnum bEnum, int n, byte[] byArray) {
        this(bBacnetObjectIdentifier, bEnum.getOrdinal(), n, byArray);
    }

    public ReadPropertyAck(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, byte[] byArray) {
        super(12);
        this.objectId = bBacnetObjectIdentifier;
        this.propertyId = n;
        this.propertyArrayIndex = n2;
        this.encodedValue = byArray;
    }

    public ReadPropertyAck(int n, AsnInputStream asnInputStream) throws AsnException {
        super(n);
        this.readEncoded(asnInputStream);
    }
}

