/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetError;
import com.tridium.bacnet.services.error.NChangeListError;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.RejectException;
import javax.baja.util.ByteArrayUtil;

public abstract class ListElementRequest
extends BacnetConfirmedRequest {
    public static final int OBJECT_ID_TAG = 0;
    public static final int PROPERTY_ID_TAG = 1;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 2;
    public static final int LIST_OF_ELEMENTS_TAG = 3;
    private BBacnetObjectIdentifier objectId;
    private int propertyId;
    private int propertyArrayIndex;
    private byte[] listOfElements;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.objectId = bBacnetObjectIdentifier;
    }

    public int getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(int n) {
        this.propertyId = n;
    }

    public boolean isPropertyArrayIndexUsed() {
        boolean bl = false;
        if (this.propertyArrayIndex != -1) {
            bl = true;
        }
        return bl;
    }

    public int getPropertyArrayIndex() {
        return this.propertyArrayIndex;
    }

    public void setPropertyArrayIndex(int n) {
        this.propertyArrayIndex = n;
    }

    public byte[] getListOfElements() {
        return this.listOfElements;
    }

    public void setListOfElements(byte[] byArray) {
        this.listOfElements = byArray;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeObjectIdentifier(0, this.objectId);
        asnOutputStream.writeEnumerated(1, this.propertyId);
        if (this.propertyArrayIndex != -1) {
            asnOutputStream.writeUnsignedInteger(2, this.propertyArrayIndex);
        }
        asnOutputStream.writeEncodedValue(3, this.listOfElements);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException, RejectException {
        this.objectId = asnInputStream.readObjectIdentifier(0);
        this.propertyId = asnInputStream.readEnumerated(1);
        asnInputStream.peekTag();
        this.propertyArrayIndex = asnInputStream.isValueTag(2) ? asnInputStream.readUnsignedInt(2) : -1;
        this.listOfElements = asnInputStream.readEncodedValue(3);
    }

    public BacnetError doParseError(int n, byte[] byArray) throws AsnException {
        return new NChangeListError(n, byArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BacnetConfirmedServiceChoice.TAGS[this.getServiceChoice()] + ':');
        stringBuffer.append("\n  " + (Object)((Object)this.objectId));
        stringBuffer.append("\n  " + BBacnetPropertyIdentifier.tag(this.propertyId));
        if (this.propertyArrayIndex != -1) {
            stringBuffer.append("[" + this.propertyArrayIndex + ']');
        }
        stringBuffer.append("\n  " + ByteArrayUtil.toHexString((byte[])this.listOfElements));
        return stringBuffer.toString();
    }

    protected ListElementRequest(int n, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n2, int n3, byte[] byArray) {
        super(n);
        this.objectId = bBacnetObjectIdentifier;
        this.propertyId = n2;
        this.propertyArrayIndex = n3;
        this.listOfElements = byArray;
    }
}

