/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NEventSummary;
import com.tridium.bacnet.services.BacnetComplexAck;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.baja.bacnet.io.AsnException;

public class GetEventInformationAck
extends BacnetComplexAck {
    public static final int LIST_OF_EVENT_SUMMARIES_TAG = 0;
    public static final int MORE_EVENTS_TAG = 1;
    private Vector listOfEventSummaries;
    private boolean moreEvents;

    public void addEventSummary(NEventSummary nEventSummary) {
        this.listOfEventSummaries.addElement(nEventSummary);
    }

    public ListIterator getEventSummaries() {
        return this.listOfEventSummaries.listIterator();
    }

    public Vector getListOfEventSummaries() {
        return this.listOfEventSummaries;
    }

    public boolean isMoreEvents() {
        return this.moreEvents;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(0);
        Iterator iterator = this.listOfEventSummaries.iterator();
        while (iterator.hasNext()) {
            NEventSummary nEventSummary = (NEventSummary)iterator.next();
            nEventSummary.writeAsn(asnOutputStream);
        }
        asnOutputStream.writeClosingTag(0);
        asnOutputStream.writeBoolean(1, this.moreEvents);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        asnInputStream.skipTag();
        if (!asnInputStream.isOpeningTag(0)) {
            throw new AsnException("Expected opening tag");
        }
        int n = asnInputStream.peekTag();
        while (!asnInputStream.isClosingTag(0)) {
            if (n == -1) {
                throw new AsnException("No closing tag");
            }
            NEventSummary nEventSummary = new NEventSummary();
            nEventSummary.readAsn(asnInputStream);
            this.listOfEventSummaries.addElement(nEventSummary);
            n = asnInputStream.peekTag();
        }
        asnInputStream.skipTag();
        this.moreEvents = asnInputStream.readBoolean(1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("GetEventInformationAck: ");
        Iterator iterator = this.listOfEventSummaries.iterator();
        while (iterator.hasNext()) {
            NEventSummary nEventSummary = (NEventSummary)iterator.next();
            stringBuffer.append(nEventSummary.toString());
        }
        stringBuffer.append("\n  moreEvents: " + this.moreEvents);
        return stringBuffer.toString();
    }

    public GetEventInformationAck() {
        super(29);
        this.listOfEventSummaries = new Vector();
    }

    public GetEventInformationAck(Vector vector, boolean bl) {
        super(29);
        this.listOfEventSummaries = vector;
        this.moreEvents = bl;
    }

    public GetEventInformationAck(int n, AsnInputStream asnInputStream) throws AsnException {
        super(n);
        this.listOfEventSummaries = new Vector();
        this.readEncoded(asnInputStream);
    }
}

