/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetError;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.confirmed.CreateObjectAck;
import com.tridium.bacnet.services.error.CreateObjectError;
import java.util.ListIterator;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RejectException;
import javax.baja.nre.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CreateObjectRequest
extends BacnetConfirmedRequest {
    public static final int OBJECT_SPECIFIER_TAG = 0;
    public static final int OBJECT_TYPE_TAG = 0;
    public static final int OBJECT_ID_TAG = 1;
    public static final int LIST_OF_INITIAL_VALUES_TAG = 1;
    int objectType;
    BBacnetObjectIdentifier objectId;
    private Array listOfInitialValues;
    static /* synthetic */ Class class$javax$baja$bacnet$io$PropertyValue;

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException, RejectException {
        int n = asnInputStream.peekTag();
        if (!asnInputStream.isOpeningTag(0)) {
            throw new RejectException(4);
        }
        asnInputStream.skipTag();
        n = asnInputStream.peekTag();
        if (n == 0) {
            this.objectType = asnInputStream.readEnumerated(0);
        } else if (n == 1) {
            this.objectId = asnInputStream.readObjectIdentifier(1);
        } else {
            throw new RejectException(4);
        }
        asnInputStream.skipTag();
        n = asnInputStream.peekTag();
        if (n == -1) {
            return;
        }
        if (!asnInputStream.isOpeningTag(1)) {
            throw new RejectException(4);
        }
        asnInputStream.skipTag();
        n = asnInputStream.peekTag();
        while (!asnInputStream.isClosingTag(1)) {
            if (n == -1) {
                throw new RejectException(4);
            }
            NBacnetPropertyValue nBacnetPropertyValue = new NBacnetPropertyValue();
            nBacnetPropertyValue.readAsn(asnInputStream);
            this.listOfInitialValues.add((Object)nBacnetPropertyValue);
            n = asnInputStream.peekTag();
        }
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(0);
        if (this.objectId == null) {
            asnOutputStream.writeEnumerated(0, this.objectType);
        } else {
            asnOutputStream.writeObjectIdentifier(1, this.objectId);
        }
        asnOutputStream.writeClosingTag(0);
        if (this.listOfInitialValues != null && this.listOfInitialValues.size() > 0) {
            asnOutputStream.writeOpeningTag(1);
            ListIterator listIterator = this.listOfInitialValues.iterator();
            while (listIterator.hasNext()) {
                PropertyValue propertyValue = (PropertyValue)listIterator.next();
                propertyValue.writeAsn(asnOutputStream);
            }
            asnOutputStream.writeClosingTag(1);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CreateObjectRequest: ");
        if (this.objectId == null) {
            stringBuffer.append("\n  " + BBacnetObjectType.tag(this.objectType));
        } else {
            stringBuffer.append("\n  " + (Object)((Object)this.objectId));
        }
        ListIterator listIterator = this.listOfInitialValues.iterator();
        while (listIterator.hasNext()) {
            stringBuffer.append("\n  " + listIterator.next().toString());
        }
        return stringBuffer.toString();
    }

    public BacnetServicePrimitive doParseAck(int n, AsnInputStream asnInputStream) throws AsnException {
        return new CreateObjectAck(n, asnInputStream);
    }

    protected BacnetError doParseError(int n, byte[] byArray) throws AsnException {
        return new CreateObjectError(n, byArray);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.objectId = null;
        this.listOfInitialValues = null;
    }

    public CreateObjectRequest() {
        super(10);
        this.this();
        Class clazz = class$javax$baja$bacnet$io$PropertyValue;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$io$PropertyValue = CreateObjectRequest.class("[Ljavax.baja.bacnet.io.PropertyValue;", false);
        }
        this.listOfInitialValues = new Array(clazz);
    }

    public CreateObjectRequest(int n) {
        super(10);
        this.this();
        this.objectType = n;
        this.listOfInitialValues = null;
    }

    public CreateObjectRequest(int n, Array array) {
        super(10);
        this.this();
        this.objectType = n;
        this.listOfInitialValues = array;
    }

    public CreateObjectRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        super(10);
        this.this();
        this.objectId = bBacnetObjectIdentifier;
        this.listOfInitialValues = null;
    }

    public CreateObjectRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, Array array) {
        super(10);
        this.this();
        this.objectId = bBacnetObjectIdentifier;
        this.listOfInitialValues = array;
    }
}

