/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetError;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.confirmed.ConfirmedPrivateTransferAck;
import com.tridium.bacnet.services.error.ConfirmedPrivateTransferError;
import javax.baja.bacnet.io.AsnException;
import javax.baja.util.ByteArrayUtil;

public class ConfirmedPrivateTransferRequest
extends BacnetConfirmedRequest {
    public static final int VENDOR_ID_TAG = 0;
    public static final int SERVICE_NUMBER_TAG = 1;
    public static final int SERVICE_PARAMETERS_TAG = 2;
    private long vendorId;
    private long serviceNumber;
    private byte[] serviceParameters;

    public long getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(long l) {
        this.vendorId = l;
    }

    public long getServiceNumber() {
        return this.serviceNumber;
    }

    public void setServiceNumber(long l) {
        this.serviceNumber = l;
    }

    public byte[] getServiceParameters() {
        return this.serviceParameters;
    }

    public void setServiceParameters(byte[] byArray) {
        this.serviceParameters = byArray;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeUnsignedInteger(0, this.vendorId);
        asnOutputStream.writeUnsignedInteger(1, this.serviceNumber);
        if (this.serviceParameters != null && this.serviceParameters.length > 0) {
            asnOutputStream.writeEncodedValue(2, this.serviceParameters);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.vendorId = asnInputStream.readUnsignedInteger(0);
        this.serviceNumber = asnInputStream.readUnsignedInteger(1);
        asnInputStream.peekTag();
        if (asnInputStream.isOpeningTag(2)) {
            this.serviceParameters = asnInputStream.readEncodedValue(2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ConfirmedPrivateTransferRequest: ");
        stringBuffer.append("\n  vId=" + this.vendorId);
        stringBuffer.append("\n  svc#=" + this.serviceNumber);
        if (this.serviceParameters != null && this.serviceParameters.length > 0) {
            stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.serviceParameters));
        }
        return stringBuffer.toString();
    }

    public BacnetServicePrimitive doParseAck(int n, AsnInputStream asnInputStream) throws AsnException {
        return new ConfirmedPrivateTransferAck(n, asnInputStream);
    }

    protected BacnetError doParseError(int n, byte[] byArray) throws AsnException {
        return new ConfirmedPrivateTransferError(n, byArray);
    }

    public ConfirmedPrivateTransferRequest() {
        this(-1, -1, null);
    }

    public ConfirmedPrivateTransferRequest(long l, long l2) {
        this(l, l2, null);
    }

    public ConfirmedPrivateTransferRequest(long l, long l2, byte[] byArray) {
        super(18);
        this.vendorId = l;
        this.serviceNumber = l2;
        this.serviceParameters = byArray;
    }
}

