/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.confirmed.AtomicWriteFileAck;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.FileData;
import javax.baja.bacnet.io.RejectException;

public class AtomicWriteFileRequest
extends BacnetConfirmedRequest
implements FileData {
    public static final int STREAM_ACCESS_TAG = 0;
    public static final int RECORD_ACCESS_TAG = 1;
    private BBacnetObjectIdentifier fileId;
    private int accessMethod;
    private int start;
    private long count;
    private byte[] fileData;
    private BBacnetOctetString[] fileRecordData;

    public boolean isEndOfFile() {
        return false;
    }

    public int getAccessMethod() {
        return this.accessMethod;
    }

    public int getFileStart() {
        return this.start;
    }

    public long getRecordCount() {
        if (!this.isStreamAccess()) {
            return this.count;
        }
        throw new IllegalStateException("Not Record Access");
    }

    public byte[] getFileData() {
        if (this.isStreamAccess()) {
            return this.fileData;
        }
        throw new IllegalStateException("Not Stream Access");
    }

    public BBacnetOctetString[] getFileRecordData() {
        if (!this.isStreamAccess()) {
            return this.fileRecordData;
        }
        throw new IllegalStateException("Not Record Access");
    }

    public BBacnetObjectIdentifier getFileId() {
        return this.fileId;
    }

    public void setFileId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.fileId = bBacnetObjectIdentifier;
    }

    public boolean isStreamAccess() {
        boolean bl = false;
        if (this.accessMethod == 0) {
            bl = true;
        }
        return bl;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeObjectIdentifier(this.fileId);
        if (this.isStreamAccess()) {
            asnOutputStream.writeOpeningTag(0);
            asnOutputStream.writeSignedInteger(this.start);
            asnOutputStream.writeOctetString(this.fileData);
            asnOutputStream.writeClosingTag(0);
        } else {
            asnOutputStream.writeOpeningTag(1);
            asnOutputStream.writeSignedInteger(this.start);
            asnOutputStream.writeUnsignedInteger(this.count);
            int n = 0;
            while ((long)n < this.count) {
                asnOutputStream.writeOctetString(this.fileRecordData[n].getBytes());
                ++n;
            }
            asnOutputStream.writeClosingTag(1);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException, RejectException {
        this.fileId = asnInputStream.readObjectIdentifier();
        asnInputStream.peekTag();
        if (asnInputStream.isOpeningTag(0)) {
            this.accessMethod = 0;
            asnInputStream.skipTag();
            this.start = asnInputStream.readSignedInteger();
            this.fileData = asnInputStream.readOctetString();
            asnInputStream.skipTag();
        } else {
            this.accessMethod = 1;
            asnInputStream.skipTag();
            this.start = asnInputStream.readSignedInteger();
            this.count = asnInputStream.readUnsignedInteger();
            if (this.count > Integer.MAX_VALUE) {
                throw new RejectException(6);
            }
            this.fileRecordData = new BBacnetOctetString[(int)this.count];
            int n = 0;
            while ((long)n < this.count) {
                this.fileRecordData[n] = asnInputStream.readBacnetOctetString();
                ++n;
            }
            asnInputStream.skipTag();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AtomicWriteFileRequest: ");
        stringBuffer.append("\n  " + (Object)((Object)this.fileId));
        stringBuffer.append("\n  access method:" + this.accessMethod);
        stringBuffer.append("\n  start:" + this.start);
        if (this.isStreamAccess()) {
            stringBuffer.append("\n  data length=" + this.fileData.length);
        } else {
            stringBuffer.append("\n  record count=" + this.count);
        }
        return stringBuffer.toString();
    }

    public BacnetServicePrimitive doParseAck(int n, AsnInputStream asnInputStream) throws AsnException {
        return new AtomicWriteFileAck(n, asnInputStream);
    }

    public AtomicWriteFileRequest() {
        super(7);
    }

    public AtomicWriteFileRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) {
        super(7);
        this.accessMethod = 0;
        this.fileId = bBacnetObjectIdentifier;
        this.start = n;
        if (byArray == null) {
            throw new IllegalArgumentException("fileData is null!");
        }
        this.fileData = byArray;
    }

    public AtomicWriteFileRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, long l, BBacnetOctetString[] bBacnetOctetStringArray) {
        super(7);
        this.accessMethod = 1;
        this.fileId = bBacnetObjectIdentifier;
        this.start = n;
        this.count = l;
        if (bBacnetOctetStringArray == null) {
            throw new IllegalArgumentException("fileRecordData is null!");
        }
        if ((long)this.start + this.count > (long)bBacnetOctetStringArray.length) {
            throw new IllegalArgumentException("start '" + this.start + "' and count '" + this.count + "' exceed end of record data (length " + bBacnetOctetStringArray.length);
        }
        this.fileRecordData = bBacnetOctetStringArray;
    }
}

