/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetComplexAck;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.FileData;

public class AtomicReadFileAck
extends BacnetComplexAck
implements FileData {
    public static final int STREAM_ACCESS_TAG = 0;
    public static final int RECORD_ACCESS_TAG = 1;
    private boolean endOfFile;
    private int accessMethod;
    private int fileStartPosition;
    private byte[] fileData;
    private int fileStartRecord;
    private long returnedRecordCount;
    private BBacnetOctetString[] fileRecordData;

    public boolean isEndOfFile() {
        return this.endOfFile;
    }

    public int getAccessMethod() {
        return this.accessMethod;
    }

    public int getFileStart() {
        return this.fileStartPosition;
    }

    public long getRecordCount() {
        if (!this.isStreamAccess()) {
            return this.returnedRecordCount;
        }
        throw new IllegalStateException("Not Record Access");
    }

    public byte[] getFileData() {
        if (this.isStreamAccess()) {
            return this.fileData;
        }
        throw new IllegalStateException("Not Stream Access");
    }

    public BBacnetOctetString[] getFileRecordData() {
        if (!this.isStreamAccess()) {
            return this.fileRecordData;
        }
        throw new IllegalStateException("Not Record Access");
    }

    public boolean isStreamAccess() {
        boolean bl = false;
        if (this.accessMethod == 0) {
            bl = true;
        }
        return bl;
    }

    public void setFileData(byte[] byArray) {
        this.fileData = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.fileData, 0, byArray.length);
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeBoolean(this.endOfFile);
        if (this.isStreamAccess()) {
            asnOutputStream.writeOpeningTag(0);
            asnOutputStream.writeSignedInteger(this.fileStartPosition);
            asnOutputStream.writeOctetString(this.fileData);
            asnOutputStream.writeClosingTag(0);
        } else {
            asnOutputStream.writeOpeningTag(1);
            asnOutputStream.writeSignedInteger(this.fileStartRecord);
            asnOutputStream.writeUnsignedInteger(this.returnedRecordCount);
            int n = 0;
            while (n < this.fileRecordData.length) {
                asnOutputStream.writeOctetString(this.fileRecordData[n].getBytes());
                ++n;
            }
            asnOutputStream.writeClosingTag(1);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.endOfFile = asnInputStream.readBoolean();
        int n = asnInputStream.peekTag();
        if (asnInputStream.isOpeningTag(0)) {
            this.accessMethod = 0;
            asnInputStream.skipTag();
            this.fileStartPosition = asnInputStream.readSignedInteger();
            this.fileData = asnInputStream.readOctetString();
            asnInputStream.skipTag();
        } else if (asnInputStream.isOpeningTag(1)) {
            this.accessMethod = 1;
            asnInputStream.skipTag();
            this.fileStartRecord = asnInputStream.readSignedInteger();
            this.returnedRecordCount = asnInputStream.readUnsignedInteger();
            Vector<BBacnetOctetString> vector = new Vector<BBacnetOctetString>();
            while (asnInputStream.peekTag() != -1) {
                if (asnInputStream.isClosingTag(1)) break;
                vector.addElement(BBacnetOctetString.make(asnInputStream.readOctetString()));
            }
            this.fileRecordData = new BBacnetOctetString[vector.size()];
            vector.copyInto((Object[])this.fileRecordData);
            asnInputStream.skipTag();
        } else {
            throw new AsnException("Invalid tag: " + n);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AtomicReadFileACK: ");
        stringBuffer.append("\n  " + this.endOfFile);
        stringBuffer.append("\n  access method:" + this.accessMethod);
        if (this.accessMethod == 0) {
            stringBuffer.append("\n  " + this.fileStartPosition);
            stringBuffer.append("\n  length=" + this.fileData.length);
        } else {
            stringBuffer.append("\n  " + this.fileStartRecord);
            stringBuffer.append("\n  records=" + this.returnedRecordCount);
        }
        return stringBuffer.toString();
    }

    public AtomicReadFileAck() {
        super(6);
    }

    public AtomicReadFileAck(boolean bl, int n, byte[] byArray) {
        super(6);
        this.accessMethod = 0;
        this.endOfFile = bl;
        this.fileStartPosition = n;
        this.fileData = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.fileData, 0, byArray.length);
    }

    public AtomicReadFileAck(int n, AsnInputStream asnInputStream) throws AsnException {
        super(n);
        this.readEncoded(asnInputStream);
    }
}

