/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.services.BacnetError;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetSimpleAck;
import com.tridium.bacnet.services.confirmed.AcknowledgeAlarmRequest;
import com.tridium.bacnet.services.confirmed.AddListElementRequest;
import com.tridium.bacnet.services.confirmed.AtomicReadFileRequest;
import com.tridium.bacnet.services.confirmed.AtomicWriteFileRequest;
import com.tridium.bacnet.services.confirmed.ConfirmedCovNotificationRequest;
import com.tridium.bacnet.services.confirmed.ConfirmedEventNotificationRequest;
import com.tridium.bacnet.services.confirmed.ConfirmedPrivateTransferRequest;
import com.tridium.bacnet.services.confirmed.CreateObjectRequest;
import com.tridium.bacnet.services.confirmed.DeleteObjectRequest;
import com.tridium.bacnet.services.confirmed.DeviceCommunicationControlRequest;
import com.tridium.bacnet.services.confirmed.GetAlarmSummaryRequest;
import com.tridium.bacnet.services.confirmed.GetEnrollmentSummaryRequest;
import com.tridium.bacnet.services.confirmed.GetEventInformationRequest;
import com.tridium.bacnet.services.confirmed.ReadPropertyMultipleRequest;
import com.tridium.bacnet.services.confirmed.ReadPropertyRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeRequest;
import com.tridium.bacnet.services.confirmed.ReinitializeDeviceRequest;
import com.tridium.bacnet.services.confirmed.RemoveListElementRequest;
import com.tridium.bacnet.services.confirmed.SubscribeCovPropertyRequest;
import com.tridium.bacnet.services.confirmed.SubscribeCovRequest;
import com.tridium.bacnet.services.confirmed.WritePropertyMultipleRequest;
import com.tridium.bacnet.services.confirmed.WritePropertyRequest;
import com.tridium.bacnet.services.error.SimpleError;
import com.tridium.bacnet.stack.transport.ConfirmedRequestPdu;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.RejectException;
import javax.baja.log.Log;
import javax.baja.sys.InvalidEnumException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BacnetConfirmedRequest
extends BacnetServicePrimitive
implements BacnetConfirmedServiceChoice {
    public static final int RESPONSE_MAX_TRANSPORT_BYTES = 4;
    public static final int MAX_TRANSPORT_BYTES = 6;
    protected int maxDataLength;
    protected int maxDataLengthNoSeg;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final BacnetConfirmedRequest parseAPDU(ConfirmedRequestPdu confirmedRequestPdu) throws RejectException {
        BacnetConfirmedRequest bacnetConfirmedRequest = BacnetConfirmedRequest.decodeServiceChoice(confirmedRequestPdu.getServiceChoice());
        try {
            AsnInputStream asnInputStream = AsnInputStream.make(confirmedRequestPdu.getServiceRequest());
            try {
                bacnetConfirmedRequest.readEncoded(asnInputStream);
                BacnetConfirmedRequest.determineMaxDataLength(confirmedRequestPdu, bacnetConfirmedRequest);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                asnInputStream.release();
                throw throwable;
            }
            {
                Object var4_7 = null;
                asnInputStream.release();
                return bacnetConfirmedRequest;
            }
        }
        catch (AsnException asnException) {
            if (!Log.getLog((String)"bacnet.asn").isTraceOn()) throw new RejectException(4);
            asnException.printStackTrace();
            throw new RejectException(4);
        }
        catch (InvalidEnumException invalidEnumException) {
            if (!Log.getLog((String)"bacnet.asn").isTraceOn()) throw new RejectException(8);
            invalidEnumException.printStackTrace();
            throw new RejectException(8);
        }
    }

    private static final BacnetConfirmedRequest decodeServiceChoice(int n) throws RejectException {
        switch (n) {
            case 0: {
                return new AcknowledgeAlarmRequest();
            }
            case 1: {
                return new ConfirmedCovNotificationRequest();
            }
            case 2: {
                return new ConfirmedEventNotificationRequest();
            }
            case 3: {
                return new GetAlarmSummaryRequest();
            }
            case 4: {
                return new GetEnrollmentSummaryRequest();
            }
            case 29: {
                return new GetEventInformationRequest();
            }
            case 5: {
                return new SubscribeCovRequest();
            }
            case 28: {
                return new SubscribeCovPropertyRequest();
            }
            case 6: {
                return new AtomicReadFileRequest();
            }
            case 7: {
                return new AtomicWriteFileRequest();
            }
            case 8: {
                return new AddListElementRequest();
            }
            case 9: {
                return new RemoveListElementRequest();
            }
            case 10: {
                return new CreateObjectRequest();
            }
            case 11: {
                return new DeleteObjectRequest();
            }
            case 12: {
                return new ReadPropertyRequest();
            }
            case 14: {
                return new ReadPropertyMultipleRequest();
            }
            case 26: {
                return new ReadRangeRequest();
            }
            case 15: {
                return new WritePropertyRequest();
            }
            case 16: {
                return new WritePropertyMultipleRequest();
            }
            case 17: {
                return new DeviceCommunicationControlRequest();
            }
            case 18: {
                return new ConfirmedPrivateTransferRequest();
            }
            case 20: {
                return new ReinitializeDeviceRequest();
            }
        }
        throw new RejectException(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BacnetServicePrimitive parseAck(int n, byte[] byArray) throws AsnException {
        if (byArray == null) {
            return new BacnetSimpleAck(n);
        }
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BacnetServicePrimitive bacnetServicePrimitive = this.doParseAck(n, asnInputStream);
            Object var5_5 = null;
            asnInputStream.release();
            return bacnetServicePrimitive;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    protected BacnetServicePrimitive doParseAck(int n, AsnInputStream asnInputStream) throws AsnException {
        return new BacnetSimpleAck(n);
    }

    public final BacnetError parseError(int n, byte[] byArray) throws AsnException {
        return this.doParseError(n, byArray);
    }

    protected BacnetError doParseError(int n, byte[] byArray) throws AsnException {
        return new SimpleError(n, byArray);
    }

    protected static void determineMaxDataLength(ConfirmedRequestPdu confirmedRequestPdu, BacnetConfirmedRequest bacnetConfirmedRequest) {
        int n = Math.min(confirmedRequestPdu.getMaxAPDULengthAccepted(), BBacnetNetwork.localDevice().getMaxAPDULengthAccepted());
        bacnetConfirmedRequest.maxDataLengthNoSeg = n - 4;
        bacnetConfirmedRequest.maxDataLength = n - 4;
        if (!confirmedRequestPdu.isSegmentedResponseAccepted()) {
            return;
        }
        int n2 = confirmedRequestPdu.getMaxSegmentsAccepted();
        if (n2 < 0) {
            bacnetConfirmedRequest.maxDataLength = -1;
        } else {
            if (n2 == 0) {
                return;
            }
            bacnetConfirmedRequest.maxDataLength = n2 * bacnetConfirmedRequest.maxDataLengthNoSeg;
        }
    }

    public int getMaxDataLength() {
        return this.maxDataLength;
    }

    private final /* synthetic */ void this() {
        this.maxDataLength = -1;
        this.maxDataLengthNoSeg = -1;
    }

    protected BacnetConfirmedRequest(int n) {
        super(0, n);
        this.this();
    }
}

