/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.schedule;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BBacnetScheduleTypeChangeJob;
import com.tridium.bacnet.schedule.BBacnetChangeTypeParm;
import com.tridium.bacnet.schedule.BBacnetScheduleDeviceExt;
import com.tridium.bacnet.schedule.ScheduleSupport0;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BCustomSchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.schedule.driver.BScheduleDeviceExt;
import javax.baja.schedule.driver.BScheduleExport;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetScheduleExport
extends BScheduleExport {
    public static final Property supervisorId = BBacnetScheduleExport.newProperty((int)5, (String)"", null);
    public static final Property subordinateVersion = BBacnetScheduleExport.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    private static final BEnumRange ENUM_DATA_TYPE_RANGE = BEnumRange.make((String[])new String[]{AsnUtil.getAsnTypeName(2), AsnUtil.getAsnTypeName(9), AsnUtil.getAsnTypeName(3)});
    public static final Property supervisorOrd = BBacnetScheduleExport.newProperty((int)0, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (String)"schedule:AbstractSchedule"));
    public static final Property objectId = BBacnetScheduleExport.newProperty((int)0, (BValue)BBacnetObjectIdentifier.make(17), (BFacets)ScheduleSupport0.SCHEDULE_CALENDAR_OBJECT_ID_FACETS);
    public static final Property dataType = BBacnetScheduleExport.newProperty((int)1, (String)"", null);
    public static final Property priorityForWriting = BBacnetScheduleExport.newProperty((int)0, (int)16, (BFacets)BFacets.makeInt((int)1, (int)16));
    public static final Property skipWrites = BBacnetScheduleExport.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Property writeEnumAs = BBacnetScheduleExport.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)ENUM_DATA_TYPE_RANGE), null);
    public static final Property outOfService = BBacnetScheduleExport.newProperty((int)0, (boolean)false, null);
    public static final Action readFromDevice = BBacnetScheduleExport.newAction((int)16, null);
    public static final Action readChangeTypeParams = BBacnetScheduleExport.newAction((int)4, null);
    public static final Action changeType = BBacnetScheduleExport.newAction((int)4, (BValue)new BBacnetChangeTypeParm(), null);
    public static final Type TYPE;
    private static final Lexicon lex;
    private static final Log log;
    private int asnType;
    BEnum writeProperty;
    static /* synthetic */ Class class$com$tridium$bacnet$schedule$BBacnetScheduleExport;
    static /* synthetic */ Class class$javax$baja$schedule$BTimeSchedule;

    public BOrd getSupervisorOrd() {
        return (BOrd)this.get(supervisorOrd);
    }

    public void setSupervisorOrd(BOrd bOrd) {
        this.set(supervisorOrd, (BValue)bOrd, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public String getDataType() {
        return this.getString(dataType);
    }

    public void setDataType(String string) {
        this.setString(dataType, string, null);
    }

    public int getPriorityForWriting() {
        return this.getInt(priorityForWriting);
    }

    public void setPriorityForWriting(int n) {
        this.setInt(priorityForWriting, n, null);
    }

    public BFacets getSkipWrites() {
        return (BFacets)this.get(skipWrites);
    }

    public void setSkipWrites(BFacets bFacets) {
        this.set(skipWrites, (BValue)bFacets, null);
    }

    public BEnum getWriteEnumAs() {
        return (BEnum)this.get(writeEnumAs);
    }

    public void setWriteEnumAs(BEnum bEnum) {
        this.set(writeEnumAs, (BValue)bEnum, null);
    }

    public boolean getOutOfService() {
        return this.getBoolean(outOfService);
    }

    public void setOutOfService(boolean bl) {
        this.setBoolean(outOfService, bl, null);
    }

    public void readFromDevice() {
        this.invoke(readFromDevice, null, null);
    }

    public BBacnetChangeTypeParm readChangeTypeParams() {
        return (BBacnetChangeTypeParm)this.invoke(readChangeTypeParams, null, null);
    }

    public BOrd changeType(BBacnetChangeTypeParm bBacnetChangeTypeParm) {
        return (BOrd)this.invoke(changeType, (BValue)bBacnetChangeTypeParm, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setAsnType();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals((Object)supervisorOrd)) {
            this.setSupervisorId(this.getSupervisorOrd().toString());
            this.setDataType("");
        }
        if (property.equals((Object)dataType)) {
            this.setAsnType();
        }
    }

    public String toString(Context context) {
        return "BacnetScheduleExport_" + this.getObjectId().toString(context);
    }

    public BAbstractSchedule getSupervisor() {
        BAbstractSchedule bAbstractSchedule = null;
        try {
            bAbstractSchedule = (BAbstractSchedule)this.getSupervisorOrd().resolve((BObject)this).get();
        }
        catch (Exception exception) {
            throw new BajaRuntimeException(this.getSupervisorId(), (Throwable)exception);
        }
        if (bAbstractSchedule == null) {
            throw new IllegalArgumentException("Cannot resolve: " + this.getSupervisorId());
        }
        return bAbstractSchedule;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == BDescriptor.execute) {
            if (this.isDisabled()) {
                return null;
            }
            if (this.getState() != BDescriptorState.idle) {
                return null;
            }
            if (this.getSupervisorOrd().equals((Object)BOrd.DEFAULT)) {
                return null;
            }
            if (objectId.isEquivalentToDefaultValue((BValue)this.getObjectId())) {
                return null;
            }
            if (BScheduleDeviceExt.getVersionOf((BAbstractSchedule)this.getSupervisor()).equals((Object)this.getSubordinateVersion())) {
                return null;
            }
            this.setLastAttempt(Clock.time());
            this.setState(BDescriptorState.pending);
            try {
                return this.postExecute(action, bValue, context);
            }
            catch (Exception exception) {
                this.executeFail(exception);
                return null;
            }
        }
        if (action == readFromDevice) {
            return BBacnetNetwork.bacnet().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    protected IFuture postExecute(Action action, BValue bValue, Context context) {
        return BBacnetNetwork.bacnet().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doExecute() {
        if (log.isTraceOn()) {
            log.trace("BBacnetScheduleExport.doExecute on " + (Object)((Object)this));
        }
        BBacnetScheduleDeviceExt bBacnetScheduleDeviceExt = (BBacnetScheduleDeviceExt)this.getDeviceExt();
        this.executeInProgress();
        try {
            try {
                this.validateSchedule();
                bBacnetScheduleDeviceExt.writeRemote(this);
                this.setSubordinateVersion(BAbsTime.now());
                this.executeOk();
                this.getDevice().pingOk();
            }
            catch (BacnetException bacnetException) {
                Log.getLog((String)"bacnet.schedule").warning("BacnetException writing supervisor schedule data for " + this.getSupervisor().getName() + " to " + (Object)((Object)this.getObjectId()) + " in " + this.getDevice() + ": " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
                this.executeFail((this.writeProperty != null ? this.writeProperty.getTag() : "null") + "::" + bacnetException.toString());
            }
            catch (Exception exception) {
                Log.getLog((String)"bacnet.schedule").warning("Exception writing supervisor schedule data for " + this.getSupervisor().getName() + " to " + (Object)((Object)this.getObjectId()) + " in " + this.getDevice() + ": " + exception, (Throwable)exception);
                this.executeFail(exception);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.setState(BDescriptorState.idle);
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        this.setState(BDescriptorState.idle);
    }

    public void doReadFromDevice() {
        if (log.isTraceOn()) {
            log.trace("BBacnetScheduleExport.doReadFromDevice on " + (Object)((Object)this));
        }
        try {
            this.getSupervisor();
        }
        catch (Exception exception) {
            this.executeFail(exception);
        }
        BBacnetScheduleDeviceExt bBacnetScheduleDeviceExt = (BBacnetScheduleDeviceExt)this.getDeviceExt();
        try {
            BAbstractSchedule bAbstractSchedule = bBacnetScheduleDeviceExt.readRemote(this);
            if (bAbstractSchedule != null) {
                this.importRemoteSubordinate((BControlSchedule)bAbstractSchedule);
            }
            this.getDevice().pingOk();
        }
        catch (BacnetException bacnetException) {
            log.error("BacnetException reading remote subordinate schedule data for " + this.getSupervisor().getName() + " from " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
            this.executeFail((Throwable)((Object)bacnetException));
        }
        catch (Exception exception) {
            log.error("Exception reading remote subordinate schedule data for " + this.getSupervisor().getName() + " from " + (Object)((Object)this.getObjectId()) + ": " + exception, (Throwable)exception);
            this.executeFail(exception);
        }
    }

    public BOrd doChangeType(BBacnetChangeTypeParm bBacnetChangeTypeParm) {
        return new BBacnetScheduleTypeChangeJob(BBacnetNetwork.bacnet(), this, bBacnetChangeTypeParm).submit(null);
    }

    private final void setAsnType() {
        if (this.getDataType() == "" || this.getDataType().equals(lex.getText("asn.unknown"))) {
            this.setDataTypeFromSupervisor();
        }
        this.asnType = AsnUtil.getAsnType(this.getDataType());
    }

    private final void setDataTypeFromSupervisor() {
        try {
            Type type = this.getSupervisor().getType();
            if (type.is(BBooleanSchedule.TYPE)) {
                this.setDataType(AsnUtil.getAsnTypeName(1));
                this.setFlags((Slot)writeEnumAs, this.getFlags((Slot)writeEnumAs) | 4);
            } else if (type.is(BNumericSchedule.TYPE)) {
                this.setDataType(AsnUtil.getAsnTypeName(4));
                this.setFlags((Slot)writeEnumAs, this.getFlags((Slot)writeEnumAs) | 4);
            } else if (type.is(BEnumSchedule.TYPE)) {
                this.setDataType(AsnUtil.getAsnTypeName(2));
                this.setFlags((Slot)writeEnumAs, this.getFlags((Slot)writeEnumAs) & 0xFFFFFFFB);
            } else {
                this.setDataType(AsnUtil.getAsnTypeName(7));
                this.setFlags((Slot)writeEnumAs, this.getFlags((Slot)writeEnumAs) | 4);
            }
        }
        catch (Exception exception) {
            log.message("Cannot determine ASN type for schedule export " + (Object)((Object)this) + ":invalid supervisor ord [" + this.getSupervisorOrd() + ']');
        }
    }

    public int getAsnType() {
        Type type = this.getSupervisor().getType();
        if (type.is(BEnumSchedule.TYPE)) {
            switch (this.getWriteEnumAs().getOrdinal()) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 9;
                }
                case 2: {
                    return 3;
                }
            }
        }
        return this.asnType;
    }

    public void importRemoteSubordinate(BControlSchedule bControlSchedule) {
        BControlSchedule bControlSchedule2 = (BControlSchedule)this.getSupervisor();
        if (!bControlSchedule2.getClass().equals(bControlSchedule.getClass())) {
            throw new IllegalStateException("Incompatible Schedules: Import [" + bControlSchedule.getClass().getName() + "] != " + bControlSchedule2.toPathString() + " [" + bControlSchedule2.getClass().getName() + ']');
        }
        boolean bl = bControlSchedule2.getCleanupExpiredEvents();
        bControlSchedule.setCleanupExpiredEvents(bl);
        BBacnetScheduleExport.copyOver((BAbstractSchedule)bControlSchedule, (BAbstractSchedule)bControlSchedule2);
    }

    protected static void copyOver(BAbstractSchedule bAbstractSchedule, BAbstractSchedule bAbstractSchedule2) {
        bAbstractSchedule2.copyFrom(bAbstractSchedule, null);
        bAbstractSchedule2.set("lastModified", (BValue)BScheduleDeviceExt.getVersionOf((BAbstractSchedule)bAbstractSchedule));
    }

    /*
     * Unable to fully structure code
     */
    protected void validateSchedule() {
        block4: {
            var1_1 = this.getSupervisor();
            if (!(var1_1 instanceof BWeeklySchedule)) break block4;
            var4_2 = (BWeeklySchedule)var1_1;
            var5_3 = var4_2.getSpecialEventsChildren();
            var6_4 = 0;
            while (var6_4 < var5_3.length) {
                var7_7 = var5_3[var6_4];
                if (var7_7.getDays() instanceof BCustomSchedule) {
                    throw new IllegalStateException("Cannot send CustomSchedule Special Events to BACnet");
                }
                var8_8 = var7_7.getDay();
                var2_5 = var8_8.getProperties();
                if (true) ** GOTO lbl16
                do {
                    if ((var3_6 = (BTimeSchedule)var2_5.get()).getEffectiveValue().getStatus().isNull()) {
                        throw new IllegalStateException("Cannot write NULL-valued TimeSchedules to BACnet");
                    }
lbl16:
                    // 3 sources

                    if ((v0 = BBacnetScheduleExport.class$javax$baja$schedule$BTimeSchedule) != null) continue;
                    v0 = BBacnetScheduleExport.class("[Ljavax.baja.schedule.BTimeSchedule;", false);
                } while (var2_5.next(v0));
                ++var6_4;
            }
        }
    }

    public BBacnetChangeTypeParm doReadChangeTypeParams() {
        BBacnetScheduleDeviceExt bBacnetScheduleDeviceExt = (BBacnetScheduleDeviceExt)this.getDeviceExt();
        BBacnetDevice bBacnetDevice = bBacnetScheduleDeviceExt.device();
        BBacnetChangeTypeParm bBacnetChangeTypeParm = new BBacnetChangeTypeParm();
        bBacnetChangeTypeParm.setDataType(this.getDataType());
        bBacnetChangeTypeParm.setSupervisorOrd(this.getSupervisorOrd());
        try {
            BBacnetAddress bBacnetAddress = bBacnetDevice.getAddress();
            BBacnetObjectIdentifier bBacnetObjectIdentifier = this.getObjectId();
            BBacnetClientLayer bBacnetClientLayer = bBacnetScheduleDeviceExt.client();
            AsnInputStream asnInputStream = new AsnInputStream();
            byte[] byArray = bBacnetClientLayer.readProperty(bBacnetAddress, bBacnetObjectIdentifier, 174);
            asnInputStream.setBuffer(byArray);
            bBacnetChangeTypeParm.getScheduleDefault().readAsn(asnInputStream);
            byArray = bBacnetClientLayer.readProperty(bBacnetAddress, bBacnetObjectIdentifier, 54);
            asnInputStream.setBuffer(byArray);
            bBacnetChangeTypeParm.getListOfObjectPropertyRefs().readAsn(asnInputStream);
            try {
                byArray = bBacnetClientLayer.readProperty(bBacnetAddress, bBacnetObjectIdentifier, 123);
                asnInputStream.setBuffer(byArray);
                bBacnetChangeTypeParm.getWeeklySchedule().readAsn(asnInputStream);
                bBacnetChangeTypeParm.setHasWeeklySchedule(true);
            }
            catch (ErrorException errorException) {
                bBacnetChangeTypeParm.setHasWeeklySchedule(false);
            }
            try {
                byArray = bBacnetClientLayer.readProperty(bBacnetAddress, bBacnetObjectIdentifier, 38);
                asnInputStream.setBuffer(byArray);
                bBacnetChangeTypeParm.getExceptionSchedule().readAsn(asnInputStream);
                bBacnetChangeTypeParm.setHasExceptionSchedule(true);
            }
            catch (ErrorException errorException) {
                bBacnetChangeTypeParm.setHasExceptionSchedule(false);
            }
            return bBacnetChangeTypeParm;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.asnType = -1;
        this.writeProperty = null;
    }

    public BBacnetScheduleExport() {
        this.this();
    }

    public BBacnetScheduleExport(String string) {
        this.this();
        this.setSupervisorId(string);
    }

    static {
        Class clazz = class$com$tridium$bacnet$schedule$BBacnetScheduleExport;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$schedule$BBacnetScheduleExport = BBacnetScheduleExport.class("[Lcom.tridium.bacnet.schedule.BBacnetScheduleExport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"bacnet");
        log = Log.getLog((String)"bacnet.schedule");
    }
}

