/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.schedule;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.BacnetQuery;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BBacnetDiscoverSchedulesJob;
import com.tridium.bacnet.schedule.BBacnetScheduleExport;
import com.tridium.bacnet.schedule.BBacnetScheduleImportExt;
import com.tridium.bacnet.schedule.ScheduleSupport0;
import com.tridium.bacnet.schedule.ScheduleSupport4;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BIBacnetObjectContainer;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.schedule.driver.BScheduleDeviceExt;
import javax.baja.schedule.driver.BScheduleExport;
import javax.baja.schedule.driver.BScheduleImportExt;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetScheduleDeviceExt
extends BScheduleDeviceExt
implements BacnetConst,
BIBacnetObjectContainer {
    public static final Property skipWriteOnError = BBacnetScheduleDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Action submitScheduleDiscoveryJob = BBacnetScheduleDeviceExt.newAction((int)4, null);
    public static final Type TYPE;
    private static Comparator specialEventComparator;
    private static final Context dumpCx;
    private static final Lexicon lex;
    public static final String[] skipWritesProps0;
    public static final String[] skipWritesProps4;
    public static final BIDataValue[] skipWritesVals0;
    public static final BIDataValue[] skipWritesVals4;
    public static final BFacets skipWrites0;
    public static final BFacets skipWrites4;
    private static final Log log;
    boolean loaded;
    private ScheduleSupport0 supp;
    static /* synthetic */ Class class$com$tridium$bacnet$schedule$BBacnetScheduleDeviceExt;
    static /* synthetic */ Class class$com$tridium$bacnet$schedule$BBacnetScheduleImportExt;
    static /* synthetic */ Class class$com$tridium$bacnet$schedule$BBacnetScheduleExport;
    static /* synthetic */ Class class$javax$baja$schedule$BAbstractSchedule;
    static /* synthetic */ Class class$javax$baja$schedule$BDailySchedule;
    static /* synthetic */ Class class$javax$baja$schedule$BTimeSchedule;

    public boolean getSkipWriteOnError() {
        return this.getBoolean(skipWriteOnError);
    }

    public void setSkipWriteOnError(boolean bl) {
        this.setBoolean(skipWriteOnError, bl, null);
    }

    public BOrd submitScheduleDiscoveryJob() {
        return (BOrd)this.invoke(submitScheduleDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public ScheduleSupport0 getSupport() {
        return this.supp;
    }

    public void setSupport(int n) {
        if (n >= 4) {
            if (!(this.supp instanceof ScheduleSupport4)) {
                this.supp = new ScheduleSupport4(this);
            }
        } else if (this.supp instanceof ScheduleSupport4) {
            this.supp = new ScheduleSupport0(this);
        }
        if (log.isTraceOn()) {
            log.trace("Client schedule support for " + this.device() + " is now " + this.supp.getVersion());
        }
    }

    public void doSetSupp(BInteger bInteger) {
        this.setSupport(bInteger.getInt());
    }

    public BOrd doSubmitScheduleDiscoveryJob(Context context) {
        if (this.device().isFatalFault()) {
            return null;
        }
        return new BBacnetDiscoverSchedulesJob(this).submit(context);
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (this.get(property).getType().is(BBacnetScheduleExport.TYPE)) {
            BBacnetScheduleExport bBacnetScheduleExport = (BBacnetScheduleExport)this.get(property);
            if (this.device().getProtocolRevision() >= 4) {
                bBacnetScheduleExport.setSkipWrites(skipWrites4);
            } else {
                bBacnetScheduleExport.setSkipWrites(skipWrites0);
            }
        }
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetDevice;
    }

    public BScheduleExport makeExport(String string) {
        return new BBacnetScheduleExport(string);
    }

    public BScheduleImportExt makeImportExt() {
        return new BBacnetScheduleImportExt();
    }

    final BBacnetDevice device() {
        return (BBacnetDevice)this.getDevice();
    }

    BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    public static final BBacnetScheduleImportExt getBacnetExt(BAbstractSchedule bAbstractSchedule) {
        return BBacnetScheduleDeviceExt.getBacnetImportExt(bAbstractSchedule);
    }

    public static final BBacnetScheduleImportExt getBacnetImportExt(BAbstractSchedule bAbstractSchedule) {
        BValue bValue = bAbstractSchedule.get("ext");
        if (bValue != null && bValue instanceof BBacnetScheduleImportExt) {
            return (BBacnetScheduleImportExt)bValue;
        }
        SlotCursor slotCursor = bAbstractSchedule.getProperties();
        Class clazz = class$com$tridium$bacnet$schedule$BBacnetScheduleImportExt;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$schedule$BBacnetScheduleImportExt = BBacnetScheduleDeviceExt.class("[Lcom.tridium.bacnet.schedule.BBacnetScheduleImportExt;", false);
        }
        if (slotCursor.next(clazz)) {
            return (BBacnetScheduleImportExt)slotCursor.get();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final BBacnetScheduleExport getBacnetExportExt(BAbstractSchedule var1_1) {
        var2_2 = this.getProperties();
        if (true) ** GOTO lbl6
        do {
            if (var1_1 == (var3_3 = (BBacnetScheduleExport)var2_2.get()).getSupervisor()) {
                return var3_3;
            }
lbl6:
            // 3 sources

            if ((v0 = BBacnetScheduleDeviceExt.class$com$tridium$bacnet$schedule$BBacnetScheduleExport) != null) continue;
            v0 = BBacnetScheduleDeviceExt.class("[Lcom.tridium.bacnet.schedule.BBacnetScheduleExport;", false);
        } while (var2_2.next(v0));
        return null;
    }

    public BObject lookupBacnetObject(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, String string) {
        if (bBacnetObjectIdentifier == null) {
            return null;
        }
        if (!this.isRunning() && !this.loaded) {
            this.getComponentSpace().update((BComponent)this, Integer.MAX_VALUE);
            this.loaded = true;
        }
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextComponent()) {
            Object object;
            BComponent bComponent = slotCursor.get().asComponent();
            if (bComponent instanceof BBacnetScheduleExport) {
                object = (BBacnetScheduleExport)bComponent;
                if (!bBacnetObjectIdentifier.equals((Object)object.getObjectId())) continue;
                return object.getSupervisor();
            }
            if (!(bComponent instanceof BAbstractSchedule) || (object = (BBacnetScheduleImportExt)bComponent.get("ext")) == null || !bBacnetObjectIdentifier.equals((Object)((BBacnetScheduleImportExt)((Object)object)).getObjectId())) continue;
            return bComponent;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public BBacnetScheduleImportExt lookupImport(BBacnetObjectIdentifier var1_1) {
        if (var1_1 == null) {
            return null;
        }
        var2_2 = this.getProperties();
        if (true) ** GOTO lbl8
        do {
            if ((var4_4 = (BBacnetScheduleImportExt)(var3_3 = (BAbstractSchedule)var2_2.get()).get("ext")) != null && var1_1.equals((Object)var4_4.getObjectId())) {
                return var4_4;
            }
lbl8:
            // 3 sources

            if ((v0 = BBacnetScheduleDeviceExt.class$javax$baja$schedule$BAbstractSchedule) != null) continue;
            v0 = BBacnetScheduleDeviceExt.class("[Ljavax.baja.schedule.BAbstractSchedule;", false);
        } while (var2_2.next(v0));
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public BBacnetScheduleExport lookupExport(BBacnetObjectIdentifier var1_1) {
        if (var1_1 == null) {
            return null;
        }
        var2_2 = this.getProperties();
        if (true) ** GOTO lbl8
        do {
            if (var1_1.equals((Object)(var3_3 = (BBacnetScheduleExport)var2_2.get()).getObjectId())) {
                return var3_3;
            }
lbl8:
            // 3 sources

            if ((v0 = BBacnetScheduleDeviceExt.class$com$tridium$bacnet$schedule$BBacnetScheduleExport) != null) continue;
            v0 = BBacnetScheduleDeviceExt.class("[Lcom.tridium.bacnet.schedule.BBacnetScheduleExport;", false);
        } while (var2_2.next(v0));
        return null;
    }

    BAbstractSchedule readRemote(BBacnetScheduleImportExt bBacnetScheduleImportExt) throws Exception {
        if (log.isTraceOn()) {
            log.trace("readRemote(" + (Object)((Object)bBacnetScheduleImportExt) + ')');
        }
        BAbstractSchedule bAbstractSchedule = bBacnetScheduleImportExt.getSubordinate();
        Object object = null;
        object = bAbstractSchedule instanceof BCalendarSchedule ? this.readCalendar(bBacnetScheduleImportExt.getObjectId()) : this.readSchedule((BComplex)bBacnetScheduleImportExt, bAbstractSchedule.getType());
        this.validate((BAbstractSchedule)object);
        return object;
    }

    BAbstractSchedule readRemote(BBacnetScheduleExport bBacnetScheduleExport) throws Exception {
        if (log.isTraceOn()) {
            log.trace("readRemote(" + (Object)((Object)bBacnetScheduleExport) + ')');
        }
        BAbstractSchedule bAbstractSchedule = bBacnetScheduleExport.getSupervisor();
        Object object = null;
        object = bAbstractSchedule instanceof BCalendarSchedule ? this.readCalendar(bBacnetScheduleExport.getObjectId()) : this.readSchedule((BComplex)bBacnetScheduleExport, bAbstractSchedule.getType());
        this.validate((BAbstractSchedule)object);
        return object;
    }

    void writeRemote(BBacnetScheduleExport bBacnetScheduleExport) throws Exception {
        if (log.isTraceOn()) {
            log.trace("writeRemote(" + (Object)((Object)bBacnetScheduleExport) + ')');
        }
        if (!this.device().isServiceSupported("writeProperty")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.writeProperty"));
        }
        BAbstractSchedule bAbstractSchedule = bBacnetScheduleExport.getSupervisor();
        if (bAbstractSchedule instanceof BCalendarSchedule) {
            this.sendCalendar(bBacnetScheduleExport, (BCalendarSchedule)bAbstractSchedule);
        } else {
            BBacnetScheduleDeviceExt.setPrioritiesByOrder(((BWeeklySchedule)bAbstractSchedule).getSpecialEvents());
            this.sendSchedule(bBacnetScheduleExport, (BWeeklySchedule)bAbstractSchedule);
        }
    }

    private final void validate(BAbstractSchedule bAbstractSchedule) throws BacnetException {
        if (bAbstractSchedule == null) {
            throw new IllegalArgumentException("Return schedule is null!");
        }
        if (!(bAbstractSchedule instanceof BCalendarSchedule)) {
            BWeeklySchedule bWeeklySchedule = (BWeeklySchedule)bAbstractSchedule;
            this.checkForCalendarReferences(bWeeklySchedule.getSpecialEvents());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BCalendarSchedule readCalendar(BBacnetObjectIdentifier bBacnetObjectIdentifier) throws BacnetException {
        byte[] byArray = this.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, 23);
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BCalendarSchedule bCalendarSchedule = this.supp.decodeDateList(asnInputStream);
            Object var5_5 = null;
            asnInputStream.release();
            return bCalendarSchedule;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final BWeeklySchedule readSchedule(BComplex bComplex, Type type) throws BacnetException {
        BDailySchedule bDailySchedule;
        BCompositeSchedule bCompositeSchedule;
        AsnInputStream asnInputStream;
        BBacnetObjectIdentifier bBacnetObjectIdentifier = (BBacnetObjectIdentifier)bComplex.get("objectId");
        BWeeklySchedule bWeeklySchedule = (BWeeklySchedule)type.getInstance();
        byte[] byArray = this.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, 85);
        if (byArray != null) {
            asnInputStream = AsnInputStream.make(byArray);
            try {
                int n = asnInputStream.peekApplicationTag();
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (type.is(BBooleanSchedule.TYPE)) break;
                        log.warning(MessageFormat.format(lex.getText("wrongClientScheduleType"), type, "BOOLEAN"));
                        break;
                    }
                    case 4: {
                        if (type.is(BNumericSchedule.TYPE)) break;
                        log.warning(MessageFormat.format(lex.getText("wrongClientScheduleType"), type, "REAL"));
                        break;
                    }
                    case 9: {
                        if (type.is(BEnumSchedule.TYPE)) break;
                        log.warning(MessageFormat.format(lex.getText("wrongClientScheduleType"), type, "Enumerated"));
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_17 = null;
                asnInputStream.release();
                throw throwable;
            }
            {
                bCompositeSchedule = null;
                asnInputStream.release();
            }
        }
        if (this.device().getProtocolRevision() >= 4) {
            byArray = this.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, 111);
            if (byArray != null) {
                ((BStatusValue)bWeeklySchedule.get("out")).setStatus(AsnUtil.asnStatusFlagsToBStatus(byArray));
            }
            if ((byArray = this.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, 174)) != null) {
                asnInputStream = AsnInputStream.make(byArray);
                try {
                    bWeeklySchedule.setDefaultOutput(this.supp.decodeScheduleDefault(bWeeklySchedule.getDefaultOutput(), asnInputStream, -1));
                }
                catch (Throwable throwable) {
                    bCompositeSchedule = null;
                    asnInputStream.release();
                    throw throwable;
                }
                {
                    bCompositeSchedule = null;
                    asnInputStream.release();
                }
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        bCompositeSchedule = null;
        if (this.device().getSegmentationSupported().isSegmentedTransmit()) {
            Object var11_30;
            AsnInputStream asnInputStream2;
            try {
                byArray = this.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, 123);
                if (byArray != null) {
                    asnInputStream2 = AsnInputStream.make(byArray);
                    try {
                        int n = 1;
                        while (n <= 7) {
                            ((BDailySchedule)bWeeklySchedule.getWeek().get(BWeekday.make((int)(n % 7)).getTag())).setDay(this.supp.decodeDailySchedule(bWeeklySchedule.getDefaultOutput(), asnInputStream2, -1));
                            ++n;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_29 = null;
                        asnInputStream2.release();
                        throw throwable;
                    }
                    {
                        var11_30 = null;
                        asnInputStream2.release();
                    }
                }
                bl = true;
            }
            catch (BacnetException bacnetException) {
                log.message("Unable to retrieve Weekly_Schedule from " + (Object)((Object)bBacnetObjectIdentifier) + " in bulk:" + (Object)((Object)bacnetException));
            }
            try {
                byArray = this.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, 38);
                if (byArray != null) {
                    asnInputStream2 = AsnInputStream.make(byArray);
                    try {
                        bCompositeSchedule = this.supp.decodeExceptionSchedule(bWeeklySchedule.getDefaultOutput(), asnInputStream2, this.device().getObjectId(), -1);
                        BBacnetScheduleDeviceExt.sortEventsByPriority(bCompositeSchedule);
                        bWeeklySchedule.getSchedule().set("specialEvents", (BValue)bCompositeSchedule);
                    }
                    catch (Throwable throwable) {
                        var11_30 = null;
                        asnInputStream2.release();
                        throw throwable;
                    }
                    {
                        var11_30 = null;
                        asnInputStream2.release();
                    }
                }
                bl2 = true;
            }
            catch (BacnetException bacnetException) {
                log.message("Unable to retrieve Exception_Schedule from " + (Object)((Object)bBacnetObjectIdentifier) + " in bulk:" + (Object)((Object)bacnetException));
            }
        }
        if (!bl) {
            try {
                int n = 1;
                while (n <= 7) {
                    byArray = this.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, 123, n);
                    if (byArray != null) {
                        AsnInputStream asnInputStream3 = AsnInputStream.make(byArray);
                        try {
                            ((BDailySchedule)bWeeklySchedule.getWeek().get(BWeekday.make((int)(n % 7)).getTag())).setDay(this.supp.decodeDailySchedule(bWeeklySchedule.getDefaultOutput(), asnInputStream3, -1));
                        }
                        catch (Throwable throwable) {
                            bDailySchedule = null;
                            asnInputStream3.release();
                            throw throwable;
                        }
                        {
                            bDailySchedule = null;
                            asnInputStream3.release();
                        }
                    }
                    ++n;
                }
            }
            catch (BacnetException bacnetException) {
                log.message("Unable to retrieve Weekly_Schedule from " + (Object)((Object)bBacnetObjectIdentifier) + " individually:" + (Object)((Object)bacnetException));
            }
        }
        if (!bl2) {
            try {
                byArray = this.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, 38, 0);
                int n = AsnUtil.fromAsnUnsignedInt(byArray);
                BDailySchedule[] bDailyScheduleArray = new BDailySchedule[n];
                bCompositeSchedule = new BCompositeSchedule();
                int n2 = 0;
                while (true) {
                    block60: {
                        if (n2 >= n) break;
                        byArray = this.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, 38, n2 + 1);
                        if (byArray != null) {
                            Object var15_36;
                            bDailySchedule = null;
                            AsnInputStream asnInputStream4 = AsnInputStream.make(byArray);
                            try {
                                bDailySchedule = this.supp.decodeSpecialEvent(bWeeklySchedule.getDefaultOutput(), asnInputStream4, this.device().getObjectId(), -1, n2);
                            }
                            catch (Throwable throwable) {
                                var15_36 = null;
                                asnInputStream4.release();
                                throw throwable;
                            }
                            {
                                var15_36 = null;
                                asnInputStream4.release();
                                if (bDailySchedule == null) break block60;
                            }
                            int n3 = ((BInteger)bDailySchedule.get("priority")).getInt();
                            boolean bl3 = false;
                            int n4 = 0;
                            block38: while (n4 < n2) {
                                BDailySchedule bDailySchedule2 = bDailyScheduleArray[n4];
                                Property property = bDailySchedule2.getProperty("priority");
                                int n5 = 1;
                                if (property != null) {
                                    n5 = bDailySchedule2.getInt(property);
                                }
                                if (n3 < n5) {
                                    int n6 = n2;
                                    while (true) {
                                        if (n6 <= n4) {
                                            bDailyScheduleArray[n4] = bDailySchedule;
                                            bl3 = true;
                                            break block38;
                                        }
                                        bDailyScheduleArray[n6] = bDailyScheduleArray[n6 - 1];
                                        --n6;
                                    }
                                }
                                ++n4;
                            }
                            if (!bl3) {
                                bDailyScheduleArray[n2] = bDailySchedule;
                            }
                        }
                    }
                    ++n2;
                }
                n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        bWeeklySchedule.getSchedule().set("specialEvents", (BValue)bCompositeSchedule);
                        break;
                    }
                    if (bDailyScheduleArray[n2] != null) {
                        bCompositeSchedule.add((BAbstractSchedule)bDailyScheduleArray[n2]);
                    }
                    ++n2;
                }
            }
            catch (BacnetException bacnetException) {
                log.message("Unable to retrieve Exception_Schedule from " + (Object)((Object)bBacnetObjectIdentifier) + " individually:" + (Object)((Object)bacnetException));
            }
        }
        this.checkForCalendarReferences(bCompositeSchedule);
        byArray = this.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, 32);
        if (byArray != null) {
            AsnInputStream asnInputStream5 = AsnInputStream.make(byArray);
            try {
                bWeeklySchedule.setEffective(this.supp.decodeDateRange(asnInputStream5));
            }
            catch (Throwable throwable) {
                Object var11_33 = null;
                asnInputStream5.release();
                throw throwable;
            }
            {
                Object var11_34 = null;
                asnInputStream5.release();
            }
        }
        if ((byArray = this.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, 88)) != null) {
            bComplex.set("priorityForWriting", (BValue)BInteger.make((int)AsnUtil.fromAsnUnsignedInt(byArray)));
        }
        return bWeeklySchedule;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void sendCalendar(BBacnetScheduleExport bBacnetScheduleExport, BCalendarSchedule bCalendarSchedule) throws BacnetException {
        byte[] byArray;
        BBacnetObjectIdentifier bBacnetObjectIdentifier = bBacnetScheduleExport.getObjectId();
        bBacnetScheduleExport.writeProperty = BBacnetPropertyIdentifier.dateList;
        AsnOutputStream asnOutputStream = AsnOutputStream.make();
        try {
            this.supp.encodeDateList(bCalendarSchedule, asnOutputStream);
            byArray = asnOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            asnOutputStream.release();
            throw throwable;
        }
        {
            Object var7_8 = null;
            asnOutputStream.release();
            this.client().writeProperty(this.device().getAddress(), bBacnetObjectIdentifier, 23, byArray);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void sendSchedule(BBacnetScheduleExport bBacnetScheduleExport, BWeeklySchedule bWeeklySchedule) throws BacnetException {
        SlotCursor slotCursor;
        boolean bl;
        byte[] byArray;
        BBacnetObjectIdentifier bBacnetObjectIdentifier;
        BacnetException bacnetException;
        block52: {
            boolean bl2;
            block53: {
                AsnOutputStream asnOutputStream;
                bacnetException = null;
                bBacnetObjectIdentifier = bBacnetScheduleExport.getObjectId();
                if (this.device().getProtocolRevision() >= 4 && !BBacnetScheduleDeviceExt.isSkipWrite(bBacnetScheduleExport, (BEnum)BBacnetPropertyIdentifier.scheduleDefault)) {
                    bBacnetScheduleExport.writeProperty = BBacnetPropertyIdentifier.scheduleDefault;
                    AsnOutputStream asnOutputStream2 = AsnOutputStream.make();
                    try {
                        this.supp.encodeScheduleDefault(bWeeklySchedule.getDefaultOutput(), (AsnOutput)asnOutputStream2, bBacnetScheduleExport.getAsnType());
                        byArray = asnOutputStream2.toByteArray();
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        asnOutputStream2.release();
                        throw throwable;
                    }
                    {
                        asnOutputStream = null;
                        asnOutputStream2.release();
                        {
                            this.client().writeProperty(this.device().getAddress(), bBacnetObjectIdentifier, 174, byArray);
                        }
                    }
                }
                bl2 = false;
                bl = false;
                if (BBacnetScheduleDeviceExt.isSkipWrite(bBacnetScheduleExport, (BEnum)BBacnetPropertyIdentifier.weeklySchedule)) break block52;
                bBacnetScheduleExport.writeProperty = BBacnetPropertyIdentifier.weeklySchedule;
                if (BBacnetScheduleDeviceExt.isSkipWrite(bBacnetScheduleExport, "weeklyScheduleEntire")) break block53;
                try {
                    asnOutputStream = AsnOutputStream.make();
                    try {
                        int n = 1;
                        while (true) {
                            block54: {
                                if (n <= 7) break block54;
                                byArray = asnOutputStream.toByteArray();
                                break;
                            }
                            this.supp.encodeDailySchedule(bWeeklySchedule.get(BWeekday.make((int)(n % 7))), bWeeklySchedule.getDefaultOutput(), asnOutputStream, bBacnetScheduleExport.getAsnType());
                            ++n;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_32 = null;
                        asnOutputStream.release();
                        throw throwable;
                    }
                    {
                        slotCursor = null;
                        asnOutputStream.release();
                        this.client().writeProperty(this.device().getAddress(), bBacnetObjectIdentifier, 123, byArray);
                        bl2 = true;
                    }
                }
                catch (BacnetStackException bacnetStackException) {
                    log.message("Unable to send Weekly_Schedule to " + (Object)((Object)bBacnetObjectIdentifier) + " in bulk:" + bacnetStackException);
                }
                catch (BacnetException bacnetException2) {
                    log.message("Unable to send Weekly_Schedule to " + (Object)((Object)bBacnetObjectIdentifier) + " in bulk:" + (Object)((Object)bacnetException2));
                    BBacnetScheduleDeviceExt.setSkipWrites(bBacnetScheduleExport, "weeklyScheduleEntire", true);
                }
            }
            if (!bl2) {
                int n = 1;
                while (n <= 7) {
                    AsnOutputStream asnOutputStream = AsnOutputStream.make();
                    try {
                        this.supp.encodeDailySchedule(bWeeklySchedule.get(BWeekday.make((int)(n % 7))), bWeeklySchedule.getDefaultOutput(), asnOutputStream, bBacnetScheduleExport.getAsnType());
                        byArray = asnOutputStream.toByteArray();
                    }
                    catch (Throwable throwable) {
                        Object var11_23 = null;
                        asnOutputStream.release();
                        throw throwable;
                    }
                    {
                        Object var11_24 = null;
                        asnOutputStream.release();
                        {
                            this.client().writeProperty(this.device().getAddress(), bBacnetObjectIdentifier, 123, n, byArray);
                        }
                        ++n;
                    }
                }
            }
        }
        if (!BBacnetScheduleDeviceExt.isSkipWrite(bBacnetScheduleExport, (BEnum)BBacnetPropertyIdentifier.exceptionSchedule)) {
            bBacnetScheduleExport.writeProperty = BBacnetPropertyIdentifier.exceptionSchedule;
            if (!BBacnetScheduleDeviceExt.isSkipWrite(bBacnetScheduleExport, "exceptionScheduleEntire")) {
                try {
                    AsnOutputStream asnOutputStream = AsnOutputStream.make();
                    try {
                        this.supp.encodeExceptionSchedule(bWeeklySchedule.getSpecialEvents(), bWeeklySchedule.getDefaultOutput(), asnOutputStream, bBacnetScheduleExport.getAsnType(), this.device().getObjectId());
                        byArray = asnOutputStream.toByteArray();
                    }
                    catch (Throwable throwable) {
                        slotCursor = null;
                        asnOutputStream.release();
                        throw throwable;
                    }
                    {
                        slotCursor = null;
                        asnOutputStream.release();
                        this.client().writeProperty(this.device().getAddress(), bBacnetObjectIdentifier, 38, byArray);
                        bl = true;
                    }
                }
                catch (BacnetStackException bacnetStackException) {
                    log.message("Unable to send Exception_Schedule to " + (Object)((Object)bBacnetObjectIdentifier) + " in bulk:" + bacnetStackException);
                }
                catch (BacnetException bacnetException3) {
                    log.message("Unable to send Exception_Schedule to " + (Object)((Object)bBacnetObjectIdentifier) + " in bulk:" + (Object)((Object)bacnetException3));
                    BBacnetScheduleDeviceExt.setSkipWrites(bBacnetScheduleExport, "exceptionScheduleEntire", true);
                }
            }
            if (!bl) {
                boolean bl3;
                block51: {
                    BCompositeSchedule bCompositeSchedule = bWeeklySchedule.getSpecialEvents();
                    Class clazz = class$javax$baja$schedule$BDailySchedule;
                    if (clazz == null) {
                        clazz = class$javax$baja$schedule$BDailySchedule = BBacnetScheduleDeviceExt.class("[Ljavax.baja.schedule.BDailySchedule;", false);
                    }
                    int n = bCompositeSchedule.getChildren(clazz).length;
                    bl3 = false;
                    try {
                        this.client().writeProperty(this.device().getAddress(), bBacnetObjectIdentifier, 38, 0, AsnUtil.toAsnUnsigned(n));
                        bl3 = true;
                    }
                    catch (BacnetStackException bacnetStackException) {
                        if (bacnetException == null) {
                            bacnetException = bacnetStackException;
                        }
                    }
                    catch (BacnetException bacnetException4) {
                        if (bacnetException == null) {
                            bacnetException = bacnetException4;
                        }
                        if (!this.getSkipWriteOnError()) break block51;
                        BBacnetScheduleDeviceExt.setSkipWrites(bBacnetScheduleExport, (BEnum)BBacnetPropertyIdentifier.exceptionSchedule, true);
                    }
                }
                if (bl3) {
                    slotCursor = bWeeklySchedule.getSpecialEvents().getProperties();
                    int n = 0;
                    while (true) {
                        Object var14_38;
                        Class clazz;
                        if ((clazz = class$javax$baja$schedule$BDailySchedule) == null) {
                            clazz = BBacnetScheduleDeviceExt.class("[Ljavax.baja.schedule.BDailySchedule;", false);
                        }
                        if (!slotCursor.next(clazz)) break;
                        AsnOutputStream asnOutputStream = AsnOutputStream.make();
                        try {
                            this.supp.encodeSpecialEvent((BDailySchedule)slotCursor.get(), bWeeklySchedule.getDefaultOutput(), asnOutputStream, bBacnetScheduleExport.getAsnType(), this.device().getObjectId());
                            byArray = asnOutputStream.toByteArray();
                        }
                        catch (Throwable throwable) {
                            var14_38 = null;
                            asnOutputStream.release();
                            throw throwable;
                        }
                        {
                            var14_38 = null;
                            asnOutputStream.release();
                            {
                                this.client().writeProperty(this.device().getAddress(), bBacnetObjectIdentifier, 38, ++n, byArray);
                                continue;
                            }
                        }
                        break;
                    }
                }
            }
        }
        if (!BBacnetScheduleDeviceExt.isSkipWrite(bBacnetScheduleExport, (BEnum)BBacnetPropertyIdentifier.effectivePeriod)) {
            bBacnetScheduleExport.writeProperty = BBacnetPropertyIdentifier.effectivePeriod;
            AsnOutputStream asnOutputStream = AsnOutputStream.make();
            try {
                this.supp.encodeDateRange(bWeeklySchedule.getEffective(), asnOutputStream);
                byArray = asnOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                slotCursor = null;
                asnOutputStream.release();
                throw throwable;
            }
            {
                slotCursor = null;
                asnOutputStream.release();
                {
                    this.client().writeProperty(this.device().getAddress(), bBacnetObjectIdentifier, 32, byArray);
                }
            }
        }
        if (!BBacnetScheduleDeviceExt.isSkipWrite(bBacnetScheduleExport, (BEnum)BBacnetPropertyIdentifier.priorityForWriting)) {
            bBacnetScheduleExport.writeProperty = BBacnetPropertyIdentifier.priorityForWriting;
            AsnOutputStream asnOutputStream = AsnOutputStream.make();
            try {
                asnOutputStream.writeUnsignedInteger(bBacnetScheduleExport.getPriorityForWriting());
                byArray = asnOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                slotCursor = null;
                asnOutputStream.release();
                throw throwable;
            }
            {
                slotCursor = null;
                asnOutputStream.release();
                {
                    this.client().writeProperty(this.device().getAddress(), bBacnetObjectIdentifier, 88, byArray);
                }
            }
        }
        bBacnetScheduleExport.writeProperty = null;
        if (bacnetException != null) {
            throw bacnetException;
        }
    }

    private final void checkForCalendarReferences(BCompositeSchedule bCompositeSchedule) throws BacnetException {
        if (bCompositeSchedule == null) {
            return;
        }
        Class clazz = class$javax$baja$schedule$BDailySchedule;
        if (clazz == null) {
            clazz = class$javax$baja$schedule$BDailySchedule = BBacnetScheduleDeviceExt.class("[Ljavax.baja.schedule.BDailySchedule;", false);
        }
        BDailySchedule[] bDailyScheduleArray = (BDailySchedule[])bCompositeSchedule.getChildren(clazz);
        int n = 0;
        while (n < bDailyScheduleArray.length) {
            BAbstractSchedule bAbstractSchedule = bDailyScheduleArray[n].getDays();
            if (bAbstractSchedule instanceof BScheduleReference) {
                BOrd bOrd = ((BScheduleReference)bAbstractSchedule).getRef();
                OrdQuery[] ordQueryArray = bOrd.parse();
                int n2 = ordQueryArray.length;
                OrdQuery ordQuery = ordQueryArray[n2 - 1];
                BBacnetObjectIdentifier bBacnetObjectIdentifier = null;
                if (ordQuery instanceof BacnetQuery) {
                    BacnetQuery bacnetQuery = (BacnetQuery)ordQuery;
                    try {
                        bBacnetObjectIdentifier = (BBacnetObjectIdentifier)BBacnetObjectIdentifier.DEFAULT.decodeFromString(bacnetQuery.getObject());
                    }
                    catch (IOException iOException) {}
                    BBacnetScheduleImportExt bBacnetScheduleImportExt = this.lookupImport(bBacnetObjectIdentifier);
                    BBacnetScheduleExport bBacnetScheduleExport = this.lookupExport(bBacnetObjectIdentifier);
                    if (bBacnetObjectIdentifier != null && bBacnetScheduleImportExt == null && bBacnetScheduleExport == null) {
                        this.addCalendarImport(bBacnetObjectIdentifier);
                    }
                }
            }
            ++n;
        }
    }

    private final void addCalendarImport(BBacnetObjectIdentifier bBacnetObjectIdentifier) throws BacnetException {
        String string = AsnUtil.fromAsnCharacterString(this.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, 77));
        BCalendarSchedule bCalendarSchedule = new BCalendarSchedule();
        BBacnetScheduleImportExt bBacnetScheduleImportExt = new BBacnetScheduleImportExt();
        bBacnetScheduleImportExt.setObjectId(bBacnetObjectIdentifier);
        bCalendarSchedule.add("ext", (BValue)bBacnetScheduleImportExt);
        this.add(SlotPath.escape((String)string), (BValue)bCalendarSchedule);
    }

    private static final boolean isSkipWrite(BBacnetScheduleExport bBacnetScheduleExport, BEnum bEnum) {
        BObject bObject = bBacnetScheduleExport.getSkipWrites().getFacet(bEnum.getTag());
        if (bObject == null || bObject.getType() != BBoolean.TYPE) {
            return false;
        }
        return ((BBoolean)bObject).getBoolean();
    }

    public static void setPrioritiesByOrder(BCompositeSchedule bCompositeSchedule) {
        Class clazz = class$javax$baja$schedule$BDailySchedule;
        if (clazz == null) {
            clazz = class$javax$baja$schedule$BDailySchedule = BBacnetScheduleDeviceExt.class("[Ljavax.baja.schedule.BDailySchedule;", false);
        }
        BDailySchedule[] bDailyScheduleArray = (BDailySchedule[])bCompositeSchedule.getChildren(clazz);
        int n = bDailyScheduleArray.length;
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            BacUtil.setOrAdd((BComponent)bDailyScheduleArray[n3], "priority", (BValue)BInteger.make((int)n2), null);
            if (n2 < 16) {
                ++n2;
            }
            ++n3;
        }
    }

    public static void sortEventsByPriority(BCompositeSchedule bCompositeSchedule) {
        Class clazz = class$javax$baja$schedule$BDailySchedule;
        if (clazz == null) {
            clazz = class$javax$baja$schedule$BDailySchedule = BBacnetScheduleDeviceExt.class("[Ljavax.baja.schedule.BDailySchedule;", false);
        }
        BDailySchedule[] bDailyScheduleArray = (BDailySchedule[])bCompositeSchedule.getChildren(clazz);
        Arrays.sort(bDailyScheduleArray, specialEventComparator);
        String[] stringArray = new String[bDailyScheduleArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = bDailyScheduleArray[n].getName();
            ++n;
        }
        n = 0;
        while (n < bDailyScheduleArray.length) {
            bCompositeSchedule.remove((BComplex)bDailyScheduleArray[n]);
            bCompositeSchedule.add(stringArray[n], (BValue)bDailyScheduleArray[n]);
            ++n;
        }
    }

    private static final boolean isSkipWrite(BBacnetScheduleExport bBacnetScheduleExport, String string) {
        BObject bObject = bBacnetScheduleExport.getSkipWrites().getFacet(string);
        if (bObject == null || bObject.getType() != BBoolean.TYPE) {
            return false;
        }
        return ((BBoolean)bObject).getBoolean();
    }

    private static final void setSkipWrites(BBacnetScheduleExport bBacnetScheduleExport, BEnum bEnum, boolean bl) {
        BFacets bFacets = bBacnetScheduleExport.getSkipWrites();
        bBacnetScheduleExport.setSkipWrites(BFacets.make((BFacets)bFacets, (String)bEnum.getTag(), (BIDataValue)BBoolean.make((boolean)bl)));
    }

    private static final void setSkipWrites(BBacnetScheduleExport bBacnetScheduleExport, String string, boolean bl) {
        BFacets bFacets = bBacnetScheduleExport.getSkipWrites();
        bBacnetScheduleExport.setSkipWrites(BFacets.make((BFacets)bFacets, (String)string, (BIDataValue)BBoolean.make((boolean)bl)));
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetScheduleDeviceExt", 2);
        spyWriter.prop((Object)"support", (Object)this.supp.getVersion());
        spyWriter.endProps();
    }

    private static final void d(String string) {
        System.out.println(string);
    }

    private static final void dd(String string) {
        System.out.print(string);
    }

    void dumpSchedule(BWeeklySchedule bWeeklySchedule) {
        BBacnetScheduleDeviceExt.d("NiagaraSchedule dump:");
        BBacnetScheduleDeviceExt.d(" type:" + bWeeklySchedule.getType());
        SlotCursor slotCursor = bWeeklySchedule.getProperties();
        while (slotCursor.next()) {
            BBacnetScheduleDeviceExt.dd(slotCursor.property().getName() + '[' + slotCursor.property().getType() + "]:");
            BBacnetScheduleDeviceExt.dump(slotCursor.get());
        }
    }

    static void dump(BAbstractSchedule bAbstractSchedule) {
        SlotCursor slotCursor = bAbstractSchedule.getProperties();
        while (slotCursor.next()) {
            BBacnetScheduleDeviceExt.dd(slotCursor.property().getName() + '[' + slotCursor.property().getType() + "]:");
            BBacnetScheduleDeviceExt.dump(slotCursor.get());
        }
    }

    static void dump(BObject bObject) {
        BBacnetScheduleDeviceExt.d(bObject.toString());
    }

    static void dump(BDateRangeSchedule bDateRangeSchedule) {
        BBacnetScheduleDeviceExt.dd("start:");
        BBacnetScheduleDeviceExt.dump(bDateRangeSchedule.getStart());
        BBacnetScheduleDeviceExt.dd("end:");
        BBacnetScheduleDeviceExt.dump(bDateRangeSchedule.getEnd());
    }

    static void dump(BDateSchedule bDateSchedule) {
        BBacnetScheduleDeviceExt.dd("" + bDateSchedule.getYear() + '-' + bDateSchedule.getMonth() + '-' + bDateSchedule.getDay() + ' ' + bDateSchedule.getWeekday());
    }

    static void dump(BDailySchedule bDailySchedule) {
        BBacnetScheduleDeviceExt.d("DailySchedule dump:");
        BBacnetScheduleDeviceExt.dd("day:");
        BBacnetScheduleDeviceExt.dump(bDailySchedule.getDay());
        BBacnetScheduleDeviceExt.dd("days:");
        BBacnetScheduleDeviceExt.dump(bDailySchedule.getDays());
        Property property = bDailySchedule.getProperty("priority");
        if (property != null) {
            BBacnetScheduleDeviceExt.d("priority:" + bDailySchedule.getInt(property));
        }
    }

    /*
     * Unable to fully structure code
     */
    static void dump(BDaySchedule var0) {
        BBacnetScheduleDeviceExt.d("DaySchedule dump:");
        var1_1 = var0.getProperties();
        var2_2 = 0;
        if (true) ** GOTO lbl9
        do {
            var3_3 = (BTimeSchedule)var1_1.get();
            BBacnetScheduleDeviceExt.dd("timeSched " + var2_2++ + ':');
            BBacnetScheduleDeviceExt.dump(var3_3);
lbl9:
            // 2 sources

            if ((v0 = BBacnetScheduleDeviceExt.class$javax$baja$schedule$BTimeSchedule) != null) continue;
            v0 = BBacnetScheduleDeviceExt.class("[Ljavax.baja.schedule.BTimeSchedule;", false);
        } while (var1_1.next(v0));
    }

    static void dump(BTimeSchedule bTimeSchedule) {
        BBacnetScheduleDeviceExt.d(bTimeSchedule.getStart().toString(dumpCx) + " - " + bTimeSchedule.getFinish().toString(dumpCx) + " = " + bTimeSchedule.getEffectiveValue());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.loaded = false;
        this.supp = new ScheduleSupport4(this);
    }

    public BBacnetScheduleDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$schedule$BBacnetScheduleDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$schedule$BBacnetScheduleDeviceExt = BBacnetScheduleDeviceExt.class("[Lcom.tridium.bacnet.schedule.BBacnetScheduleDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        specialEventComparator = new Comparator(){

            public final int compare(Object object, Object object2) {
                if (object == null || object2 == null) {
                    throw new NullPointerException();
                }
                if (object instanceof BDailySchedule && object2 instanceof BDailySchedule) {
                    BDailySchedule bDailySchedule = (BDailySchedule)object;
                    BDailySchedule bDailySchedule2 = (BDailySchedule)object2;
                    Property property = bDailySchedule.getProperty("priority");
                    Property property2 = bDailySchedule2.getProperty("priority");
                    if (property != null && property2 != null) {
                        return bDailySchedule.getInt(property) - bDailySchedule2.getInt(property2);
                    }
                    return 0;
                }
                throw new ClassCastException("Cannot compare " + object.getClass() + " and " + object2.getClass());
            }
        };
        dumpCx = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
        lex = Lexicon.make((String)"bacnet");
        skipWritesProps0 = new String[]{BBacnetPropertyIdentifier.weeklySchedule.getTag(), BBacnetPropertyIdentifier.exceptionSchedule.getTag(), BBacnetPropertyIdentifier.effectivePeriod.getTag(), BBacnetPropertyIdentifier.priorityForWriting.getTag()};
        skipWritesProps4 = new String[]{BBacnetPropertyIdentifier.scheduleDefault.getTag(), BBacnetPropertyIdentifier.weeklySchedule.getTag(), BBacnetPropertyIdentifier.exceptionSchedule.getTag(), BBacnetPropertyIdentifier.effectivePeriod.getTag(), BBacnetPropertyIdentifier.priorityForWriting.getTag()};
        skipWritesVals0 = new BIDataValue[]{BBoolean.FALSE, BBoolean.FALSE, BBoolean.FALSE, BBoolean.FALSE};
        skipWritesVals4 = new BIDataValue[]{BBoolean.FALSE, BBoolean.FALSE, BBoolean.FALSE, BBoolean.FALSE, BBoolean.FALSE};
        skipWrites0 = BFacets.make((String[])skipWritesProps0, (BIDataValue[])skipWritesVals0);
        skipWrites4 = BFacets.make((String[])skipWritesProps4, (BIDataValue[])skipWritesVals4);
        log = Log.getLog((String)"bacnet.schedule");
    }
}

