/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import com.tridium.bacnet.stack.transport.TransactionException;
import java.util.HashMap;
import java.util.Vector;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.InvalidEnumException;
import javax.baja.units.BUnit;

public class BacnetDiscoveryUtil
implements AsnConst {
    private static final double LN_10 = Math.log(10.0);
    private static IntHashMap facetPropsByType = new IntHashMap();

    public static void addFacet(int n, byte[] byArray, HashMap hashMap, BBacnetDevice bBacnetDevice) {
        try {
            switch (n) {
                case 69: {
                    hashMap.put("min", BacnetDiscoveryUtil.makeNumericFacetKey(AsnUtil.fromAsnReal(byArray)));
                    break;
                }
                case 65: {
                    hashMap.put("max", BacnetDiscoveryUtil.makeNumericFacetKey(AsnUtil.fromAsnReal(byArray)));
                    break;
                }
                case 106: {
                    float f = AsnUtil.fromAsnReal(byArray);
                    hashMap.put("resolution", BFloat.make((float)f));
                    if (f > 0.0f) {
                        double d = -(Math.log(f) / LN_10);
                        BInteger bInteger = BInteger.make((int)((int)Math.ceil(d -= 1.0E-6)));
                        if (bInteger.getInt() > 7) {
                            bInteger = BInteger.make((int)7);
                        }
                        hashMap.put("precision", bInteger);
                    }
                    break;
                }
                case 117: {
                    int n2 = AsnUtil.fromAsnEnumerated(byArray);
                    try {
                        if (BBacnetEngineeringUnits.isFixed(n2)) {
                            BUnit bUnit = BBacnetEngineeringUnits.make(n2).getNiagaraUnits();
                            hashMap.put("units", bUnit);
                            break;
                        }
                        Log.getLog((String)"bacnet.client").message("Unit enumeration " + BBacnetEngineeringUnits.tag(n2) + " is unknown!");
                    }
                    catch (InvalidEnumException invalidEnumException) {
                        System.out.println("Can't make BUnits from BacnetEngineeringUnits:" + BBacnetEngineeringUnits.tag(n2));
                    }
                    break;
                }
                case 4: {
                    hashMap.put("trueText", BString.make((String)AsnUtil.fromAsnCharacterString(byArray)));
                    break;
                }
                case 46: {
                    hashMap.put("falseText", BString.make((String)AsnUtil.fromAsnCharacterString(byArray)));
                    break;
                }
                case 110: {
                    Object object;
                    AsnInputStream asnInputStream = new AsnInputStream(byArray);
                    Vector<int[]> vector = new Vector<int[]>();
                    int n3 = asnInputStream.peekTag();
                    while (n3 != -1) {
                        object = SlotPath.escape((String)asnInputStream.readCharacterString());
                        while (vector.contains(object)) {
                            object = (String)object + "$2E";
                        }
                        vector.add((int[])object);
                        n3 = asnInputStream.peekTag();
                    }
                    object = new int[vector.size()];
                    int n4 = 0;
                    while (n4 < ((int[])object).length) {
                        object[n4] = n4 + 1;
                        ++n4;
                    }
                    Object[] objectArray = new String[vector.size()];
                    vector.copyInto(objectArray);
                    hashMap.put("range", BEnumRange.make((int[])object, (String[])objectArray));
                    break;
                }
            }
        }
        catch (AsnException asnException) {
            Log.getLog((String)"bacnet.client").message("AsnException parsing data for facet property " + BBacnetPropertyIdentifier.tag(n));
        }
        catch (Exception exception) {
            Log.getLog((String)"bacnet.client").message("Exception adding facet for property " + BBacnetPropertyIdentifier.tag(n) + ':' + exception);
        }
    }

    public static BBoolean checkForPriorityArray(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetDevice bBacnetDevice) {
        if (!bBacnetObjectIdentifier.isValid()) {
            return BBoolean.FALSE;
        }
        try {
            byte[] byArray = BacnetDiscoveryUtil.client().readProperty(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, 87, 0);
            int n = AsnUtil.fromAsnUnsignedInt(byArray);
            if (n == 16) {
                return BBoolean.TRUE;
            }
            return BBoolean.FALSE;
        }
        catch (Exception exception) {
            return BBoolean.FALSE;
        }
    }

    public static HashMap discoverFacets(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetDevice bBacnetDevice) {
        HashMap hashMap = new HashMap();
        if (!bBacnetObjectIdentifier.isValid()) {
            return hashMap;
        }
        int[] nArray = BacnetDiscoveryUtil.getFacetProps(bBacnetObjectIdentifier.getObjectType());
        if (nArray == null) {
            return hashMap;
        }
        int n = 0;
        while (n < nArray.length) {
            try {
                byte[] byArray = BacnetDiscoveryUtil.client().readProperty(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, nArray[n]);
                BacnetDiscoveryUtil.addFacet(nArray[n], byArray, hashMap, bBacnetDevice);
            }
            catch (TransactionException transactionException) {
                Log.getLog((String)"bacnet.client").message("TransactionException reading property " + BBacnetPropertyIdentifier.tag(nArray[n]) + " in " + (Object)((Object)bBacnetObjectIdentifier) + ": " + transactionException);
                return hashMap;
            }
            catch (ErrorException errorException) {
            }
            catch (BacnetException bacnetException) {
                Log.getLog((String)"bacnet.client").trace("BacnetException reading property " + BBacnetPropertyIdentifier.tag(nArray[n]) + " in " + (Object)((Object)bBacnetObjectIdentifier) + ": " + (Object)((Object)bacnetException));
            }
            ++n;
        }
        return hashMap;
    }

    public static int[] getFacetProps(int n) {
        return (int[])facetPropsByType.get(n);
    }

    public static final BNumber makeNumericFacetKey(float f) {
        if (f <= -3.4028235E38f) {
            return BDouble.make((double)Double.NEGATIVE_INFINITY);
        }
        if (f >= Float.MAX_VALUE) {
            return BDouble.make((double)Double.POSITIVE_INFINITY);
        }
        return BDouble.make((double)f);
    }

    private static final BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    static {
        facetPropsByType.put(0, (Object)new int[]{106, 69, 65, 117});
        facetPropsByType.put(1, (Object)new int[]{106, 69, 65, 117});
        facetPropsByType.put(2, (Object)new int[]{106, 69, 65, 117});
        facetPropsByType.put(3, (Object)new int[]{4, 46});
        facetPropsByType.put(4, (Object)new int[]{4, 46});
        facetPropsByType.put(5, (Object)new int[]{4, 46});
        facetPropsByType.put(13, (Object)new int[]{110});
        facetPropsByType.put(14, (Object)new int[]{110});
        facetPropsByType.put(19, (Object)new int[]{110});
    }
}

