/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.datatypes.BTimeSynchConfig;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import java.text.MessageFormat;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTimeSynchJob
extends BDeviceManagerJob {
    public static final Type TYPE;
    static Lexicon lex;
    private BBacnetNetwork bacnet;
    private BTimeSynchConfig params;
    static /* synthetic */ Class class$com$tridium$bacnet$job$BTimeSynchJob;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$network$BNetworkPort;

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        boolean bl = this.params.getTimeSynchType();
        log.message("Sending " + (bl ? "UTC" : "") + " time to BACnet network...");
        try {
            if (this.params.getAddressRange()) {
                BBacnetRecipient bBacnetRecipient = new BBacnetRecipient(BBacnetAddress.GLOBAL_BROADCAST_ADDRESS);
                if (bl) {
                    this.client().utcTimeSynch(bBacnetRecipient);
                } else {
                    this.client().timeSynch(bBacnetRecipient);
                }
            } else {
                BBacnetNetworkLayer bBacnetNetworkLayer = this.network();
                Class clazz = class$com$tridium$bacnet$stack$network$BNetworkPort;
                if (clazz == null) {
                    clazz = class$com$tridium$bacnet$stack$network$BNetworkPort = BTimeSynchJob.class("[Lcom.tridium.bacnet.stack.network.BNetworkPort;", false);
                }
                BNetworkPort[] bNetworkPortArray = (BNetworkPort[])bBacnetNetworkLayer.getChildren(clazz);
                int n = 0;
                while (n < bNetworkPortArray.length) {
                    if (bNetworkPortArray[n].getStatus().isOk()) {
                        BBacnetRecipient bBacnetRecipient = new BBacnetRecipient(new BBacnetAddress(bNetworkPortArray[n].getNetworkNumber(), BBacnetOctetString.DEFAULT));
                        if (bl) {
                            this.client().utcTimeSynch(bBacnetRecipient);
                        } else {
                            this.client().timeSynch(bBacnetRecipient);
                        }
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            log.message("Exception sending TimeSynch: " + exception, (Throwable)exception);
            String string = MessageFormat.format(lex.getText("timeSynch.fail"), exception);
            this.add("failureCause", (BValue)BString.make((String)exception.toString()));
            this.log().failed(string);
            throw exception;
        }
    }

    private final BBacnetNetworkLayer network() {
        return ((BBacnetStack)this.bacnet.getBacnetComm()).getNetwork();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BTimeSynchJob() {
    }

    public BTimeSynchJob(BBacnetNetwork bBacnetNetwork, BTimeSynchConfig bTimeSynchConfig) {
        super(bBacnetNetwork);
        this.bacnet = bBacnetNetwork;
        this.params = bTimeSynchConfig;
    }

    static {
        Class clazz = class$com$tridium$bacnet$job$BTimeSynchJob;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$job$BTimeSynchJob = BTimeSynchJob.class("[Lcom.tridium.bacnet.job.BTimeSynchJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"bacnet");
    }
}

