/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.datatypes.BChangeDeviceIdConfig;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import com.tridium.bacnet.stack.IAmListener;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BChangeDeviceIdJob
extends BDeviceManagerJob
implements IAmListener {
    public static final Property config = BChangeDeviceIdJob.newProperty((int)0, (BValue)new BChangeDeviceIdConfig(), null);
    public static final Type TYPE;
    boolean exists;
    Array dups;
    int[] currs;
    BBacnetDevice[] currDevs;
    int[] news;
    BBacnetAddress[] found;
    static /* synthetic */ Class class$com$tridium$bacnet$job$BChangeDeviceIdJob;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier;

    public BChangeDeviceIdConfig getConfig() {
        return (BChangeDeviceIdConfig)this.get(config);
    }

    public void setConfig(BChangeDeviceIdConfig bChangeDeviceIdConfig) {
        this.set(config, (BValue)bChangeDeviceIdConfig, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void receiveIAm(IAmRequest iAmRequest, BBacnetAddress bBacnetAddress) {
        int n = iAmRequest.getObjectId().getInstanceNumber();
        int n2 = 0;
        while (n2 < this.news.length) {
            if (n == this.news[n2]) {
                String string = "I-Am " + (Object)((Object)iAmRequest.getObjectId()) + " from " + bBacnetAddress + "  matches proposed newId for device " + this.currDevs[n2];
                this.log().failed(string);
                this.dups.add((Object)string);
                this.found[n2] = bBacnetAddress;
                this.exists = true;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Context var1_1) throws Exception {
        try {
            block22: {
                try {
                    this.log().message("Sanity checks on current and new device IDS...");
                    this.server().registerIAmListener(this);
                    if (this.currs.length != this.news.length) {
                        throw new IllegalArgumentException("Current ids length != New ids length");
                    }
                    this.currDevs = new BBacnetDevice[this.currs.length];
                    var4_2 = 0;
                    while (true) {
                        if (var4_2 >= this.currDevs.length) break;
                        var5_5 = BBacnetObjectIdentifier.make(8, this.currs[var4_2]);
                        var6_8 = this.bacnet.lookupDeviceById(var5_5);
                        if (var6_8 == null) {
                            throw new IllegalArgumentException("Unable to locate existing device for id " + (Object)var5_5);
                        }
                        this.currDevs[var4_2] = var6_8;
                        ++var4_2;
                    }
                    this.found = new BBacnetAddress[this.currs.length];
                    var4_2 = 0;
                    while (true) {
                        if (var4_2 >= this.found.length) break;
                        this.found[var4_2] = null;
                        ++var4_2;
                    }
                    var4_2 = 0;
                    while (true) {
                        if (var4_2 >= this.news.length) break;
                        var5_6 = this.news[var4_2];
                        var6_9 = var4_2 + 1;
                        while (true) {
                            if (var6_9 >= this.news.length) {
                                var6_8 = this.bacnet.doLookupDeviceById(BBacnetObjectIdentifier.make(8, var5_6));
                                if (var6_8 == null) break;
                                throw new IllegalArgumentException("New instance " + var5_6 + " is a duplicate of database device " + var6_8);
                            }
                            if (var5_6 == this.news[var6_9]) {
                                throw new IllegalArgumentException("Duplicate instance in list of new IDs");
                            }
                            ++var6_9;
                        }
                        this.log().message("Who-Is for instance " + var5_6);
                        this.client().whoIs(BBacnetAddress.GLOBAL_BROADCAST_ADDRESS, var5_6, var5_6);
                        ++var4_2;
                    }
                    var4_3 = Clock.time();
                    var5_5 = var4_3.add(BRelTime.makeSeconds((int)5));
                    var6_8 = var4_3;
                    while (true) {
                        if (!var6_8.isBefore((BAbsTime)var5_5)) {
                            if (this.exists != false) throw new IllegalStateException("Existing devices were detected for some ids!");
                            var7_11 = 0;
                            break;
                        }
                        var7_11 = (int)((float)(var6_8.getMillis() - var4_3.getMillis()) / (float)(var5_5.getMillis() - var4_3.getMillis()) * 100.0f);
                        this.log().message("waiting on I-Ams (" + var7_11 + "%%)...");
                        this.progress(var7_11);
                        var6_8 = Clock.time();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException v0) {}
                    }
                    while (var7_11 < this.currs.length) {
                        var8_12 = this.currDevs[var7_11];
                        var9_13 = BBacnetObjectIdentifier.make(8, this.news[var7_11]);
                        this.log().message("Changing deviceId on " + var8_12 + " from " + (Object)var8_12.getObjectId() + " to " + (Object)var9_13);
                        var10_14 = var8_12.getConfig().getDeviceObject();
                        this.client().writeProperty(var8_12.getAddress(), var8_12.getObjectId(), 75, -1, AsnUtil.toAsnObjectId(var9_13), -1);
                        var10_14.setObjectId(var9_13);
                        this.log().message("Successfully changed local and remote device ID to " + (Object)var9_13 + " for device " + var8_12);
                        ++var7_11;
                    }
                    ** GOTO lbl-1000
                }
                catch (Exception var4_4) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException v1) {}
                    if (!this.exists || this.dups.size() == 0) {
                        var5_7 = var4_4.toString();
                        break block22;
                    }
                    var5_7 = var4_4.getMessage();
                    var6_10 = this.dups.iterator();
                }
                while (var6_10.hasNext()) {
                    var5_7 = var5_7 + '\n' + var6_10.next();
                }
            }
            this.add("failureCause", (BValue)BString.make((String)var5_7), 1, BFacets.make((String)"multiLine", (boolean)true), null);
            throw var4_4;
        }
        catch (Throwable var2_15) {
            var3_16 = null;
            this.server().unregisterIAmListener(this);
            throw var2_15;
        }
lbl-1000:
        // 1 sources

        {
            var3_17 = null;
            this.server().unregisterIAmListener(this);
            return;
        }
    }

    public String toString(Context context) {
        return this.getConfig().toString(context);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.exists = false;
        this.dups = new Array();
    }

    public BChangeDeviceIdJob() {
        this.this();
    }

    /*
     * Unable to fully structure code
     */
    public BChangeDeviceIdJob(BBacnetNetwork var1_1, BChangeDeviceIdConfig var2_2) {
        super(var1_1);
        this.this();
        this.setConfig(var2_2);
        var3_3 = this.getConfig().getProperties();
        v0 = BChangeDeviceIdJob.class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier;
        if (v0 == null) {
            v0 = BChangeDeviceIdJob.class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier = BChangeDeviceIdJob.class("[Ljavax.baja.bacnet.datatypes.BBacnetObjectIdentifier;", false);
        }
        var4_4 = new Array(v0);
        v1 = BChangeDeviceIdJob.class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier;
        if (v1 == null) {
            v1 = BChangeDeviceIdJob.class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier = BChangeDeviceIdJob.class("[Ljavax.baja.bacnet.datatypes.BBacnetObjectIdentifier;", false);
        }
        var5_5 = new Array(v1);
        if (true) ** GOTO lbl22
        do {
            if ((var6_6 = var3_3.property()).getName().startsWith("currentId")) {
                var4_4.add((Object)var3_3.get());
            } else if (var6_6.getName().startsWith("changeTo")) {
                var5_5.add((Object)var3_3.get());
            }
lbl22:
            // 5 sources

            if ((v2 = BChangeDeviceIdJob.class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier) != null) continue;
            v2 = BChangeDeviceIdJob.class("[Ljavax.baja.bacnet.datatypes.BBacnetObjectIdentifier;", false);
        } while (var3_3.next(v2));
        var6_7 = var4_4.size();
        var7_8 = var5_5.size();
        this.currs = new int[var6_7];
        this.news = new int[var7_8];
        var8_9 = 0;
        while (var8_9 < var6_7) {
            this.currs[var8_9] = ((BBacnetObjectIdentifier)var4_4.get(var8_9)).getInstanceNumber();
            ++var8_9;
        }
        var8_9 = 0;
        while (var8_9 < var7_8) {
            this.news[var8_9] = ((BBacnetObjectIdentifier)var5_5.get(var8_9)).getInstanceNumber();
            ++var8_9;
        }
    }

    static {
        Class clazz = class$com$tridium$bacnet$job$BChangeDeviceIdJob;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$job$BChangeDeviceIdJob = BChangeDeviceIdJob.class("[Lcom.tridium.bacnet.job.BChangeDeviceIdJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

