/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BBacnetDiscoverJob;
import com.tridium.bacnet.job.BDiscoverySchedule;
import com.tridium.bacnet.schedule.BBacnetScheduleDeviceExt;
import com.tridium.bacnet.schedule.ScheduleSupport0;
import com.tridium.bacnet.schedule.ScheduleType;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAny;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.driver.BDeviceExt;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BStringSchedule;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetDiscoverSchedulesJob
extends BBacnetDiscoverJob {
    public static final Type TYPE;
    private static final int[] SCHEDULE_PROPS_PRE_V4;
    private static final int[] SCHEDULE_PROPS_V4;
    private static final AsnInputStream asnIn;
    private BBacnetScheduleDeviceExt deviceExt;
    static /* synthetic */ Class class$com$tridium$bacnet$job$BBacnetDiscoverSchedulesJob;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference;

    public Type getType() {
        return TYPE;
    }

    protected boolean doForId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        int n = bBacnetObjectIdentifier.getObjectType();
        boolean bl = false;
        if (n == 17 || n == 6) {
            bl = true;
        }
        return bl;
    }

    int[] getDiscoveryPropIds(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        int n = bBacnetObjectIdentifier.getObjectType();
        if (n == 6) {
            return DESCRIPTION_ONLY;
        }
        if (n == 17) {
            if (this.device.getProtocolRevision() >= 4) {
                return SCHEDULE_PROPS_V4;
            }
            return SCHEDULE_PROPS_PRE_V4;
        }
        return DESCRIPTION_ONLY;
    }

    void addDiscoveryChild(BBacnetDiscoverJob.IdVals idVals) {
        ScheduleType scheduleType = this.findScheduleType(idVals);
        BDiscoverySchedule bDiscoverySchedule = new BDiscoverySchedule(idVals.name, idVals.id, scheduleType.getDataType(), scheduleType.getScheduleType());
        BBacnetDiscoverJob.PropVal propVal = idVals.get(28);
        if (propVal != null) {
            bDiscoverySchedule.setDescription(propVal.toString());
        }
        this.add(null, (BValue)bDiscoverySchedule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ScheduleType findScheduleType(BBacnetDiscoverJob.IdVals idVals) {
        BBacnetDiscoverJob.PropVal propVal;
        if (idVals.id.getObjectType() == 6) {
            return new ScheduleType(BCalendarSchedule.TYPE.toString(), "");
        }
        if (log.isTraceOn()) {
            log.trace("findScheduletype: iv=" + idVals);
        }
        ScheduleType scheduleType = null;
        if (this.device.getProtocolRevision() >= 4) {
            propVal = idVals.get(174);
            scheduleType = this.getScheduleType(propVal);
            if (log.isTraceOn()) {
                log.trace("st from Sched_Def: def=" + propVal.dbg() + "; st=" + scheduleType);
            }
        }
        if (scheduleType != null) {
            return scheduleType;
        }
        propVal = idVals.get(85);
        scheduleType = this.getScheduleType(propVal);
        if (log.isTraceOn()) {
            log.trace("st from Pres_Val: def=" + propVal.dbg() + "; st=" + scheduleType);
        }
        if (scheduleType != null) {
            return scheduleType;
        }
        BBacnetDiscoverJob.PropVal propVal2 = idVals.get(54);
        scheduleType = this.getScheduleType(propVal2);
        if (log.isTraceOn()) {
            log.trace("st from LoOPRs: loopr=" + propVal.dbg() + "; st=" + scheduleType);
        }
        if (scheduleType != null) {
            return scheduleType;
        }
        this.log().message("Trying to determine schedule type for " + (Object)((Object)idVals.id) + " from Weekly_Schedule...");
        int n = 0;
        byte[] byArray = null;
        try {
            n = 1;
            while (n <= 7) {
                byArray = BBacnetDiscoverSchedulesJob.client().readProperty(this.device.getAddress(), idVals.id, 123, n);
                AsnInputStream asnInputStream = asnIn;
                synchronized (asnInputStream) {
                    asnIn.setBuffer(byArray);
                    scheduleType = this.supp().getScheduleType(0, asnIn);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 12] lbl37 : MonitorExitStatement: MONITOREXIT : var7_7
                    if (scheduleType != null) {
                        return scheduleType;
                    }
                }
                ++n;
            }
        }
        catch (AsnException asnException) {
            this.log().failed("   ERROR: Unable to convert ASN-encoded Weekly_Schedule[" + n + "] (" + ByteArrayUtil.toHexString(byArray) + ") for object " + (Object)((Object)idVals.id));
            log.message("Unable to convert ASN-encoded Weekly_Schedule[" + n + "] (" + ByteArrayUtil.toHexString((byte[])byArray) + ") for object " + (Object)((Object)idVals.id));
        }
        catch (BacnetException bacnetException) {
            log.message("Error reading Weekly_Schedule[" + n + "] for " + (Object)((Object)idVals.id) + ':' + (Object)((Object)bacnetException));
        }
        this.log().message("Trying to determine schedule type for " + (Object)((Object)idVals.id) + " from Excepion_Schedule...");
        try {
            int n2 = AsnUtil.fromAsnUnsignedInt(BBacnetDiscoverSchedulesJob.client().readProperty(this.device.getAddress(), idVals.id, 38, 0));
            n = 1;
            while (n <= n2) {
                byArray = BBacnetDiscoverSchedulesJob.client().readProperty(this.device.getAddress(), idVals.id, 38, n);
                AsnInputStream asnInputStream = asnIn;
                synchronized (asnInputStream) {
                    asnIn.setBuffer(byArray);
                    int n3 = asnIn.peekTag();
                    while (true) {
                        if (n3 == -1 || asnIn.isOpeningTag(2)) {
                            if (n3 != -1) {
                                scheduleType = this.supp().getScheduleType(2, asnIn);
                            }
                            // MONITOREXIT @DISABLED, blocks:[16, 2, 5, 13, 14] lbl72 : MonitorExitStatement: MONITOREXIT : var8_13
                            if (scheduleType == null) break;
                            return scheduleType;
                        }
                        asnIn.skipTag();
                        n3 = asnIn.peekTag();
                    }
                }
                ++n;
            }
        }
        catch (AsnException asnException) {
            this.log().failed("   ERROR: Unable to convert ASN-encoded Exception_Schedule[" + n + "] (" + ByteArrayUtil.toHexString((byte[])byArray) + ") for object " + (Object)((Object)idVals.id));
            log.message("Unable to convert ASN-encoded Exception_Schedule[" + n + "] (" + ByteArrayUtil.toHexString((byte[])byArray) + ") for object " + (Object)((Object)idVals.id));
        }
        catch (Exception exception) {
            log.message("Error reading Exception_Schedule[" + n + "] for " + (Object)((Object)idVals.id) + ':' + exception);
        }
        this.log().failed("Unable to determine schedule type for " + (Object)((Object)idVals.id) + "!! Defaulting to String schedule type...");
        return new ScheduleType(BStringSchedule.TYPE.toString());
    }

    /*
     * Unable to fully structure code
     */
    private final ScheduleType getScheduleType(BBacnetDiscoverJob.PropVal var1_1) {
        block15: {
            if (var1_1 == null) {
                return null;
            }
            if (BBacnetDiscoverSchedulesJob.log.isTraceOn()) {
                BBacnetDiscoverSchedulesJob.log.trace("getScheduleType: pv=" + var1_1);
            }
            if ((var2_2 = var1_1.val) == null) {
                return null;
            }
            if (var2_2 instanceof BBacnetAny) {
                var2_2 = ((BBacnetAny)var2_2).getValue();
            }
            if (var2_2 instanceof BBacnetNull) {
                return null;
            }
            if (!(var2_2 instanceof BBacnetListOf)) break block15;
            var3_3 = (BBacnetListOf)var2_2;
            var4_5 = var3_3.getProperties();
            var5_7 = null;
            if (true) ** GOTO lbl19
            do {
                if ((var5_7 = this.scheduleTypeFromRef((BBacnetDeviceObjectPropertyReference)var4_5.get())) != null) {
                    return var5_7;
                }
lbl19:
                // 3 sources

                if ((v0 = BBacnetDiscoverSchedulesJob.class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference) != null) continue;
                v0 = BBacnetDiscoverSchedulesJob.class("[Ljavax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;", false);
            } while (var4_5.next(v0));
            return null;
        }
        var3_4 = AsnUtil.getAsnType(var2_2.getType());
        var4_6 = AsnUtil.getAsnTypeName(var3_4);
        if (BBacnetDiscoverSchedulesJob.log.isTraceOn()) {
            BBacnetDiscoverSchedulesJob.log.trace("  v=" + var2_2 + " [" + var2_2.getType() + "]; dt=" + var4_6);
        }
        if (var3_4 != 0) {
            switch (var3_4) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new ScheduleType(BBooleanSchedule.TYPE.toString(), var4_6);
                }
                case 4: 
                case 5: {
                    return new ScheduleType(BNumericSchedule.TYPE.toString(), var4_6);
                }
                case 2: 
                case 3: 
                case 9: {
                    return new ScheduleType(BEnumSchedule.TYPE.toString(), var4_6);
                }
            }
        }
        return new ScheduleType(BStringSchedule.TYPE.toString(), var4_6);
    }

    private final ScheduleType scheduleTypeFromRef(BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference) {
        int n = bBacnetDeviceObjectPropertyReference.getObjectId().getObjectType();
        int n2 = bBacnetDeviceObjectPropertyReference.getPropertyId();
        PropertyInfo propertyInfo = this.device().getPropertyInfo(n, n2);
        if (propertyInfo != null) {
            String string = AsnUtil.getAsnTypeName(propertyInfo.getAsnType());
            switch (propertyInfo.getAsnType()) {
                case 4: 
                case 5: {
                    return new ScheduleType(BNumericSchedule.TYPE.toString(), string);
                }
                case 1: {
                    return new ScheduleType(BBooleanSchedule.TYPE.toString(), string);
                }
                case 2: 
                case 3: 
                case 9: {
                    return new ScheduleType(BEnumSchedule.TYPE.toString(), string);
                }
                case 0: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    return new ScheduleType(BStringSchedule.TYPE.toString(), string);
                }
            }
        }
        return null;
    }

    private final ScheduleSupport0 supp() {
        return this.deviceExt.getSupport();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetDiscoverSchedulesJob() {
    }

    public BBacnetDiscoverSchedulesJob(BBacnetScheduleDeviceExt bBacnetScheduleDeviceExt) {
        super((BDeviceExt)bBacnetScheduleDeviceExt);
        this.deviceExt = bBacnetScheduleDeviceExt;
    }

    static {
        Class clazz = class$com$tridium$bacnet$job$BBacnetDiscoverSchedulesJob;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$job$BBacnetDiscoverSchedulesJob = BBacnetDiscoverSchedulesJob.class("[Lcom.tridium.bacnet.job.BBacnetDiscoverSchedulesJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        SCHEDULE_PROPS_PRE_V4 = new int[]{85, 54, 28};
        SCHEDULE_PROPS_V4 = new int[]{174, 85, 54, 28};
        asnIn = new AsnInputStream();
    }
}

